/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.IOException;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class NameTable
extends TTFTable {
    int format;
    int recordsCount;
    int stringOffset;
    int[] Platforms;
    int[] platformSpecificIDs;
    int[] languageIDs;
    int[] nameIDs;
    int[] lengths;
    int[] offsets;
    String[] names;
    public String copyRightNotice;
    public String familyName;
    public String subFamilyName;
    public String fullName;
    public String fontName;

    public void loadFontData(TrueTypeFontFileReader trueTypeFontFileReader) {
        try {
            trueTypeFontFileReader.seekTable(this);
            this.format = trueTypeFontFileReader.readUInt16();
            this.recordsCount = trueTypeFontFileReader.readUInt16();
            this.stringOffset = trueTypeFontFileReader.readUInt16();
            this.Platforms = new int[this.recordsCount];
            this.platformSpecificIDs = new int[this.recordsCount];
            this.languageIDs = new int[this.recordsCount];
            this.nameIDs = new int[this.recordsCount];
            this.lengths = new int[this.recordsCount];
            this.offsets = new int[this.recordsCount];
            this.names = new String[this.recordsCount];
            long l = trueTypeFontFileReader.getFilePointer();
            int n = 0;
            while (n < this.recordsCount) {
                trueTypeFontFileReader.seek(l + (long)(n * 12));
                this.Platforms[n] = trueTypeFontFileReader.readUInt16();
                this.platformSpecificIDs[n] = trueTypeFontFileReader.readUInt16();
                this.languageIDs[n] = trueTypeFontFileReader.readUInt16();
                this.nameIDs[n] = trueTypeFontFileReader.readUInt16();
                this.lengths[n] = trueTypeFontFileReader.readUInt16();
                this.offsets[n] = trueTypeFontFileReader.readUInt16();
                trueTypeFontFileReader.seek(this.offset + (long)this.stringOffset + (long)this.offsets[n]);
                if (this.Platforms[n] == 1) {
                    this.names[n] = trueTypeFontFileReader.readByteString(this.lengths[n]);
                } else if (this.Platforms[n] == 3) {
                    this.names[n] = trueTypeFontFileReader.readChars(this.lengths[n] / 2);
                }
                switch (this.nameIDs[n]) {
                    case 0: {
                        this.copyRightNotice = this.names[n];
                        break;
                    }
                    case 1: {
                        this.familyName = this.names[n];
                        break;
                    }
                    case 2: {
                        this.subFamilyName = this.names[n];
                        break;
                    }
                    case 4: {
                        this.fullName = this.names[n];
                        break;
                    }
                    case 6: {
                        this.fontName = this.names[n];
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {}
    }

    public String toString() {
        String string = null;
        string = "[  copyRightNotice: " + this.copyRightNotice + "\n" + "  familyName: " + this.familyName + "\n" + "  subFamilyName: " + this.subFamilyName + "\n" + "  fullName: " + this.fullName + "\n" + "  fontName: " + this.fontName + "  ]";
        return string;
    }

    public String getCopyRightNotice() {
        return this.copyRightNotice;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFormat() {
        return this.format;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }
}

