/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.PrintWriter;
import java.io.StringWriter;
import option.io.pdfcommon.font.EmbedFontFile;
import option.io.pdfcommon.font.Style;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class FontDescriptor
extends PdfIndirectObject
implements DefinedName {
    private PdfDictionary dict = new PdfDictionary();
    private PdfName fontName;
    private EmbedFontFile mEmbedFontFile;

    public FontDescriptor() {
        this.dict.put(DefinedName.TYPE, DefinedName.FONTDESCRIPTOR);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        printWriter.println(this.dict);
        printWriter.println("endobj");
        return stringWriter.toString();
    }

    public void write(PdfOutFile pdfOutFile) {
        if (this.mEmbedFontFile != null) {
            this.dict.put(DefinedName.FONTFILE2, this.mEmbedFontFile.getReference());
        }
        this.startObject(pdfOutFile);
        this.dict.write(pdfOutFile);
        this.endObject(pdfOutFile);
    }

    public void setAscent(int n) {
        this.dict.put(DefinedName.ASCENT, new Integer(n));
    }

    public int getAscent() {
        return (Integer)this.dict.get(DefinedName.ASCENT);
    }

    public void setCapHeight(int n) {
        this.dict.put(DefinedName.CAPHEIGHT, new Integer(n));
    }

    public void setDescent(int n) {
        this.dict.put(DefinedName.DESCENT, new Integer(n));
    }

    public int getDescent() {
        return (Integer)this.dict.get(DefinedName.DESCENT);
    }

    public void setFlags(int n) {
        this.dict.put(DefinedName.FLAGS, new Integer(n));
    }

    public void setFontBBox(PdfRect pdfRect) {
        this.dict.put(DefinedName.FONTBBOX, pdfRect);
    }

    public void setFontName(PdfName pdfName) {
        this.fontName = pdfName;
        this.dict.put(DefinedName.FONTNAME, pdfName);
    }

    public void setItalicAngle(int n) {
        this.dict.put(DefinedName.ITALICANGLE, new Integer(n));
    }

    public void setStemV(int n) {
        this.dict.put(DefinedName.STEMV, new Integer(n));
    }

    public void setAvgWidth(int n) {
        this.dict.put(DefinedName.AVGWIDTH, new Integer(n));
    }

    public void setLeading(int n) {
        this.dict.put(DefinedName.LEADING, new Integer(n));
    }

    public void setMaxWidth(int n) {
        this.dict.put(DefinedName.MAXWIDTH, new Integer(n));
    }

    public void setMissingWidth(int n) {
        this.dict.put(DefinedName.MISSINGWIDTH, new Integer(n));
    }

    public void setStemH(int n) {
        this.dict.put(DefinedName.STEMH, new Integer(n));
    }

    public void setXHeight(int n) {
        this.dict.put(DefinedName.XHEIGHT, new Integer(n));
    }

    public void setCharSet(String string) {
        this.dict.put(DefinedName.CHARSET, "(" + string + ")");
    }

    public void setStyle(Style style) {
        this.dict.put(DefinedName.STYLE, style);
    }

    public void setLang(PdfName pdfName) {
        this.dict.put(DefinedName.LANG, pdfName);
    }

    public void setFontfile2(String string) {
        this.dict.put(DefinedName.FONTFILE2, string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FontDescriptor fontDescriptor = (FontDescriptor)object;
        return this.getFontName().equals(fontDescriptor.getFontName());
    }

    public int hashCode() {
        return this.getFontName().hashCode();
    }

    public PdfName getFontName() {
        return this.fontName;
    }

    public EmbedFontFile getMEmbedFontFile() {
        return this.mEmbedFontFile;
    }

    public void setMEmbedFontFile(EmbedFontFile embedFontFile) {
        this.mEmbedFontFile = embedFontFile;
    }
}

