/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.PdfAction;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.DictObj;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class PdfAnnotation
extends DictObj {
    private PdfName mySubType;
    private PdfRect rec;

    public PdfAnnotation(Body body) {
        super(body);
        this.dict.put(DefinedName.TYPE, DefinedName.ANNOT);
    }

    public void updateDict() {
        this.dict.put(DefinedName.SUBTYPE, this.mySubType);
        this.dict.put(DefinedName.RECT, this.rec);
    }

    public PdfAnnotation createURILink(Body body, String string, PdfRect pdfRect) {
        PdfAction pdfAction = new PdfAction().getLinkActionDictionary(string);
        PdfAnnotation pdfAnnotation = new PdfAnnotation(body);
        pdfAnnotation.mySubType = DefinedName.LINK;
        pdfAnnotation.rec = pdfRect;
        pdfAnnotation.dict.put(DefinedName.A, pdfAction);
        return pdfAnnotation;
    }

    public PdfAnnotation createLink(Body body, String string, PdfRect pdfRect, float f) {
        PdfAnnotation pdfAnnotation = new PdfAnnotation(body);
        PdfAction pdfAction = new PdfAction().getLinkActionDictionary(string);
        pdfAction.parentSubTypeName = DefinedName.LINK;
        pdfAnnotation.mySubType = DefinedName.LINK;
        pdfAnnotation.rec = pdfRect;
        PdfArray pdfArray = new PdfArray();
        if (f > 0.0f) {
            pdfArray.addElement(new Integer(0));
            pdfArray.addElement(new Integer(0));
            pdfArray.addElement(new Float(f));
        } else {
            pdfArray.addElement(new Integer(0));
            pdfArray.addElement(new Integer(0));
            pdfArray.addElement(new Float(0.0f));
        }
        pdfAnnotation.dict.put(DefinedName.BORDER, pdfArray);
        pdfAnnotation.dict.put(DefinedName.A, pdfAction);
        return pdfAnnotation;
    }
}

