/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import option.io.pdfcommon.PdfDataConst;
import option.io.pdfcommon.util.PdfRect;

public class PageSize
implements PdfDataConst {
    private int mDpi = 72;
    private float mRate = (float)this.mDpi * 1.0f / 25.4f;

    public PageSize() {
    }

    public PageSize(int n) {
        this.setDpi(n);
    }

    public int getDpi() {
        return this.mDpi;
    }

    public void setDpi(int n) {
        this.mDpi = n;
        this.mRate = (float)this.mDpi / 25.4f;
    }

    public float getRate() {
        return this.mRate;
    }

    public PdfRect getPageRect(String string) {
        float[] fArray = PageSize.getMideaWH(string);
        if (fArray == null) {
            return null;
        }
        return new PdfRect(0.0f, 0.0f, fArray[0] * this.getRate(), fArray[1] * this.getRate());
    }

    public PdfRect getPageRect(String string, int n) {
        PdfRect pdfRect = this.getPageRect(string);
        if (n == 1) {
            pdfRect.changeDirection();
        }
        return pdfRect;
    }

    public static PdfRect getPagemm(String string) {
        float[] fArray = PageSize.getMideaWH(string);
        if (fArray == null) {
            return null;
        }
        return new PdfRect(0.0f, 0.0f, fArray[0], fArray[1]);
    }

    public static PdfRect getPagemm(String string, int n) {
        PdfRect pdfRect = PageSize.getPagemm(string);
        if (n > 0) {
            pdfRect.changeDirection();
        }
        return pdfRect;
    }

    private static float[] getMideaWH(String string) {
        int n = PageSize.indexOfMediaSize(string);
        if (n < 0) {
            return null;
        }
        return PdfDataConst.MEDIA_SIZE[n];
    }

    private static int indexOfMediaSize(String string) {
        if (string == null) {
            return -1;
        }
        if ((string = string.trim().toUpperCase()).length() != 2) {
            return -1;
        }
        return "A1A2A3A4A5A6A6A7A9A10B1B2B3B4B5B6B7B8B9B10".indexOf(string) / 2;
    }
}

