/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import com.kt.util.RefList;
import d.d;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import option.io.pdfcommon.PdfDataConst;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Page;
import option.io.pdfcommon.document.PdfAnnotation;
import option.io.pdfcommon.document.Resources;
import option.io.pdfcommon.font.BaseJapanNoEmbedFont;
import option.io.pdfcommon.font.FontFactory;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.font.TrueTypeFont;
import option.io.pdfcommon.object.FormXObject;
import option.io.pdfcommon.object.ImageXObject;
import option.io.pdfcommon.object.ImageXObjectJpeg;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.StreamObj;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.pattern.Pattern;
import option.io.pdfcommon.pattern.Shading;
import option.io.pdfcommon.pattern.ShadingType2;
import option.io.pdfcommon.pattern.TilingPattern;
import option.io.pdfcommon.util.PdfMetrices;
import option.io.pdfcommon.util.PdfRect;
import option.io.pdfcommon.util.PdfUtil;

public class Contents
extends StreamObj
implements PdfDataConst {
    public static final int STATE_NONE = 0;
    public static final int STATE_TEXT = 1;
    public static final int STATE_IMAGE = 2;
    public static final int STATE_FORM = 3;
    public static final int STATE_GRAPH = 4;
    public static final int STATE_DEFAULT = 0;
    public static final float DEFAULT_CHAR_SPACING = 0.0f;
    public static final float DEFAULT_CHAR_SCALING = 100.0f;
    private int mState;
    private PdfMetrices mTextMetrices = new PdfMetrices(1);
    private Color mFillColor;
    private Color mStrokeColor;
    protected Body mBody;
    private Page parentPage;
    protected PdfRect mediabox;
    protected PrintStream mPrintStream;
    protected boolean isFontChanged = false;
    protected Resources resources;
    private LineStyle mLineStyle = null;
    private BaseJapanNoEmbedFont bjf = new BaseJapanNoEmbedFont();
    private PdfFont mFont;
    private float mCurrentMatrixA;
    private float mCurrentMatrixB;
    private float mCurrentMatrixC;
    private float mCurrentMatrixD;
    private float mCurrentMatrixE;
    private float mCurrentMatrixF;
    private int mCurrentFontStyle;
    private float mCurrentCharSpacing;
    private float mCurrentCharScaling;
    private PdfUtil mPdfUtil;
    private PdfRect mClipRect;
    private Hashtable mUsingEmbededFonts;

    public Contents() {
        this.mFont = this.bjf.DEFAULT_FONT;
        this.mCurrentMatrixA = 1.0f;
        this.mCurrentMatrixB = 0.0f;
        this.mCurrentMatrixC = 0.0f;
        this.mCurrentMatrixD = 1.0f;
        this.mCurrentMatrixE = 0.0f;
        this.mCurrentMatrixF = 0.0f;
        this.mCurrentFontStyle = 0;
        this.mCurrentCharSpacing = 0.0f;
        this.mCurrentCharScaling = 100.0f;
        this.mPdfUtil = new PdfUtil();
        this.mUsingEmbededFonts = new Hashtable();
        this.flagStreamCompress = false;
        this.mPrintStream = this.stream.getPrintStream();
        this.mFont.setSize(4.233402f);
    }

    public Contents(Body body, PdfRect pdfRect) {
        this();
        this.mBody = body;
        this.resources = new Resources(body);
        this.mediabox = pdfRect;
        this.parentPage = body.getCurrentPage();
        this.pageCoor();
    }

    protected void finalize() throws Throwable {
        if (d.d) {
            System.out.println(String.valueOf(this.getClass().toString()) + " finalized!");
        }
        super.finalize();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        printWriter.println(this.dict);
        printWriter.println("stream");
        printWriter.println(this.stream);
        printWriter.println("endstream");
        printWriter.println("endobj");
        return stringWriter.toString();
    }

    public void setFillColor(Color color) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (color != null) {
            f = (float)color.getRed() / 255.0f;
            f2 = (float)color.getGreen() / 255.0f;
            f3 = (float)color.getBlue() / 255.0f;
        }
        this.setFillColor(f, f2, f3);
    }

    public Color getFillColor() {
        return this.mFillColor;
    }

    public void setFillColor(float f, float f2, float f3) {
        Color color = new Color(f, f2, f3);
        if (this.mFillColor != null && this.mFillColor.equals(color)) {
            return;
        }
        this.mFillColor = color;
        if (f == f2 && f2 == f3) {
            this.mPrintStream.println(String.valueOf(this.mPdfUtil.formatPrint(f)) + " g");
        } else {
            this.mPrintStream.println(String.valueOf(this.mPdfUtil.formatPrint(f)) + " " + this.mPdfUtil.formatPrint(f2) + " " + this.mPdfUtil.formatPrint(f3) + " rg");
        }
    }

    public void setStrokeColor(Color color) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (color != null) {
            f = (float)color.getRed() / 255.0f;
            f2 = (float)color.getGreen() / 255.0f;
            f3 = (float)color.getBlue() / 255.0f;
        }
        this.setStrokeColor(f, f2, f3);
    }

    public Color getStrokeColor() {
        return this.mStrokeColor;
    }

    public void setStrokeColor(float f, float f2, float f3) {
        Color color = new Color(f, f2, f3);
        if (this.mStrokeColor != null && this.mStrokeColor.equals(color)) {
            return;
        }
        this.mStrokeColor = color;
        if (f == f2 && f2 == f3) {
            this.mPrintStream.println(String.valueOf(this.mPdfUtil.formatPrint(f)) + " G");
        } else {
            this.mPrintStream.println(String.valueOf(this.mPdfUtil.formatPrint(f)) + " " + this.mPdfUtil.formatPrint(f2) + " " + this.mPdfUtil.formatPrint(f3) + " RG");
        }
    }

    public void setFillGray(float f) {
        if ((double)f >= 0.0 && (double)f <= 1.0) {
            this.setFillColor(f, f, f);
        }
    }

    public void setStrokeGray(float f) {
        if ((double)f >= 0.0 && (double)f <= 1.0) {
            this.setStrokeColor(f, f, f);
        }
    }

    public void setLStyle(LineStyle lineStyle) {
        this.mLineStyle = lineStyle != null ? lineStyle : new LineStyle();
        this.mPrintStream.println(this.mLineStyle.toString());
    }

    public void setLineWidth(float f) {
        this.mPrintStream.println(String.valueOf(f) + " w");
    }

    private void cm(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.mCurrentMatrixA != f || this.mCurrentMatrixB != f2 || this.mCurrentMatrixC != f3 || this.mCurrentMatrixD != f4 || this.mCurrentMatrixE != f5 || this.mCurrentMatrixF != f6) {
            float f7 = 1.0f / (this.mCurrentMatrixA * this.mCurrentMatrixD - this.mCurrentMatrixB * this.mCurrentMatrixC);
            float f8 = this.mCurrentMatrixD * f7;
            float f9 = -this.mCurrentMatrixB * f7;
            float f10 = -this.mCurrentMatrixC * f7;
            float f11 = this.mCurrentMatrixA * f7;
            float f12 = (this.mCurrentMatrixC * this.mCurrentMatrixF - this.mCurrentMatrixD * this.mCurrentMatrixE) * f7;
            float f13 = (this.mCurrentMatrixB * this.mCurrentMatrixE - this.mCurrentMatrixA * this.mCurrentMatrixF) * f7;
            this.writeCurrentTransformationMatrix(f8, f9, f10, f11, f12, f13);
            this.mCurrentMatrixA = f;
            this.mCurrentMatrixB = f2;
            this.mCurrentMatrixC = f3;
            this.mCurrentMatrixD = f4;
            this.mCurrentMatrixE = f5;
            this.mCurrentMatrixF = f6;
            this.writeCurrentTransformationMatrix(f, f2, f3, f4, f5, f6);
        }
    }

    private void writeCurrentTransformationMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        if (f == 1.0f && Math.abs(f2) == 0.0f && Math.abs(f3) == 0.0f && f4 == 1.0f && Math.abs(f5) == 0.0f && Math.abs(f6) == 0.0f) {
            return;
        }
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f2, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f3, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f4, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f5, 4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f6, 4)) + " ");
        this.mPrintStream.println("cm");
    }

    private void identityCM() {
        this.mCurrentMatrixA = 1.0f;
        this.mCurrentMatrixB = 0.0f;
        this.mCurrentMatrixC = 0.0f;
        this.mCurrentMatrixD = 1.0f;
        this.mCurrentMatrixE = 0.0f;
        this.mCurrentMatrixF = 0.0f;
    }

    public void translate(float f, float f2) {
        this.cm(1.0f, 0.0f, 0.0f, 1.0f, f, f2);
    }

    public void scale(float f, float f2) {
        this.cm(0.0f, 0.0f, 0.0f, 0.0f, f, f2);
    }

    public void rotate(float f) {
        double d2 = (double)f * Math.PI / 180.0;
        this.cm((float)Math.cos(d2), (float)Math.sin(d2), -((float)Math.sin(d2)), (float)Math.cos(d2), 0.0f, 0.0f);
    }

    public void pageCoor() {
        this.writeCurrentTransformationMatrix(2.8346f, 0.0f, 0.0f, 2.8346f, 0.0f, 0.0f);
    }

    public void setDefaultCoor() {
        this.cm(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public void setFont(PdfFont pdfFont) {
        if (this.mFont != (pdfFont = this.mBody.addFont(pdfFont))) {
            this.isFontChanged = true;
            this.mFont = pdfFont;
        }
        this.resources.addFont(pdfFont);
    }

    private void setFont(String string, int n) {
        PdfFont pdfFont = this.bjf.getDefinedFont(string);
        if (pdfFont == null) {
            pdfFont = this.bjf.getBaseFont(string);
        }
        this.setFont(pdfFont);
    }

    public PdfFont getFont() {
        return this.mFont;
    }

    public void setFontSize(float f) {
        if (this.mFont != null && this.mFont.getSize() != f) {
            this.isFontChanged = true;
            this.mFont.setSize(f);
        }
    }

    public int getState() {
        return this.mState;
    }

    public void saveState(int n) {
        if (n == this.mState) {
            return;
        }
        this.loadState();
        if (this.mClipRect != null) {
            this.saveGraphicsState();
            this.clipRect();
        }
        switch (n) {
            case 1: {
                this.beginText();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.mClipRect != null) break;
                this.saveGraphicsState();
            }
        }
        this.mState = n;
    }

    private void loadState() {
        switch (this.mState) {
            case 1: {
                this.endText();
                if (this.mClipRect == null) break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.loadGraphicsState();
            }
        }
        this.mStrokeColor = null;
        this.mFillColor = null;
        this.mState = 0;
    }

    public void endContents() {
        this.loadState();
        this.closeUsingEmbededFonts();
    }

    private void closeUsingEmbededFonts() {
        if (d.d) {
            System.out.println("close called!");
        }
        Enumeration enumeration = this.mUsingEmbededFonts.elements();
        TrueTypeFont trueTypeFont = null;
        try {
            while (enumeration.hasMoreElements()) {
                trueTypeFont = (TrueTypeFont)enumeration.nextElement();
                trueTypeFont.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("**** FontFile=" + trueTypeFont.fontFileName);
            iOException.printStackTrace();
        }
        this.mUsingEmbededFonts.clear();
    }

    private void saveGraphicsState() {
        this.mPrintStream.println("q");
    }

    private void loadGraphicsState() {
        this.mPrintStream.println("Q");
        this.mPrintStream.println();
        this.mFillColor = null;
        this.mStrokeColor = null;
        this.mLineStyle = null;
        this.identityCM();
    }

    public void closePath() {
        this.mPrintStream.println("h");
    }

    public void strokePath() {
        this.mPrintStream.println("S");
    }

    public void closeAndStrokePath() {
        this.mPrintStream.println("s");
    }

    public void fillAndStorokePath(boolean bl) {
        this.mPrintStream.println("b" + (bl ? "" : "*"));
    }

    public void fillPath() {
        this.fillPath(true);
    }

    private void fillPathUsingOddEvenRule() {
        this.fillPath(false);
    }

    public void fillPath(boolean bl) {
        this.mPrintStream.println("f" + (bl ? "" : "*"));
    }

    public Resources getResources() {
        return this.resources;
    }

    private void drawForm(FormXObject formXObject, float f, float f2, float f3, float f4) {
        this.mBody.add(formXObject);
        this.resources.addXObject(formXObject);
        this.saveState(3);
        float f5 = f3 / formXObject.getWidth();
        float f6 = f4 / formXObject.getHeight();
        float f7 = f5 < f6 ? f5 : f6;
        formXObject.getMTransMatrices().setTranslation(f, f2);
        formXObject.getMTransMatrices().setScale(f7, f7);
        this.mPrintStream.println(formXObject.getMTransMatrices().toString());
        this.mPrintStream.println(formXObject.getName() + " Do");
        this.loadState();
    }

    private void imageDrawer(ImageXObject imageXObject, float f, float f2, float f3, float f4) {
        PdfName pdfName = imageXObject.getName();
        if (pdfName == null) {
            pdfName = new PdfName("Im" + String.valueOf(this.mBody.size() + 1));
            imageXObject.setName(pdfName);
        } else {
            this.resources.getXObjectDictionary().containsKey(pdfName);
        }
        this.saveState(2);
        this.mBody.add(imageXObject);
        this.resources.addXObject(imageXObject);
        this.resources.useImageC();
        imageXObject.getMTransMatrices().setTranslation(f, f2);
        imageXObject.getMTransMatrices().setScale(f3, f4);
        this.mPrintStream.print(imageXObject.getMTransMatrices().toString());
        this.mPrintStream.println(imageXObject.getName() + " Do");
        this.loadState();
    }

    public void beginPath(float f, float f2) {
        this.mPrintStream.print(this.mPdfUtil.formatPrint(f));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.mPdfUtil.formatPrint(f2));
        this.mPrintStream.println(" m");
    }

    public void linePath(float f, float f2) {
        this.mPrintStream.print(this.mPdfUtil.formatPrint(f));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.mPdfUtil.formatPrint(f2));
        this.mPrintStream.println(" l");
    }

    private void rectanglePath(float f, float f2, float f3, float f4) {
        this.mPrintStream.print(this.mPdfUtil.formatPrint(f));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.mPdfUtil.formatPrint(f2));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.mPdfUtil.formatPrint(f3));
        this.mPrintStream.print(" ");
        this.mPrintStream.print(this.mPdfUtil.formatPrint(f4));
        this.mPrintStream.println(" re");
    }

    private void ellipsePath(float f, float f2, float f3, float f4) {
        this.translate(f, f2);
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        double d2 = Math.cos(1.0471975511965976);
        double d3 = Math.sin(1.0471975511965976);
        dArray[2] = 1.0;
        dArray[1] = 1.0;
        dArray2[1] = 0.0;
        dArray[4] = d2;
        dArray2[4] = d3;
        dArray[3] = (8.0 * Math.cos(0.5235987755982988) - (dArray[1] + 3.0 * dArray[2] + dArray[4])) / 3.0;
        dArray2[3] = dArray2[4] - (-dArray[3] + dArray[4]) / -Math.tan(1.0471975511965976);
        dArray2[2] = (8.0 * Math.sin(0.5235987755982988) - (dArray2[1] + 3.0 * dArray2[3] + dArray2[4])) / 3.0;
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        this.beginPath((float)((double)f3 * dArray[1]), (float)(dArray2[1] * (double)f4));
        int n = 0;
        while (n < 6) {
            this.cubicBezierPath((float)((double)f3 * dArray[2]), (float)(dArray2[2] * (double)f4), (float)((double)f3 * dArray[3]), (float)(dArray2[3] * (double)f4), (float)((double)f3 * dArray[4]), (float)(dArray2[4] * (double)f4));
            int n2 = 2;
            while (n2 <= 4) {
                dArray3[n2] = dArray[n2] * d2 - dArray2[n2] * d3;
                dArray4[n2] = dArray[n2] * d3 + dArray2[n2] * d2;
                dArray[n2] = dArray3[n2];
                dArray2[n2] = dArray4[n2];
                ++n2;
            }
            ++n;
        }
        this.closePath();
    }

    private void circlePath(float f, float f2, float f3) {
        this.translate(f, f2);
        double d2 = Math.cos(1.0471975511965976);
        double d3 = Math.sin(1.0471975511965976);
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        dArray[2] = 1.0;
        dArray[1] = 1.0;
        dArray2[1] = 0.0;
        dArray[4] = d2;
        dArray2[4] = d3;
        dArray[3] = (8.0 * Math.cos(0.5235987755982988) - (dArray[1] + 3.0 * dArray[2] + dArray[4])) / 3.0;
        dArray2[3] = dArray2[4] - (-dArray[3] + dArray[4]) / -Math.tan(1.0471975511965976);
        dArray2[2] = (8.0 * Math.sin(0.5235987755982988) - (dArray2[1] + 3.0 * dArray2[3] + dArray2[4])) / 3.0;
        this.beginPath((float)((double)f3 * dArray[1]), (float)(dArray2[1] * (double)f3));
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        int n = 0;
        while (n < 6) {
            this.cubicBezierPath((float)((double)f3 * dArray[2]), (float)(dArray2[2] * (double)f3), (float)((double)f3 * dArray[3]), (float)(dArray2[3] * (double)f3), (float)((double)f3 * dArray[4]), (float)(dArray2[4] * (double)f3));
            int n2 = 2;
            while (n2 <= 4) {
                dArray3[n2] = dArray[n2] * d2 - dArray2[n2] * d3;
                dArray4[n2] = dArray[n2] * d3 + dArray2[n2] * d2;
                dArray[n2] = dArray3[n2];
                dArray2[n2] = dArray4[n2];
                ++n2;
            }
            ++n;
        }
        this.closePath();
    }

    private void arcPath(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        if (f6 <= 0.0f) {
            return;
        }
        this.translate(f, f2);
        float f7 = f3 * 2.0f;
        float f8 = f4 * 2.0f;
        double d2 = (double)f6 * Math.PI / 180.0;
        double d3 = d2 / 6.0;
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        dArray[2] = 1.0;
        dArray[1] = 1.0;
        dArray2[1] = 0.0;
        dArray[4] = d4;
        dArray2[4] = d5;
        dArray[3] = (8.0 * Math.cos(d3 / 2.0) - (dArray[1] + 3.0 * dArray[2] + dArray[4])) / 3.0;
        dArray2[3] = dArray2[4] - (-dArray[3] + dArray[4]) / -Math.tan(d3);
        dArray2[2] = (8.0 * Math.sin(d3 / 2.0) - (dArray2[1] + 3.0 * dArray2[3] + dArray2[4])) / 3.0;
        double d6 = (double)f5 * Math.PI / 180.0;
        double d7 = Math.cos(d6);
        double d8 = Math.sin(d6);
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        int n = 1;
        while (n <= 4) {
            dArray3[n] = dArray[n] * d7 - dArray2[n] * d8;
            dArray4[n] = dArray[n] * d8 + dArray2[n] * d7;
            dArray[n] = dArray3[n];
            dArray2[n] = dArray4[n];
            ++n;
        }
        float f9 = f8 / f7;
        if (Float.isNaN(f9)) {
            f9 = 1.0f;
        }
        if (bl) {
            this.beginPath(0.0f, 0.0f);
            this.linePath((float)((double)f3 * dArray[1]), (float)((double)f3 * dArray2[1]) * f9);
        } else {
            this.beginPath((float)((double)f3 * dArray[1]), (float)((double)f3 * dArray2[1]) * f9);
        }
        int n2 = 0;
        while (n2 < 6) {
            this.cubicBezierPath((float)((double)f3 * dArray[2]), (float)((double)f3 * dArray2[2]) * f9, (float)((double)f3 * dArray[3]), (float)((double)f3 * dArray2[3]) * f9, (float)((double)f3 * dArray[4]), (float)((double)f3 * dArray2[4]) * f9);
            int n3 = 2;
            while (n3 <= 4) {
                dArray3[n3] = dArray[n3] * d4 - dArray2[n3] * d5;
                dArray4[n3] = dArray[n3] * d5 + dArray2[n3] * d4;
                dArray[n3] = dArray3[n3];
                dArray2[n3] = dArray4[n3];
                ++n3;
            }
            ++n2;
        }
        if (bl) {
            this.closePath();
        }
    }

    private void arrayPolyPath(float[] fArray) {
        if (fArray.length < 2 || fArray.length % 2 != 0) {
            return;
        }
        this.beginPath(fArray[0], fArray[1]);
        int n = 2;
        while (n < fArray.length) {
            this.linePath(fArray[n], fArray[n + 1]);
            n += 2;
        }
    }

    private void reflistPath(RefList refList) {
        if (refList.size() < 2) {
            return;
        }
        Object object = refList.elementAt(0);
        if (object instanceof Point) {
            Point point = (Point)object;
            this.beginPath(point.x, point.y);
        }
        int n = 1;
        while (n < refList.size()) {
            object = refList.elementAt(n);
            if (object instanceof Point) {
                Point point = (Point)object;
                this.linePath(point.x, point.y);
            }
            ++n;
        }
    }

    private void polyPath(Polygon polygon) {
        this.beginPath(polygon.xpoints[0], polygon.ypoints[0]);
        int n = 1;
        while (n < polygon.npoints) {
            this.linePath(polygon.xpoints[n], polygon.ypoints[n]);
            ++n;
        }
    }

    public void cubicBezierPath(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f2)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f3)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f4)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f5)) + " ");
        this.mPrintStream.print(String.valueOf(this.mPdfUtil.formatPrint(f6)) + " ");
        this.mPrintStream.println("c");
    }

    public int[] color2RGB(Color color) {
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        return nArray;
    }

    public LineStyle getLStyle() {
        return this.mLineStyle;
    }

    public boolean isFlagCompress() {
        return this.flagStreamCompress;
    }

    public void setFlagCompress(boolean bl) {
        this.flagStreamCompress = bl;
    }

    public PdfRect getMediabox() {
        return this.mediabox;
    }

    public void writeLine(float f, float f2, float f3, float f4, Object object, Color color) {
        this.setDefaultCoor();
        if (this.mState == 4) {
            if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.beginPath(f, f2);
        this.linePath(f3, f4);
        this.strokePath();
    }

    public void writeRectangle(float f, float f2, float f3, float f4, Object object, Color color, boolean bl) {
        this.setDefaultCoor();
        if (bl) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.rectanglePath(f, f2, f3, f4);
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                    this.setStrokeColor(color);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                    this.setLStyle((LineStyle)object);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(color);
                this.setLStyle((LineStyle)object);
            }
            this.rectanglePath(f, f2, f3, f4);
            this.strokePath();
        }
    }

    public void writeArc(float f, float f2, float f3, float f4, float f5, float f6, Object object, Color color, boolean bl) {
        if (bl) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.arcPath(f, f2, f3, f4, f5, f6, bl);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                    this.setStrokeColor(color);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                    this.setLStyle((LineStyle)object);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(color);
                this.setLStyle((LineStyle)object);
            }
            this.arcPath(f, f2, f3, f4, f5, f6, bl);
            this.strokePath();
        }
    }

    public void writeEllipse(float f, float f2, float f3, float f4, Object object, Color color, boolean bl) {
        if (bl) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.ellipsePath(f, f2, f3, f4);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                    this.setStrokeColor(color);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                    this.setLStyle((LineStyle)object);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(color);
                this.setLStyle((LineStyle)object);
            }
            this.ellipsePath(f, f2, f3, f4);
            this.strokePath();
        }
    }

    public void writeCircle(float f, float f2, float f3, Object object, Color color, boolean bl) {
        if (bl) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.circlePath(f, f2, f3);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                    this.setStrokeColor(color);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                    this.setLStyle((LineStyle)object);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(color);
                this.setLStyle((LineStyle)object);
            }
            this.circlePath(f, f2, f3);
            this.strokePath();
        }
    }

    public void writePolygon(Polygon polygon, Object object, Color color, boolean bl) {
        this.setDefaultCoor();
        if (bl) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.polyPath(polygon);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                    this.setStrokeColor(color);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                    this.setLStyle((LineStyle)object);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(color);
                this.setLStyle((LineStyle)object);
            }
            this.polyPath(polygon);
            this.closeAndStrokePath();
        }
    }

    public void writePolygon(RefList refList, Object object, Color color, boolean bl) {
        this.setDefaultCoor();
        if (bl) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.reflistPath(refList);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                    this.setStrokeColor(color);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                    this.setLStyle((LineStyle)object);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(color);
                this.setLStyle((LineStyle)object);
            }
            this.reflistPath(refList);
            this.closeAndStrokePath();
        }
    }

    public void writePolygon(float[] fArray, Object object, Color color, boolean bl) {
        this.setDefaultCoor();
        if (bl) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            this.arrayPolyPath(fArray);
            this.closePath();
            this.fillPath();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                    this.setStrokeColor(color);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                    this.setLStyle((LineStyle)object);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(color);
                this.setLStyle((LineStyle)object);
            }
            this.arrayPolyPath(fArray);
            this.closeAndStrokePath();
        }
    }

    public void writePolyLine(RefList refList, Object object, Color color) {
        this.setDefaultCoor();
        if (this.mState == 4) {
            if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.reflistPath(refList);
        this.strokePath();
    }

    public void writePolyLine(float[] fArray, Object object, Color color) {
        this.setDefaultCoor();
        if (this.mState == 4) {
            if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                this.setStrokeColor(color);
            }
            if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                this.setLStyle((LineStyle)object);
            }
        } else {
            this.saveState(4);
            this.setStrokeColor(color);
            this.setLStyle((LineStyle)object);
        }
        this.arrayPolyPath(fArray);
        this.strokePath();
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl) {
        this.writeText(string, f, f2, string2, f3, color, bl, 0, 0.0f, 0.0f);
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl, int n) {
        this.writeText(string, f, f2, string2, f3, color, bl, n, 0.0f);
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl, int n, float f4) {
        this.writeText(string, f, f2, string2, f3, color, bl, n, f4, 0.0f);
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl, int n, float f4, float f5) {
        this.writeText(string, f, f2, string2, f3, color, bl, n, f4, f5, 0.0f, null);
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl, int n, float f4, float f5, float f6, String string3) {
        this.writeText(string, f, f2, string2, f3, color, bl, n, f4, f5, f6, string3, false);
    }

    public void writeText(String string, float f, float f2, String string2, float f3, Color color, boolean bl, int n, float f4, float f5, float f6, String string3, boolean bl2) {
        if (string == null || string.length() < 1) {
            return;
        }
        if (!bl2 || !this.embedFont(string, string2)) {
            this.setFont(string2, 0);
        }
        this.setFontSize(f3);
        this.saveState(1);
        this.writeUsingFont();
        if (n == 1 || n == 2) {
            this.setStrokeColor(color);
        }
        this.setFillColor(color);
        this.mTextMetrices = new PdfMetrices(1);
        if (this.mCurrentCharScaling != 100.0f) {
            this.writeCharScaling(100.0f);
        }
        if (this.mCurrentCharSpacing != 0.0f) {
            this.writeCharSpacing(0.0f);
        }
        float f7 = f;
        float f8 = f2;
        float f9 = this.mFont.getSize() * (float)this.mFont.stringWidth(string) / 1000.0f;
        float f10 = this.mFont.getSize() / 3.0f;
        if (string3 != null && f6 > 0.0f) {
            if (string3.equals("scaleX")) {
                this.writeCharScaling(f6 * 100.0f / f9);
            } else if (string3.equals("spaceX")) {
                int n2 = string.length();
                if (n2 > 1) {
                    --n2;
                }
                this.writeCharSpacing((f6 - f9) / (float)n2);
            }
            if (bl) {
                f7 = f - f9;
                f8 = f2 - f10;
            }
            f9 = f6 / 2.0f;
        } else {
            f9 /= 2.0f;
            if (bl) {
                f7 = f - f9;
                f8 = f2 - f10;
            }
        }
        if (f4 != 0.0f) {
            this.mTextMetrices.setSkew(0.0f, f4);
        }
        if (f5 != 0.0f) {
            if (bl) {
                double d2 = (double)(-f5) * Math.PI / 180.0;
                double d3 = Math.cos(d2);
                double d4 = Math.sin(d2);
                f7 = (float)((double)f - (double)f9 * d3 + d4 * (double)f10);
                f8 = (float)((double)f2 - (double)f9 * d4 - d3 * (double)f10);
            }
            this.mTextMetrices.setRotation(f5);
        }
        if (n != this.mCurrentFontStyle) {
            int n3 = 0;
            if (n == 2 || n == 1) {
                this.setLineWidth(f3 * 0.03f);
                n3 = n;
            }
            this.mPrintStream.println(n3 + " Tr");
            this.mCurrentFontStyle = n;
        }
        this.drawText(string, f7, f8);
    }

    private void beginText() {
        this.resources.useText();
        this.mPrintStream.println("BT");
        this.isFontChanged = true;
    }

    private void endText() {
        this.mPrintStream.println("ET");
        this.mPrintStream.println();
        this.mCurrentFontStyle = 0;
        this.mCurrentCharScaling = 100.0f;
        this.mCurrentCharSpacing = 0.0f;
    }

    private void writeUsingFont() {
        if (this.getFont() == null) {
            this.setFont(this.bjf.DEFAULT_FONT);
        }
        if (this.isFontChanged) {
            this.mPrintStream.println(String.valueOf(this.mFont.getName().toString()) + " " + this.mFont.getSize() + " Tf");
            this.isFontChanged = false;
        }
    }

    private void writeCharSpacing(float f) {
        this.mPrintStream.println(this.mPdfUtil.formatPrint(f) + " Tc");
        this.mCurrentCharSpacing = f;
    }

    private void writeCharScaling(float f) {
        this.mPrintStream.println(this.mPdfUtil.formatPrint(f) + " Tz");
        this.mCurrentCharScaling = f;
    }

    private void drawText(String string, float f, float f2) {
        byte[] byArray = null;
        try {
            if (this.mFont instanceof TrueTypeFont) {
                TrueTypeFont trueTypeFont = (TrueTypeFont)this.mFont;
                Hashtable hashtable = trueTypeFont.getMTrueTypeFile().getCmaps();
                char[] cArray = new char[string.length()];
                int n = 0;
                while (n < string.length()) {
                    cArray[n] = (char)((Integer)hashtable.get(new Integer(string.charAt(n)))).intValue();
                    ++n;
                }
                String string2 = new String(cArray, 0, string.length());
                byArray = string2.getBytes(this.mFont.getEncoding().getEncodingStr());
            } else {
                byArray = string.getBytes(this.mFont.getEncoding().getEncodingStr());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            byArray = string.getBytes();
        }
        if (byArray == null) {
            return;
        }
        this.mTextMetrices.setTranslation(f, f2);
        this.mPrintStream.print(this.mTextMetrices.toString());
        if (this.mFont instanceof TrueTypeFont) {
            this.mPrintStream.print("(");
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] > 0) {
                    this.mPrintStream.print(this.toOctalString(byArray[n]));
                } else {
                    this.mPrintStream.write(byArray[n]);
                }
                ++n;
            }
            this.mPrintStream.println(") Tj");
        } else {
            this.mPrintStream.print("<");
            int n = 0;
            while (n < byArray.length) {
                this.mPrintStream.print(Integer.toHexString(0xFF & byArray[n]));
                ++n;
            }
            this.mPrintStream.println("> Tj");
        }
    }

    private String toOctalString(int n) {
        String string = Integer.toOctalString(n);
        return String.valueOf("\\000".substring(0, 4 - string.length())) + string;
    }

    private boolean embedFont(String string, String string2) {
        TrueTypeFont trueTypeFont;
        Object v = this.mUsingEmbededFonts.get(string2);
        if (v == null) {
            File file = FontFactory.getFontFile(string2);
            if (file == null) {
                return false;
            }
            String string3 = file.getAbsolutePath();
            trueTypeFont = new TrueTypeFont(string3);
            trueTypeFont.setListFontName("TTF" + this.mBody.size());
            if (trueTypeFont.isTrueTypeCollection()) {
                trueTypeFont.getMTrueTypeFile().checkTTC(string2);
            }
            trueTypeFont.loadFontDirectory();
            Object v2 = this.mBody.getFontCollection().get(trueTypeFont.getBaseFont());
            if (v2 == null) {
                this.mUsingEmbededFonts.put(string2, trueTypeFont);
            } else {
                try {
                    trueTypeFont.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                trueTypeFont = (TrueTypeFont)v2;
            }
        } else {
            trueTypeFont = (TrueTypeFont)v;
        }
        trueTypeFont.resetUesedChars(string);
        trueTypeFont.createFont();
        this.setFont(trueTypeFont);
        return true;
    }

    public void writeImage(ImageXObject imageXObject, float f, float f2, float f3, float f4, float f5) {
        imageXObject.getMTransMatrices().setRotation(f5);
        this.imageDrawer(imageXObject, f, f2, f3, f4);
    }

    public void writeImage(Image image, float f, float f2, float f3, float f4, float f5) {
        ImageXObject imageXObject = new ImageXObject(image);
        this.writeImage(imageXObject, f, f2, f3, f4, f5);
    }

    public void writeImage(int[] nArray, int n, int n2, float f, float f2, float f3, float f4, float f5) {
        ImageXObject imageXObject = new ImageXObject(nArray, n, n2);
        this.writeImage(imageXObject, f, f2, f3, f4, f5);
    }

    public void writeJpegImage(byte[] byArray, int n, int n2, float f, float f2, float f3, float f4, float f5) {
        ImageXObjectJpeg imageXObjectJpeg = new ImageXObjectJpeg(byArray, n, n2);
        this.writeImage(imageXObjectJpeg, f, f2, f3, f4, f5);
    }

    public void writeForm(FormXObject formXObject, float f, float f2, float f3, float f4) {
        this.drawForm(formXObject, f, f2, f3, f4);
    }

    public void writeForm(FormXObject formXObject, float f, float f2, float f3, float f4, float f5) {
        formXObject.getMTransMatrices().setRotation(f5);
        this.drawForm(formXObject, f, f2, f3, f4);
    }

    public void writeForm(FormXObject formXObject, float f, float f2, float f3, float f4, float f5, float f6, Object object, Color color) {
        formXObject.writeBorder(f6, (LineStyle)object, color);
        formXObject.getMTransMatrices().setRotation(f5);
        this.drawForm(formXObject, f, f2, f3, f4);
    }

    public void writeLink(String string, PdfRect pdfRect) {
        pdfRect.setLux(pdfRect.getLux() * 2.8346f);
        pdfRect.setLuy(pdfRect.getLuy() * 2.8346f);
        pdfRect.setRdx(pdfRect.getRdx() * 2.8346f);
        pdfRect.setRdy(pdfRect.getRdy() * 2.8346f);
        PdfAnnotation pdfAnnotation = new PdfAnnotation(this.mBody).createURILink(this.mBody, string, pdfRect);
        this.mBody.add(pdfAnnotation);
        this.mBody.getCurrentPage().getAnnotArray().addElement(pdfAnnotation.getReference());
    }

    public void writeLink(String string, PdfRect pdfRect, float f) {
        pdfRect.setLux(pdfRect.getLux() * 2.8346f);
        pdfRect.setLuy(pdfRect.getLuy() * 2.8346f);
        pdfRect.setRdx(pdfRect.getRdx() * 2.8346f);
        pdfRect.setRdy(pdfRect.getRdy() * 2.8346f);
        PdfAnnotation pdfAnnotation = new PdfAnnotation(this.mBody).createLink(this.mBody, string, pdfRect, f);
        this.mBody.add(pdfAnnotation);
        this.mBody.getCurrentPage().getAnnotArray().addElement(pdfAnnotation.getReference());
    }

    public void flush() {
        try {
            this.stream.flush();
            this.mPrintStream.flush();
            this.streamOut.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void close() {
        try {
            this.stream.close();
            this.mPrintStream.close();
            this.streamOut.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void registerPattern(String string) {
        Pattern pattern = this.getPattern(string);
        if (pattern == null) {
            throw new IllegalArgumentException("unknown pattern [" + string + "]");
        }
        this.addPattern(pattern);
    }

    public Pattern getPattern(String string) {
        if (TilingPattern.PATTERN_STAR.equals(string)) {
            return this.getStarPattern();
        }
        return null;
    }

    public Pattern getStarPattern() {
        return TilingPattern.getStarPattern(this.mBody);
    }

    public void addPattern(Pattern pattern) {
        this.resources.addPattern(pattern);
    }

    public void registerShading(String string) {
        Shading shading = this.getShading(string);
        if (shading == null) {
            throw new IllegalArgumentException("unknown shading [" + string + "]");
        }
        this.addShading(shading);
    }

    public Shading getShading(String string) {
        if (ShadingType2.isType2(string)) {
            return ShadingType2.getDefaultShadingType2(this.mBody, string);
        }
        return null;
    }

    public void addShading(Shading shading) {
        this.resources.addShading(shading);
    }

    private void startPattern(String string, Color color) {
        this.mPrintStream.println("/Pattern cs");
        this.mPrintStream.println("/" + string + " scn");
        this.setStrokeColor(color);
        this.mPrintStream.println(new LineStyle(0.5f));
    }

    private void endPattern() {
        this.mPrintStream.println("B*");
    }

    public void clipPath() {
        this.mPrintStream.println("W* n");
    }

    public void shading(String string) {
        this.mPrintStream.println("/" + string + " sh");
    }

    public void writeGroupPolygon(float[][] fArray, Object object, Color color, boolean bl) {
        this.setDefaultCoor();
        if (bl) {
            if (this.mState == 4) {
                if (this.mFillColor == null || !this.mFillColor.equals(color)) {
                    this.setFillColor(color);
                }
            } else {
                this.saveState(4);
                this.setFillColor(color);
            }
            int n = 0;
            while (n < fArray.length) {
                this.arrayPolyPath(fArray[n]);
                this.closePath();
                ++n;
            }
            this.fillPathUsingOddEvenRule();
        } else {
            if (this.mState == 4) {
                if (this.mStrokeColor == null || !this.mStrokeColor.equals(color)) {
                    this.setStrokeColor(color);
                }
                if (this.mLineStyle == null || !this.mLineStyle.equals(object)) {
                    this.setLStyle((LineStyle)object);
                }
            } else {
                this.saveState(4);
                this.setStrokeColor(color);
                this.setLStyle((LineStyle)object);
            }
            int n = 0;
            while (n < fArray.length) {
                this.arrayPolyPath(fArray[n]);
                this.closePath();
                ++n;
            }
            this.strokePath();
        }
    }

    public void writePatternedPolygon(float[] fArray, String string) {
        this.writePatternedGroupPolygon(new float[][]{fArray}, string);
    }

    public void writePatternedGroupPolygon(float[][] fArray, String string) {
        LineStyle lineStyle = new LineStyle();
        lineStyle.setLineWidth(0.1f);
        this.writeGroupPolygon(fArray, lineStyle, Color.white, true);
        this.registerPattern(string);
        this.setDefaultCoor();
        this.loadState();
        this.saveState(4);
        this.startPattern(string, Color.black);
        int n = 0;
        while (n < fArray.length) {
            this.arrayPolyPath(fArray[n]);
            this.closePath();
            ++n;
        }
        this.endPattern();
        this.loadState();
    }

    public void writeShadingPolygon(float[] fArray, String string) {
        this.writeShadingGroupPolygon(new float[][]{fArray}, string);
    }

    public void writeShadingGroupPolygon(float[][] fArray, String string) {
        this.setDefaultCoor();
        this.registerShading(string);
        this.saveState(4);
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.NEGATIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        int n = 0;
        while (n < fArray.length) {
            this.arrayPolyPath(fArray[n]);
            this.closePath();
            int n2 = 0;
            while (n2 < fArray[n].length) {
                float f5 = fArray[n][n2];
                float f6 = fArray[n][n2 + 1];
                if (f5 < f) {
                    f = f5;
                }
                if (f5 > f3) {
                    f3 = f5;
                }
                if (f6 < f2) {
                    f2 = f6;
                }
                if (f6 > f4) {
                    f4 = f6;
                }
                n2 += 2;
            }
            ++n;
        }
        this.clipPath();
        this.writeCurrentTransformationMatrix(f3 - f, 0.0f, 0.0f, f4 - f2, f, f2);
        this.shading(string);
        this.loadState();
    }

    public void setClip(float f, float f2, float f3, float f4) {
        this.releaseClip();
        this.mClipRect = new PdfRect(f, f2, f + f3, f2 + f4);
    }

    private void clipRect() {
        if (this.mClipRect != null) {
            this.beginPath(this.mClipRect.getLux(), this.mClipRect.getLuy());
            this.linePath(this.mClipRect.getRdx(), this.mClipRect.getLuy());
            this.linePath(this.mClipRect.getRdx(), this.mClipRect.getRdy());
            this.linePath(this.mClipRect.getLux(), this.mClipRect.getRdy());
            this.clipPath();
        }
    }

    public void releaseClip() {
        this.loadState();
        this.mClipRect = null;
    }

    class TextObject {
        public static final int PLAIN = 0;
        public static final int BORDER = 1;
        public static final int BOLD = 2;
        String str;
        float skew;
        int style = 0;
        Color strokeC;
        Color fillC;
        float mRotate;
    }
}

