/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import java.awt.Color;
import java.util.StringTokenizer;
import option.io.pdfcommon.PdfDataConst;
import option.io.pdfcommon.path.DashPattern;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.path.Path;
import option.io.pdfcommon.path.PathArc;
import option.io.pdfcommon.path.PathImage;
import option.io.pdfcommon.path.PathLine;
import option.io.pdfcommon.path.PathLink;
import option.io.pdfcommon.path.PathMulti;
import option.io.pdfcommon.path.PathMultiElementBezier;
import option.io.pdfcommon.path.PathMultiElementClose;
import option.io.pdfcommon.path.PathMultiElementLine;
import option.io.pdfcommon.path.PathMultiElementMove;
import option.io.pdfcommon.path.PathPolygon;
import option.io.pdfcommon.path.PathPolyline;
import option.io.pdfcommon.path.PathRectangle;
import option.io.pdfcommon.path.PathText;

public class PdfDrawCommandParser
implements PdfDataConst {
    protected String mBase;

    public PdfDrawCommandParser(String string) {
        this.mBase = string;
    }

    public Path parseDrawCommand(String string) {
        Path path = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        if (!stringTokenizer.hasMoreTokens()) {
            return path;
        }
        String string2 = stringTokenizer.nextToken().trim();
        if (string2.equals("line")) {
            path = this.createLine(string);
        } else if (string2.equals("text")) {
            path = this.createText(string);
        } else if (string2.equals("rect")) {
            path = this.createRect(string);
        } else if (string2.equals("arc")) {
            path = this.createArc(string);
        } else if (string2.equals("polygon")) {
            path = this.createPolygon(string);
        } else if (string2.equals("polyline")) {
            path = this.createPolyline(string);
        } else if (string2.equals("image")) {
            path = this.createImage(string);
        } else if (string2.equals("jpeg")) {
            path = this.createJpegImage(string);
        } else if (string2.equals("link")) {
            path = this.createLink(string);
        }
        return path;
    }

    protected Path createArc(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        if (n >= 14) {
            stringTokenizer.nextToken();
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            float f4 = Float.parseFloat(stringTokenizer.nextToken());
            float f5 = Float.parseFloat(stringTokenizer.nextToken());
            float f6 = Float.parseFloat(stringTokenizer.nextToken()) - f5;
            Color color = this.parseColor(stringTokenizer);
            boolean bl = this.parseFill(stringTokenizer);
            float f7 = Float.parseFloat(stringTokenizer.nextToken());
            return new PathArc(f, f2, f3, f4, f5, f6, new LineStyle(f7, new DashPattern(this.parseLinePattern(stringTokenizer))), color, bl);
        }
        return null;
    }

    protected PathImage createImage(String string) {
        return null;
    }

    protected Path createJpegImage(String string) {
        return null;
    }

    protected Path createLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        if (n >= 11) {
            stringTokenizer.nextToken();
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            float f4 = Float.parseFloat(stringTokenizer.nextToken());
            Color color = this.parseColor(stringTokenizer);
            float f5 = Float.parseFloat(stringTokenizer.nextToken());
            return new PathLine(f, f2, f3, f4, new LineStyle(f5, new DashPattern(this.parseLinePattern(stringTokenizer))), color);
        }
        return null;
    }

    protected Path createLink(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        if (n != 7) {
            return null;
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        float f = Float.parseFloat(stringTokenizer.nextToken());
        float f2 = Float.parseFloat(stringTokenizer.nextToken());
        float f3 = Float.parseFloat(stringTokenizer.nextToken());
        float f4 = Float.parseFloat(stringTokenizer.nextToken());
        float f5 = Float.parseFloat(stringTokenizer.nextToken());
        return new PathLink(string2, f, f2, f3, f4, f5);
    }

    protected Path createMultiPath(String string) {
        PathMulti pathMulti = new PathMulti();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ", ");
            String string3 = stringTokenizer2.nextToken();
            if (string3 == null) break;
            if (string3.equalsIgnoreCase("moveto")) {
                float f = Float.parseFloat(stringTokenizer2.nextToken());
                float f2 = Float.parseFloat(stringTokenizer2.nextToken());
                pathMulti.addPath(new PathMultiElementMove(f, f2));
                continue;
            }
            if (string3.equalsIgnoreCase("lineto")) {
                float f = Float.parseFloat(stringTokenizer2.nextToken());
                float f3 = Float.parseFloat(stringTokenizer2.nextToken());
                pathMulti.addPath(new PathMultiElementLine(f, f3));
                continue;
            }
            if (string3.equalsIgnoreCase("bezier1")) {
                float f = Float.parseFloat(stringTokenizer2.nextToken());
                float f4 = Float.parseFloat(stringTokenizer2.nextToken());
                float f5 = Float.parseFloat(stringTokenizer2.nextToken());
                float f6 = Float.parseFloat(stringTokenizer2.nextToken());
                float f7 = Float.parseFloat(stringTokenizer2.nextToken());
                float f8 = Float.parseFloat(stringTokenizer2.nextToken());
                pathMulti.addPath(new PathMultiElementBezier(f, f4, f5, f6, f7, f8));
                continue;
            }
            if (string3.equalsIgnoreCase("close")) {
                pathMulti.addPath(new PathMultiElementClose());
                continue;
            }
            if (string3.equalsIgnoreCase("fill")) {
                pathMulti.addDrawFlag(2);
                int n = Integer.parseInt(stringTokenizer2.nextToken());
                Color color = this.parseColor(stringTokenizer2);
                pathMulti.setWindingRule(n);
                pathMulti.setFillColor(color);
                continue;
            }
            if (string3.equalsIgnoreCase("stroke")) {
                pathMulti.addDrawFlag(1);
                Color color = this.parseColor(stringTokenizer2);
                float f = Float.parseFloat(stringTokenizer2.nextToken());
                LineStyle lineStyle = new LineStyle(f, new DashPattern(this.parseLinePattern(stringTokenizer2)));
                pathMulti.setStrokeColor(color);
                pathMulti.setLineStyle(lineStyle);
                continue;
            }
            if (!string3.equalsIgnoreCase("shadestroke")) continue;
            pathMulti.addDrawFlag(1);
            String string4 = stringTokenizer2.nextToken();
            float f = Float.parseFloat(stringTokenizer2.nextToken());
            LineStyle lineStyle = new LineStyle(f, new DashPattern(this.parseLinePattern(stringTokenizer2)));
            pathMulti.setLineStyle(lineStyle);
            pathMulti.setShading(string4);
        }
        return pathMulti;
    }

    protected Path createPolygon(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        if (n < 10) {
            return null;
        }
        stringTokenizer.nextToken();
        Color color = this.parseColor(stringTokenizer);
        boolean bl = this.parseFill(stringTokenizer);
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        float[] fArray = new float[n2 * 2];
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3 * 2] = Float.parseFloat(stringTokenizer.nextToken());
            fArray[n3 * 2 + 1] = Float.parseFloat(stringTokenizer.nextToken());
            ++n3;
        }
        float f = Float.parseFloat(stringTokenizer.nextToken());
        return new PathPolygon(fArray, new LineStyle(f, new DashPattern(this.parseLinePattern(stringTokenizer))), color, bl);
    }

    protected Path createPolyline(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        if (n < 9) {
            return null;
        }
        stringTokenizer.nextToken();
        Color color = this.parseColor(stringTokenizer);
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        float[] fArray = new float[n2 * 2];
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3 * 2] = Float.parseFloat(stringTokenizer.nextToken());
            fArray[n3 * 2 + 1] = Float.parseFloat(stringTokenizer.nextToken());
            ++n3;
        }
        float f = Float.parseFloat(stringTokenizer.nextToken());
        return new PathPolyline(fArray, new LineStyle(f, new DashPattern(this.parseLinePattern(stringTokenizer))), color);
    }

    protected Path createRect(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        if (n >= 12) {
            stringTokenizer.nextToken();
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            float f4 = Float.parseFloat(stringTokenizer.nextToken());
            Color color = this.parseColor(stringTokenizer);
            boolean bl = this.parseFill(stringTokenizer);
            float f5 = Float.parseFloat(stringTokenizer.nextToken());
            return new PathRectangle(f < f3 ? f : f3, f2 < f4 ? f2 : f4, Math.abs(f3 - f), Math.abs(f4 - f2), new LineStyle(f5, new DashPattern(this.parseLinePattern(stringTokenizer))), color, bl);
        }
        return null;
    }

    protected PathText createText(String string) {
        int n = string.indexOf("#");
        int n2 = string.lastIndexOf("#");
        if (n < 0 || n2 < 0 || n == n2) {
            return null;
        }
        String string2 = string.substring(n + 1, n2);
        String string3 = string.substring(n2 + 1, string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "*");
        int n3 = stringTokenizer.countTokens();
        if (n3 < 7 || n3 > 14 || n3 == 12) {
            return null;
        }
        float f = Float.parseFloat(stringTokenizer.nextToken());
        float f2 = Float.parseFloat(stringTokenizer.nextToken());
        String string4 = stringTokenizer.nextToken().trim();
        float f3 = Float.parseFloat(stringTokenizer.nextToken());
        Color color = this.parseColor(stringTokenizer);
        boolean bl = false;
        if (n3 > 7) {
            boolean bl2 = bl = Float.parseFloat(stringTokenizer.nextToken()) > 0.0f;
        }
        if (n3 <= 8) {
            return new PathText(string2, f, f2, string4, f3, color, bl);
        }
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        if (n3 <= 9) {
            return new PathText(string2, f, f2, string4, f3, color, bl, n4);
        }
        float f4 = Float.parseFloat(stringTokenizer.nextToken());
        float f5 = 0.0f;
        if (n3 > 10) {
            f5 = Float.parseFloat(stringTokenizer.nextToken());
        }
        if (n3 <= 11) {
            return new PathText(string2, f, f2, string4, f3, color, bl, n4, f4, f5);
        }
        float f6 = Float.parseFloat(stringTokenizer.nextToken());
        String string5 = stringTokenizer.nextToken().trim();
        if (n3 == 13) {
            return new PathText(string2, f, f2, string4, f3, color, bl, n4, f4, f5, f6, string5);
        }
        boolean bl3 = Float.parseFloat(stringTokenizer.nextToken()) > 0.0f;
        return new PathText(string2, f, f2, string4, f3, color, bl, n4, f4, f5, f6, string5, bl3);
    }

    protected float[] parseLinePattern(StringTokenizer stringTokenizer) {
        int n = stringTokenizer.countTokens();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = Float.parseFloat(stringTokenizer.nextToken());
            ++n2;
        }
        return fArray;
    }

    protected Color parseColor(StringTokenizer stringTokenizer) {
        return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
    }

    protected boolean parseFill(StringTokenizer stringTokenizer) {
        return Integer.parseInt(stringTokenizer.nextToken()) > 0;
    }
}

