/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;

public class PdfCommandImage {
    private Component mComponent;
    private String mFile;
    private int mWidth;
    private int mHeight;

    public PdfCommandImage(String string) {
        this(string, new Panel());
    }

    public PdfCommandImage(String string, Component component) {
        this.setFile(string);
        this.mComponent = component;
    }

    public void setFile(String string) {
        this.mFile = string;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int[] getPixels() {
        Image image = this.getImage();
        if (image == null) {
            return null;
        }
        this.mWidth = image.getWidth(this.mComponent);
        this.mHeight = image.getHeight(this.mComponent);
        int[] nArray = new int[this.mWidth * this.mHeight];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.mWidth, this.mHeight, nArray, 0, this.mWidth);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted [ " + this.mFile + " ]");
            return null;
        }
        return nArray;
    }

    private Image getImage() {
        if (this.mFile == null) {
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(this.mFile);
        MediaTracker mediaTracker = new MediaTracker(this.mComponent);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
        return image;
    }
}

