/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.util;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class PdfUtil {
    private SimpleDateFormat format = new SimpleDateFormat("'D:'yyyyMMddHHmmss");
    private GregorianCalendar calendar = new GregorianCalendar();
    private DecimalFormat df = new DecimalFormat();
    private FieldPosition mFpos = new FieldPosition(0);
    private int mCurrentDigits;
    private int mUserDigits;

    protected void finalize() throws Throwable {
        this.format = null;
        this.calendar = null;
        this.df = null;
        this.mFpos = null;
        super.finalize();
    }

    public PdfUtil() {
        this(4);
    }

    public PdfUtil(int n) {
        this.mUserDigits = n;
    }

    public String toTextString(String string) {
        return "(" + string + ")";
    }

    public String toDateString(Date date) {
        FieldPosition fieldPosition = new FieldPosition(0);
        int n = this.calendar.get(15) / 3600000;
        this.df.format((long)Math.abs(n), new StringBuffer(), fieldPosition);
        return this.format.format(date);
    }

    public String formatPrint(float f) {
        return this.formatPrint(f, this.mUserDigits);
    }

    public String formatPrint(float f, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        ((NumberFormat)this.df).setGroupingUsed(false);
        if (n != this.mCurrentDigits) {
            this.df.setMinimumFractionDigits(n);
            this.df.setMaximumFractionDigits(n);
            this.mCurrentDigits = n;
        }
        this.df.format((double)f, stringBuffer, this.mFpos);
        return stringBuffer.toString();
    }

    public int getUserDigits() {
        return this.mUserDigits;
    }

    public void setUserDigits(int n) {
        this.mUserDigits = n;
    }
}

