/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.util;

import option.io.pdfcommon.util.PdfUtil;

public class PdfMetrices {
    private static final int MATRIX_SIZE = 3;
    public static final int TRANSLATE = 1;
    public static final int ROTATE = 2;
    public static final int SCALE = 3;
    public static final int SKEW = 4;
    public static final int TEXT_TYPE = 1;
    public static final int IMAGE_TYPE = 2;
    public static final int FORM_TYPE = 3;
    private int[] mTranformOrder = new int[4];
    private float[][] mMatrix = new float[3][3];
    private boolean isTranslate = false;
    private boolean isScale = false;
    private boolean isRotate = false;
    private boolean isSkew = false;
    private float tx;
    private float ty;
    private float sx;
    private float sy;
    private float rotateTheta;
    private float skewXAng;
    private float skewYAng;
    private int mType = 0;
    private PdfUtil mPdfUtil = new PdfUtil();

    public PdfMetrices(int n) {
        this.mType = n;
        this.initTransformOrder();
    }

    public void setTranslation(float f, float f2) {
        this.tx = f;
        this.ty = f2;
        this.isTranslate = true;
    }

    public float getTranslationX() {
        return this.tx;
    }

    public float getTranslationY() {
        return this.ty;
    }

    public void setScale(float f, float f2) {
        this.sx = f;
        this.sy = f2;
        this.isScale = true;
    }

    public float getScaleX() {
        return this.sx;
    }

    public float getScaleY() {
        return this.sy;
    }

    public void setRotation(float f) {
        this.rotateTheta = (float)Math.PI * f / 180.0f;
        this.isRotate = true;
    }

    public float getRotateTheta() {
        return this.rotateTheta;
    }

    public void setSkew(float f, float f2) {
        this.skewXAng = (float)Math.PI * f / 180.0f;
        this.skewYAng = (float)Math.PI * f2 / 180.0f;
        this.isSkew = true;
    }

    public float getSkewX() {
        return this.skewXAng;
    }

    public float getSkewY() {
        return this.skewYAng;
    }

    public String toString() {
        this.identity(this.mMatrix);
        float[][] fArray = new float[3][3];
        int n = 0;
        while (n < this.mTranformOrder.length) {
            switch (this.mTranformOrder[n]) {
                case 1: {
                    if (!this.isTranslate) break;
                    this.identity(fArray);
                    fArray[2][0] = this.tx;
                    fArray[2][1] = this.ty;
                    this.mMatrix = this.multiply(fArray, this.mMatrix);
                    break;
                }
                case 3: {
                    if (!this.isScale) break;
                    this.identity(fArray);
                    fArray[0][0] = this.sx;
                    fArray[1][1] = this.sy;
                    this.mMatrix = this.multiply(fArray, this.mMatrix);
                    break;
                }
                case 2: {
                    if (!this.isRotate) break;
                    this.identity(fArray);
                    float f = (float)Math.cos(this.rotateTheta);
                    float f2 = (float)Math.sin(this.rotateTheta);
                    fArray[0][0] = f;
                    fArray[0][1] = -f2;
                    fArray[1][0] = f2;
                    fArray[1][1] = f;
                    this.mMatrix = this.multiply(fArray, this.mMatrix);
                    break;
                }
                case 4: {
                    if (!this.isSkew) break;
                    this.identity(fArray);
                    float f = (float)Math.tan(this.skewXAng);
                    float f2 = (float)Math.tan(this.skewYAng);
                    fArray[0][0] = 1.0f;
                    fArray[0][1] = f;
                    fArray[1][0] = f2;
                    fArray[1][1] = 1.0f;
                    this.mMatrix = this.multiply(fArray, this.mMatrix);
                    break;
                }
            }
            ++n;
        }
        return this.toString(this.mMatrix[0][0], this.mMatrix[0][1], this.mMatrix[1][0], this.mMatrix[1][1], this.mMatrix[2][0], this.mMatrix[2][1]);
    }

    private void identity(float[][] fArray) {
        if (fArray == null) {
            return;
        }
        int n = fArray.length;
        int n2 = fArray[0].length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                fArray[n3][n4] = n3 == n4 ? 1 : 0;
                ++n4;
            }
            ++n3;
        }
    }

    public String toString(float f, float f2, float f3, float f4, float f5, float f6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.mPdfUtil.formatPrint(f)) + " ");
        stringBuffer.append(String.valueOf(this.mPdfUtil.formatPrint(f2)) + " ");
        stringBuffer.append(String.valueOf(this.mPdfUtil.formatPrint(f3)) + " ");
        stringBuffer.append(String.valueOf(this.mPdfUtil.formatPrint(f4)) + " ");
        stringBuffer.append(String.valueOf(this.mPdfUtil.formatPrint(f5)) + " ");
        stringBuffer.append(String.valueOf(this.mPdfUtil.formatPrint(f6)) + " ");
        if (this.mType == 1) {
            stringBuffer.append("Tm\n");
        } else {
            stringBuffer.append("cm\n");
        }
        return stringBuffer.toString();
    }

    public int getType() {
        return this.mType;
    }

    public void setType(int n) {
        this.mType = n;
    }

    public int[] getTransformOrder() {
        return this.mTranformOrder;
    }

    public void setTransformOrder(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        this.mTranformOrder = nArray;
    }

    private void initTransformOrder() {
        this.mTranformOrder[0] = 1;
        this.mTranformOrder[1] = 2;
        this.mTranformOrder[2] = 3;
        this.mTranformOrder[3] = 4;
    }

    public float[][] multiply(float[][] fArray, float[][] fArray2) {
        if (fArray == null || fArray2 == null || fArray.length != fArray2.length) {
            throw new IllegalArgumentException();
        }
        int n = fArray.length;
        int n2 = fArray[0].length;
        float[][] fArray3 = new float[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n2) {
                    float[] fArray4 = fArray3[n3];
                    int n6 = n4;
                    fArray4[n6] = fArray4[n6] + fArray[n3][n5] * fArray2[n5][n4];
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        return fArray3;
    }
}

