/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.pattern;

import java.awt.Color;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.document.Resources;
import option.io.pdfcommon.io.PdfStream;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.path.DashPattern;
import option.io.pdfcommon.pattern.Pattern;
import option.io.pdfcommon.util.PdfRect;

public class TilingPattern
extends Contents
implements Pattern {
    public static String PATTERN_STAR = "Pt101d";
    private PdfName mName;

    public TilingPattern(Body body, PdfRect pdfRect, String string) {
        this.mBody = body;
        this.mediabox = pdfRect;
        this.stream = new PdfStream();
        this.mPrintStream = this.stream.getPrintStream();
        this.resources = new Resources(body);
        body.add(this);
        body.add(this.resources);
        this.dict.put(DefinedName.TYPE, DefinedName.PATTERN);
        this.dict.put(DefinedName.PATTERNTYPE, new Integer(1));
        this.dict.put(DefinedName.PAINTTYPE, new Integer(1));
        this.dict.put(DefinedName.TILINGTYPE, new Integer(1));
        this.dict.put(DefinedName.BBOX, pdfRect);
        this.dict.put(DefinedName.RESOURCES, this.resources.getReference());
        this.setName(string);
    }

    public void setXStep(int n) {
        this.dict.put(DefinedName.XSTEP, new Integer(n));
    }

    public void setYStep(int n) {
        this.dict.put(DefinedName.YSTEP, new Integer(n));
    }

    public void setName(String string) {
        this.mName = new PdfName(string);
    }

    public PdfName getName() {
        return this.mName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Pattern pattern = (Pattern)object;
        return this.getName().equals(pattern.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static Pattern getStarPattern(Body body) {
        Pattern pattern = body.search(PATTERN_STAR);
        if (pattern != null) {
            return pattern;
        }
        TilingPattern tilingPattern = new TilingPattern(body, new PdfRect(0.0f, 0.0f, 60.0f, 60.0f), PATTERN_STAR);
        tilingPattern.setXStep(60);
        tilingPattern.setYStep(60);
        float[] fArray = new float[]{15.0f, 27.0f, 7.947f, 5.292f, 26.413f, 18.708f, 3.587f, 18.708f, 22.053f, 5.292f, 15.0f, 27.0f};
        float[] fArray2 = new float[]{45.0f, 57.0f, 37.947f, 35.292f, 56.413f, 48.708f, 33.587f, 48.708f, 52.053f, 35.292f, 45.0f, 57.0f};
        float[] fArray3 = new float[]{15.0f, 57.0f, 7.947f, 35.292f, 26.413f, 48.708f, 3.587f, 48.708f, 22.053f, 35.292f, 15.0f, 57.0f};
        float[] fArray4 = new float[]{45.0f, 27.0f, 37.947f, 5.292f, 56.413f, 18.708f, 33.587f, 18.708f, 52.053f, 5.292f, 45.0f, 27.0f};
        DashPattern dashPattern = new DashPattern();
        tilingPattern.writePolygon(fArray, (Object)dashPattern, new Color(200, 200, 200), true);
        tilingPattern.writePolygon(fArray2, (Object)dashPattern, new Color(200, 200, 200), true);
        tilingPattern.writePolygon(fArray3, (Object)dashPattern, new Color(100, 100, 100), true);
        tilingPattern.writePolygon(fArray4, (Object)dashPattern, new Color(100, 100, 100), true);
        return tilingPattern;
    }
}

