/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.pattern;

import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.DictObj;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class Shading
extends DictObj {
    private int mShadingType;
    private PdfName mColorSpace;
    private PdfRect mBBox;
    private boolean mAntiAlias;
    private PdfName mName;

    public Shading(Body body, int n, String string) {
        super(body);
        body.add(this);
        this.setShadingType(n);
        this.setName(string);
    }

    public void setShadingType(int n) {
        this.mShadingType = n;
    }

    public void setColorSpace(PdfName pdfName) {
        this.mColorSpace = pdfName;
    }

    public void setBBox(PdfRect pdfRect) {
        this.mBBox = pdfRect;
    }

    public void setName(String string) {
        this.mName = new PdfName(string);
    }

    public PdfName getName() {
        return this.mName;
    }

    public void updateDict() {
        this.dict.clear();
        this.dict.put(DefinedName.SHADINGTYPE, new Integer(this.mShadingType));
        if (this.mColorSpace != null) {
            this.dict.put(DefinedName.COLORSPACE, this.mColorSpace);
        }
        if (this.mBBox != null) {
            this.dict.put(DefinedName.BBOX, this.mBBox);
        }
        if (this.mAntiAlias) {
            this.dict.put(DefinedName.ANTIALIAS, new Boolean(true));
        }
    }

    protected String toArrayString(float[] fArray, boolean bl) {
        if (fArray == null || fArray.length < 1) {
            return null;
        }
        if (fArray.length == 1 && !bl) {
            return String.valueOf(fArray[0]);
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(fArray[0]);
        int n = 1;
        while (n < fArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(fArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected String toArrayString(boolean[] blArray, boolean bl) {
        if (blArray == null || blArray.length < 1) {
            return null;
        }
        if (blArray.length == 1 && !bl) {
            return String.valueOf(blArray[0]);
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(blArray[0]);
        int n = 1;
        while (n < blArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(blArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

