/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import java.util.Vector;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.path.FormatAttribute;
import option.io.pdfcommon.path.ItemAttribute;
import option.io.pdfcommon.path.Path;

public class Format
implements Path {
    private String mFormatName;
    private String mAbsolutePath;
    private FormatAttribute mAttr;
    private Vector mPaths;

    public Format(String string, String string2) {
        this.mFormatName = string;
        this.mAbsolutePath = string2;
        this.mPaths = new Vector();
    }

    public void add(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (path instanceof FormatAttribute) {
            this.setAttribute((FormatAttribute)path);
        } else {
            this.mPaths.addElement(path);
        }
    }

    public void setAttribute(FormatAttribute formatAttribute) {
        this.mAttr = formatAttribute;
    }

    public FormatAttribute getAttribute() {
        return this.mAttr;
    }

    public String getFormatName() {
        return this.mFormatName;
    }

    public String getAbsolutePath() {
        return this.mAbsolutePath;
    }

    public ItemAttribute getItemAttribute(String string) {
        int n = 0;
        while (n < this.mPaths.size()) {
            ItemAttribute itemAttribute;
            Path path = (Path)this.mPaths.elementAt(n);
            if (path instanceof ItemAttribute && (itemAttribute = (ItemAttribute)path).getItemName().equals(string)) {
                return itemAttribute;
            }
            ++n;
        }
        return null;
    }

    public boolean draw(Contents contents) {
        int n = 0;
        while (n < this.mPaths.size()) {
            Path path = (Path)this.mPaths.elementAt(n);
            path.draw(contents);
            ++n;
        }
        return true;
    }

    public void setPattern(String string) {
    }

    public void setShading(String string) {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Format)) {
            return false;
        }
        Format format = (Format)object;
        return this.mFormatName.equals(format.mFormatName);
    }
}

