/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.object;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.zip.DeflaterOutputStream;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.io.PdfStream;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.util.PdfMetrices;

public class ImageXObject
extends PdfIndirectObject
implements DefinedName,
PdfXObject {
    private PdfDictionary dict = new PdfDictionary();
    private PdfStream stream;
    private PdfName name;
    private int width = 1;
    private int height = 1;
    private PdfMetrices mTransMatrices = new PdfMetrices(2);

    public ImageXObject() {
        this.dict.put(DefinedName.TYPE, DefinedName.XOBJECT);
        this.dict.put(DefinedName.SUBTYPE, DefinedName.IMAGE);
    }

    public ImageXObject(Image image) {
        this();
        if (image != null) {
            this.setImage(image);
        }
    }

    public ImageXObject(int[] nArray, int n, int n2) {
        this();
        if (nArray.length > 0 && nArray.length == n * n2) {
            this.setImage(nArray, n, n2);
        }
    }

    public void setWidth(int n) {
        this.width = n;
        this.dict.put(DefinedName.WIDTH, new Integer(n));
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
        this.dict.put(DefinedName.HEIGHT, new Integer(n));
    }

    public int getHeight() {
        return this.height;
    }

    public void setName(PdfName pdfName) {
        this.name = pdfName;
    }

    public void setName(String string) {
        this.setName(new PdfName(string));
    }

    public PdfName getName() {
        return this.name;
    }

    public PdfMetrices getMTransMatrices() {
        return this.mTransMatrices;
    }

    public void setMTransMatrices(PdfMetrices pdfMetrices) {
        this.mTransMatrices = pdfMetrices;
    }

    public void setImage(Image image) throws IllegalStateException {
        MediaTracker mediaTracker = new MediaTracker(new Canvas());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n < 0 || n2 < 0) {
            throw new IllegalStateException("width or height value is not accepted.");
        }
        int[] nArray = new int[n * n2];
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
        this.setImage(nArray, n, n2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setImage(int[] nArray, int n, int n2) {
        this.setEntries();
        this.setWidth(n);
        this.setHeight(n2);
        this.stream = new PdfStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(this.stream);
        DataOutputStream dataOutputStream = new DataOutputStream(deflaterOutputStream);
        byte[] byArray = new byte[3072];
        int n3 = 0;
        int n4 = 0;
        ColorModel colorModel = ColorModel.getRGBdefault();
        try {
            try {
                int n5 = 0;
                block8: while (true) {
                    block13: {
                        if (n5 < n2) break block13;
                        if (n3 > 0) {
                            dataOutputStream.write(byArray, 0, n3);
                        }
                        break;
                    }
                    n4 = n5 * n;
                    int n6 = 0;
                    while (true) {
                        if (n6 >= n) {
                            ++n5;
                            continue block8;
                        }
                        int n7 = nArray[n6 + n4];
                        byArray[n3++] = (byte)colorModel.getRed(n7);
                        byArray[n3++] = (byte)colorModel.getGreen(n7);
                        byArray[n3++] = (byte)colorModel.getBlue(n7);
                        if (n3 >= byArray.length) {
                            dataOutputStream.write(byArray, 0, n3);
                            n3 = 0;
                        }
                        ++n6;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {
                deflaterOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var13_16 = null;
        }
        try {}
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        deflaterOutputStream.close();
    }

    protected void setEntries() {
        this.dict.put(DefinedName.COLORSPACE, DefinedName.DEVICERGB);
        this.dict.put(DefinedName.BITSPERCOMPONENT, new Integer(8));
        this.dict.put(DefinedName.FILTER, DefinedName.FLATEDECODE);
        this.dict.put(DefinedName.INTERPOLATE, new Boolean(true));
    }

    public void write(PdfOutFile pdfOutFile) {
        try {
            this.dict.put(DefinedName.LENGTH, new Integer(this.stream.size()));
            PrintStream printStream = pdfOutFile.getPrintStream();
            this.startObject(pdfOutFile);
            printStream.println(this.dict);
            printStream.println("stream");
            this.stream.writeTo(pdfOutFile.getByteStream());
            printStream.println("endstream");
            this.endObject(pdfOutFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.getName().equals(((ImageXObject)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

