/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.object;

import java.awt.Color;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.util.PdfMetrices;
import option.io.pdfcommon.util.PdfRect;

public class FormXObject
extends Contents
implements PdfXObject,
DefinedName {
    private static final String DEFAULT_FORM_NAME = "XF1";
    private PdfName name;
    private float width;
    private float height;
    private float border = 0.0f;
    private Color borderColor = Color.black;
    private PdfMetrices mTransMatrices = new PdfMetrices(3);

    public FormXObject(Body body, PdfRect pdfRect, String string) {
        this.mBody = body;
        this.mediabox = pdfRect;
        this.width = pdfRect.getWidth();
        this.height = pdfRect.getHeight();
        body.add(this.resources);
        this.dict.put(DefinedName.TYPE, DefinedName.XOBJECT);
        this.dict.put(DefinedName.SUBTYPE, new PdfName("Form"));
        this.dict.put(DefinedName.FORMTYPE, new Integer(1));
        this.dict.put(DefinedName.BBOX, pdfRect);
        this.dict.put(DefinedName.RESOURCES, this.resources.getReference());
        if (string == null) {
            this.setName("xf" + (this.resources.getXObjectDictionary().size() + 1));
        } else if (this.resources.getXObjectDictionary().containsKey(string)) {
            this.setName(string);
        } else {
            this.setName(string);
        }
        this.pageCoor();
    }

    public FormXObject(Body body, PdfRect pdfRect) {
        this(body, pdfRect, DEFAULT_FORM_NAME);
    }

    public FormXObject(Body body, PdfRect pdfRect, int n) {
        this(body, pdfRect);
        this.border = n;
        this.writeBorder();
    }

    public FormXObject(Body body, PdfRect pdfRect, String string, int n) {
        this(body, pdfRect, string);
        this.border = n;
        this.writeBorder();
    }

    public void setName(String string) {
        this.name = new PdfName(string);
    }

    public void setName(PdfName pdfName) {
        this.name = pdfName;
    }

    public PdfName getName() {
        return this.name;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getBorder() {
        return this.border;
    }

    public void setBorder(float f) {
        this.border = f;
    }

    public PdfMetrices getMTransMatrices() {
        return this.mTransMatrices;
    }

    public void setMTransMatrices(PdfMetrices pdfMetrices) {
        this.mTransMatrices = pdfMetrices;
    }

    public void writeBorder() {
        this.writeBorder(this.border, new LineStyle(this.border), this.borderColor);
    }

    public void writeBorder(float f, LineStyle lineStyle, Color color) {
        if (f > 0.0f && f < this.height && f < this.width) {
            this.border = f;
            this.borderColor = color;
            this.writeRectangle(this.mediabox.getLux(), 0.0f, this.mediabox.getWidth(), this.mediabox.getHeight(), lineStyle, color, false);
        }
    }

    public void pageCoor() {
        this.setDefaultCoor();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.getName().equals(((FormXObject)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

