/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.function;

import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.DictObj;

public class Function
extends DictObj {
    private int mFuncType;
    private float[] mDomain;
    private float[] mRange;

    public Function(Body body, int n) {
        super(body);
        body.add(this);
        this.setFunctionType(n);
    }

    public void setFunctionType(int n) {
        this.mFuncType = n;
    }

    public void setDomain(float[] fArray) {
        this.mDomain = fArray;
    }

    public void setRange(float[] fArray) {
        this.mRange = fArray;
    }

    public void updateDict() {
        this.dict.clear();
        this.dict.put(DefinedName.FUNCTIONTYPE, new Integer(this.mFuncType));
        String string = this.toArrayString(this.mDomain, true);
        if (string != null) {
            this.dict.put(DefinedName.DOMAIN, string);
        }
        if ((string = this.toArrayString(this.mRange, true)) != null) {
            this.dict.put(DefinedName.RANGE, string);
        }
    }

    protected String toArrayString(float[] fArray, boolean bl) {
        if (fArray == null || fArray.length < 1) {
            return null;
        }
        if (fArray.length == 1 && !bl) {
            return String.valueOf(fArray[0]);
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(fArray[0]);
        int n = 1;
        while (n < fArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(fArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

