/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Vector;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.CmapStream;
import option.io.pdfcommon.font.EmbedFontFile;
import option.io.pdfcommon.font.Encoding;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class PdfFont
extends PdfIndirectObject
implements DefinedName {
    public static final float DEFAULT_FONT_SIZE = 12.0f;
    public static final int DEFAULT_CID_WIDTH = 600;
    protected PdfDictionary dict = new PdfDictionary();
    private FontDescriptor fontDescriptor = null;
    private Encoding encoding = new Encoding("MS932");
    private Vector descendantFontList = new Vector();
    private float size = 12.0f;
    CmapStream cmapStream = null;
    EmbedFontFile embedFontFile = null;
    private Font mFont;
    private FontMetrics mMetrics;

    public PdfFont() {
        this.dict.put(DefinedName.TYPE, DefinedName.FONT);
    }

    public void setSubtype(PdfName pdfName) {
        this.dict.put(DefinedName.SUBTYPE, pdfName);
    }

    public void setName(PdfName pdfName) {
        this.dict.put(DefinedName.FONTNAME, pdfName);
    }

    public void setBaseFont(PdfName pdfName) {
        this.dict.put(DefinedName.BASEFONT, pdfName);
    }

    public void setFontBBox(PdfRect pdfRect) {
        this.dict.put(DefinedName.FONTBBOX, pdfRect);
    }

    public void setFontMatrix(PdfArray pdfArray) {
        this.dict.put(DefinedName.FONTMATRIX, pdfArray);
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
        if (this.encoding == null) {
            this.encoding = new Encoding("MS932");
        }
        switch (encoding.getEncoingDataType()) {
            case 1: {
                this.dict.put(DefinedName.ENCODING, encoding.getEncodingPdfName());
                break;
            }
            case 2: {
                this.dict.put(DefinedName.ENCODING, encoding.getEncodingDict());
                this.dict.put(DefinedName.CHARPROCS, encoding.getCharProcs());
                this.setWidths(encoding.getWidths());
                break;
            }
            default: {
                this.dict.put(DefinedName.ENCODING, encoding.getEncodingPdfName());
            }
        }
    }

    public void setFirstChar(int n) {
        this.dict.put(DefinedName.FIRSTCHAR, new Integer(n));
    }

    public void setLastChar(int n) {
        this.dict.put(DefinedName.LASTCHAR, new Integer(n));
    }

    public void setWidths(PdfArray pdfArray) {
        this.dict.put(DefinedName.WIDTHS, pdfArray);
    }

    public void setFontDescriptor(FontDescriptor fontDescriptor) {
        this.fontDescriptor = fontDescriptor;
    }

    public void setSize(float f) {
        this.size = f;
    }

    public void setDescendantFont(CIDFont cIDFont) {
        this.descendantFontList.addElement(cIDFont);
    }

    public PdfName getSubtype() {
        return (PdfName)this.dict.get(DefinedName.SUBTYPE);
    }

    public PdfName getName() {
        return (PdfName)this.dict.get(DefinedName.FONTNAME);
    }

    public PdfName getBaseFont() {
        return (PdfName)this.dict.get(DefinedName.BASEFONT);
    }

    public int getFirstChar() {
        return (Integer)this.dict.get(DefinedName.FIRSTCHAR);
    }

    public int getLastChar() {
        return (Integer)this.dict.get(DefinedName.LASTCHAR);
    }

    public PdfArray getWidths() {
        return (PdfArray)this.dict.get(DefinedName.WIDTHS);
    }

    public FontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }

    public PdfName getEncodingName() {
        return (PdfName)this.dict.get(DefinedName.ENCODING);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public float getSize() {
        return this.size;
    }

    public Vector getDescendantFonts() {
        return this.descendantFontList;
    }

    public void setCmapStream(CmapStream cmapStream) {
        this.cmapStream = cmapStream;
    }

    public CmapStream getCmapStream() {
        return this.cmapStream;
    }

    public void setEmbedFontFile(EmbedFontFile embedFontFile) {
        this.embedFontFile = embedFontFile;
    }

    public EmbedFontFile getEmbedFontFile() {
        return this.embedFontFile;
    }

    public String toString() {
        if (this.fontDescriptor != null) {
            this.dict.put(DefinedName.FONTDESCRIPTOR, this.fontDescriptor.getReference());
        }
        if (this.containDescendantFont()) {
            this.dict.put(DefinedName.DESCENDANTFONTS, this.getDescendantFontReferences());
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        printWriter.println(this.dict);
        printWriter.println("endobj");
        return stringWriter.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PdfFont pdfFont = (PdfFont)object;
        return this.getName().equals(pdfFont.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int stringWidth(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            n += this.charWidth(cArray[n2]);
            ++n2;
        }
        return n;
    }

    public int charWidth(char c) {
        return this.getFontMetrics().charWidth(c) > 800 ? 1000 : 600;
    }

    private FontMetrics getFontMetrics() {
        String string = this.getBaseFont().getName();
        if (this.mFont == null || !this.mFont.getName().equals(string)) {
            this.mFont = new Font(string, 0, 1000);
            this.mMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.mFont);
        }
        return this.mMetrics;
    }

    public int getAscent() {
        return 0;
    }

    public int getDescent() {
        return 0;
    }

    private boolean containDescendantFont() {
        return this.descendantFontList.size() > 0;
    }

    private PdfArray getDescendantFontReferences() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PdfArray pdfArray = new PdfArray();
        int n = this.descendantFontList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = ((CIDFont)this.descendantFontList.elementAt(n2)).getReference();
            if (hashMap.get(string) == null) {
                hashMap.put(string, "");
                pdfArray.addElement(string);
            }
            ++n2;
        }
        return pdfArray;
    }

    public void write(PdfOutFile pdfOutFile) {
        if (this.fontDescriptor != null) {
            this.dict.put(DefinedName.FONTDESCRIPTOR, this.fontDescriptor.getReference());
            if (this.embedFontFile != null) {
                this.fontDescriptor.setFontfile2(this.embedFontFile.getReference());
            }
        }
        if (this.containDescendantFont()) {
            this.dict.put(DefinedName.DESCENDANTFONTS, this.getDescendantFontReferences());
        }
        if (this.cmapStream != null) {
            this.dict.put(DefinedName.TOUNICODE, this.cmapStream.getReference());
        }
        this.startObject(pdfOutFile);
        this.dict.write(pdfOutFile);
        this.endObject(pdfOutFile);
    }
}

