/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import d.d;
import java.io.IOException;
import java.util.Hashtable;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class CmapTable
extends TTFTable {
    int version;
    int numberSubtables;
    int[] platformIDs;
    int[] platformSpecificIDs;
    long[] offsets;
    int[] formats;
    int[] lengths;
    int[] languages;
    int[] endCode;
    int[] startCode;
    int[] idDelta;
    int[] idRangeOffset;
    int[] glyphIndexArray;
    private Hashtable cmaps = new Hashtable();

    public void loadFontData(TrueTypeFontFileReader trueTypeFontFileReader) {
        try {
            trueTypeFontFileReader.seek(this.offset);
            this.version = trueTypeFontFileReader.readUInt16();
            this.numberSubtables = trueTypeFontFileReader.readUInt16();
            this.platformIDs = new int[this.numberSubtables];
            this.platformSpecificIDs = new int[this.numberSubtables];
            this.offsets = new long[this.numberSubtables];
            this.formats = new int[this.numberSubtables];
            this.lengths = new int[this.numberSubtables];
            this.languages = new int[this.numberSubtables];
            int n = 0;
            while (n < this.numberSubtables) {
                trueTypeFontFileReader.seek(this.offset + 4L + (long)(n * 8));
                this.platformIDs[n] = trueTypeFontFileReader.readUInt16();
                this.platformSpecificIDs[n] = trueTypeFontFileReader.readUInt16();
                this.offsets[n] = trueTypeFontFileReader.readUInt32();
                ++n;
            }
            n = 0;
            while (n < this.numberSubtables) {
                trueTypeFontFileReader.seek(this.offset + this.offsets[n]);
                this.formats[n] = trueTypeFontFileReader.readUInt16();
                this.lengths[n] = trueTypeFontFileReader.readUInt16();
                this.languages[n] = trueTypeFontFileReader.readUInt16();
                if (this.formats[n] == 0) {
                    if (d.d) {
                        System.out.println("\u51e6\u7406\u672a\u5b9a");
                    }
                } else if (this.formats[n] == 4) {
                    int n2 = trueTypeFontFileReader.readUInt16();
                    trueTypeFontFileReader.readUInt16();
                    trueTypeFontFileReader.readUInt16();
                    trueTypeFontFileReader.readUInt16();
                    int n3 = n2 / 2;
                    this.endCode = new int[n3];
                    this.startCode = new int[n3];
                    this.idDelta = new int[n3];
                    this.idRangeOffset = new int[n3];
                    this.glyphIndexArray = new int[(this.length - 16 - n3 * 4 * 2) / 2];
                    int n4 = 0;
                    while (n4 < n3) {
                        this.endCode[n4] = trueTypeFontFileReader.readUInt16();
                        ++n4;
                    }
                    trueTypeFontFileReader.skipBytes(2);
                    n4 = 0;
                    while (n4 < n3) {
                        this.startCode[n4] = trueTypeFontFileReader.readUInt16();
                        ++n4;
                    }
                    n4 = 0;
                    while (n4 < n3) {
                        this.idDelta[n4] = trueTypeFontFileReader.readUInt16();
                        ++n4;
                    }
                    n4 = 0;
                    while (n4 < n3) {
                        this.idRangeOffset[n4] = trueTypeFontFileReader.readUInt16();
                        ++n4;
                    }
                    n4 = 0;
                    while (n4 < this.glyphIndexArray.length) {
                        this.glyphIndexArray[n4] = trueTypeFontFileReader.readUInt16();
                        ++n4;
                    }
                    int n5 = 0;
                    while (n5 < n3) {
                        int n6 = this.startCode[n5];
                        while (n6 <= this.endCode[n5] && this.endCode[n5] != 65535) {
                            if (this.idRangeOffset[n5] == 0) {
                                n4 = n6 + this.idDelta[n5] & 0xFFFF;
                            } else {
                                int n7 = n6 - this.startCode[n5] + this.idRangeOffset[n5] / 2 + n5 - n3;
                                n4 = this.glyphIndexArray[n7] + this.idDelta[n5] & 0xFFFF;
                            }
                            this.cmaps.put(new Integer(n6), new Integer(n4));
                            ++n6;
                        }
                        ++n5;
                    }
                } else {
                    System.out.println("cmap unsupported format [" + this.formats[n] + "]");
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException on reading cmap data");
        }
    }

    public Hashtable getCmaps() {
        return this.cmaps;
    }

    public String toString() {
        return "[ Class: CmapTable  cmap.size: " + this.cmaps.size() + "  ]";
    }
}

