/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.util.Hashtable;
import java.util.Vector;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.CIDSystemInfo;
import option.io.pdfcommon.font.Encoding;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class BaseJapanNoEmbedFont
implements DefinedName {
    private Vector baseFontNames = new Vector();
    private Hashtable definedFonts = new Hashtable();
    private Encoding mEncoding = new Encoding("MS932");
    private int style = 0;
    public PdfFont DEFAULT_FONT = this.makePdfFont("MS Gothic", this.baseFontNames.size() - 1, this.style);

    public BaseJapanNoEmbedFont() {
        int n = 0;
        while (n < this.baseFontNames.size()) {
            String string = (String)this.baseFontNames.elementAt(n);
            PdfFont pdfFont = this.makePdfFont(string, n, this.style);
            this.definedFonts.put(string, pdfFont);
            ++n;
        }
    }

    public PdfFont getDefinedFont(String string) {
        Object v = this.definedFonts.get(string);
        if (v != null && v instanceof PdfFont) {
            return (PdfFont)v;
        }
        return null;
    }

    public PdfFont getBaseFont(String string) {
        Font font = new Font(string, this.style, 1000);
        PdfFont pdfFont = this.getDefinedFont(font.getFamily());
        if (pdfFont == null) {
            pdfFont = this.makePdfFont(font.getFamily(), this.baseFontNames.size(), this.style);
            this.definedFonts.put(font.getFamily(), pdfFont);
            this.baseFontNames.add(font.getFamily());
        }
        if (pdfFont == null) {
            pdfFont = this.DEFAULT_FONT;
        }
        return pdfFont;
    }

    private PdfFont makePdfFont(String string, int n, int n2) {
        Font font = new Font(string, n2, 1000);
        LineMetrics lineMetrics = font.getLineMetrics("\u65e5\u672c\u8a9e", new FontRenderContext(new AffineTransform(), false, false));
        PdfFont pdfFont = new PdfFont();
        CIDFont cIDFont = new CIDFont();
        FontDescriptor fontDescriptor = new FontDescriptor();
        PdfName pdfName = new PdfName(font.getFamily().replaceAll(" ", ""));
        pdfFont.setSubtype(DefinedName.TYPE0);
        pdfFont.setName(new PdfName("JF" + n));
        pdfFont.setBaseFont(pdfName);
        pdfFont.setDescendantFont(cIDFont);
        pdfFont.setFontDescriptor(fontDescriptor);
        pdfFont.setEncoding(this.mEncoding);
        pdfFont.setFontDescriptor(fontDescriptor);
        cIDFont.setSubtype(DefinedName.CIDFONTTYPE2);
        cIDFont.setName(pdfFont.getName());
        cIDFont.setBaseFont(pdfName);
        cIDFont.setFontDescriptor(fontDescriptor);
        cIDFont.setCIDSystemInfo(new CIDSystemInfo());
        cIDFont.setDW(1000);
        PdfArray pdfArray = new PdfArray();
        pdfArray.addElement("231 389 600");
        cIDFont.setW(pdfArray);
        fontDescriptor.setFontName(pdfName);
        fontDescriptor.setAscent((int)lineMetrics.getAscent());
        fontDescriptor.setCapHeight((int)(lineMetrics.getAscent() + lineMetrics.getLeading()));
        fontDescriptor.setDescent((int)(-lineMetrics.getDescent()));
        fontDescriptor.setFlags(0);
        fontDescriptor.setFontBBox(new PdfRect(0.0f, 0.0f, 0.0f, 0.0f));
        return pdfFont;
    }
}

