/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.util.Vector;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.DictObj;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.pattern.Pattern;
import option.io.pdfcommon.pattern.Shading;

public class Resources
extends DictObj {
    private Vector fontList = new Vector();
    private Vector patternList = new Vector();
    private Vector xObjectList = new Vector();
    private PdfDictionary fontDictionary = new PdfDictionary();
    private PdfDictionary patternDictionary = new PdfDictionary();
    private Vector mShadingList;
    private PdfDictionary mShadingDictionary;
    private PdfDictionary xObjectDictionary = new PdfDictionary();
    private PdfArray procSet;

    public Resources(Body body) {
        super(body);
        this.mShadingList = new Vector();
        this.mShadingDictionary = new PdfDictionary();
        this.procSet = new PdfArray();
        this.procSet.addElement(new PdfName("PDF"));
    }

    public boolean addFont(PdfFont pdfFont) {
        boolean bl = false;
        if (this.fontList.indexOf(pdfFont) == -1) {
            this.fontList.addElement(pdfFont);
            bl = true;
        }
        return bl;
    }

    public void addPattern(Pattern pattern) {
        if (this.patternList.indexOf(pattern) == -1) {
            this.patternList.add(pattern);
        }
    }

    public void addShading(Shading shading) {
        if (this.mShadingList.indexOf(shading) == -1) {
            this.mShadingList.add(shading);
        }
    }

    public void addXObject(PdfXObject pdfXObject) {
        if (!this.xObjectList.contains(pdfXObject)) {
            if (pdfXObject.getName() == null || this.xObjectDictionary.containsKey(pdfXObject.getName())) {
                pdfXObject.setName("xo" + this.xObjectList.size());
            }
            this.xObjectList.add(pdfXObject);
            this.xObjectDictionary.put(pdfXObject.getName(), pdfXObject.getReference());
        }
    }

    public void useText() {
        if (this.procSet.indexOf(DefinedName.TEXT) == -1) {
            this.procSet.addElement(DefinedName.TEXT);
        }
    }

    public void useImageB() {
        if (this.procSet.indexOf(DefinedName.IMAGE_B) == -1) {
            this.procSet.addElement(DefinedName.IMAGE_B);
        }
    }

    public void useImageC() {
        if (this.procSet.indexOf(DefinedName.IMAGE_C) == -1) {
            this.procSet.addElement(DefinedName.IMAGE_C);
        }
    }

    public void useImageI() {
        if (this.procSet.indexOf(DefinedName.IMAGE_I) == -1) {
            this.procSet.addElement(DefinedName.IMAGE_I);
        }
    }

    public void updateDict() {
        DefinedName definedName;
        this.dict.remove(DefinedName.PROCSET);
        this.dict.put(DefinedName.PROCSET, this.procSet);
        int n = 0;
        while (n < this.fontList.size()) {
            definedName = (PdfFont)this.fontList.elementAt(n);
            this.fontDictionary.put(((PdfFont)definedName).getName(), ((PdfIndirectObject)((Object)definedName)).getReference());
            ++n;
        }
        if (this.fontDictionary.size() > 0) {
            this.dict.remove(DefinedName.FONT);
            this.dict.put(DefinedName.FONT, this.fontDictionary);
        }
        n = 0;
        while (n < this.patternList.size()) {
            definedName = (Pattern)this.patternList.elementAt(n);
            this.patternDictionary.put(definedName.getName(), definedName.getReference());
            ++n;
        }
        if (this.patternDictionary.size() > 0) {
            this.dict.remove(DefinedName.PATTERN);
            this.dict.put(DefinedName.PATTERN, this.patternDictionary);
        }
        int n2 = 0;
        while (n2 < this.mShadingList.size()) {
            Shading shading = (Shading)this.mShadingList.elementAt(n2);
            this.mShadingDictionary.put(shading.getName(), shading.getReference());
            ++n2;
        }
        if (this.mShadingDictionary.size() > 0) {
            this.dict.remove(DefinedName.SHADING);
            this.dict.put(DefinedName.SHADING, this.mShadingDictionary);
        }
        if (this.xObjectDictionary.size() > 0) {
            this.dict.remove(DefinedName.XOBJECT);
            this.dict.put(DefinedName.XOBJECT, this.xObjectDictionary);
        }
    }

    public Vector getFontList() {
        return this.fontList;
    }

    public PdfDictionary getXObjectDictionary() {
        return this.xObjectDictionary;
    }

    public Vector getXObjectList() {
        return this.xObjectList;
    }
}

