/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.util.Hashtable;
import java.util.Vector;
import option.io.pdfcommon.document.Catalog;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.document.Page;
import option.io.pdfcommon.document.PdfDocument;
import option.io.pdfcommon.document.PdfDocumentInfo;
import option.io.pdfcommon.document.RootPages;
import option.io.pdfcommon.document.XrefReference;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.FormXObject;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.pattern.Pattern;
import option.io.pdfcommon.util.PdfRect;

public class Body
extends Vector {
    private PdfDocument document;
    private Catalog catalog;
    private RootPages rootPages;
    private int objectNumber = 1;
    private Page currentPage;
    private Vector pages = new Vector();
    private Hashtable fontCollection;

    public Body(PdfDocument pdfDocument) {
        this.document = pdfDocument;
        this.catalog = new Catalog(this);
        this.rootPages = new RootPages(this);
        this.fontCollection = new Hashtable();
        this.add(this.catalog);
        this.add(this.rootPages);
    }

    public PdfFont addFont(PdfFont pdfFont) {
        Object v = this.fontCollection.get(pdfFont.getBaseFont());
        if (v == null) {
            Vector vector;
            int n;
            FontDescriptor fontDescriptor = pdfFont.getFontDescriptor();
            if (fontDescriptor != null) {
                this.add(fontDescriptor);
            }
            if ((n = (vector = pdfFont.getDescendantFonts()).size()) > 0) {
                int n2 = 0;
                while (n2 < n) {
                    this.addFont((CIDFont)vector.elementAt(n2));
                    ++n2;
                }
            }
            if (pdfFont.getCmapStream() != null) {
                this.add(pdfFont.getCmapStream());
            }
            if (pdfFont.getEmbedFontFile() != null) {
                this.add(pdfFont.getEmbedFontFile());
            }
            this.add(pdfFont);
            this.fontCollection.put(pdfFont.getBaseFont(), pdfFont);
            return pdfFont;
        }
        return (PdfFont)v;
    }

    public RootPages getRootPages() {
        return this.rootPages;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public PdfDocumentInfo getInfo() {
        return this.document.getInfo();
    }

    public void addRootPages(RootPages rootPages) {
        this.rootPages.addRootPages(rootPages);
    }

    public void addPage(Page page) {
        this.rootPages.addPage(page);
        int n = this.pages.size();
        this.pages.add(n, page);
        this.currentPage = page;
    }

    public void write(PdfOutFile pdfOutFile) {
        int n = 0;
        while (n < this.size()) {
            PdfIndirectObject pdfIndirectObject = (PdfIndirectObject)this.elementAt(n);
            this.document.getXref().addElement(new XrefReference(pdfOutFile.size(), pdfIndirectObject.getGenerationNumber(), true));
            pdfIndirectObject.write(pdfOutFile);
            ++n;
        }
    }

    public boolean add(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            if (object instanceof PdfIndirectObject) {
                ((PdfIndirectObject)object).setObjectNumber(this.objectNumber);
            }
            ++this.objectNumber;
            this.addElement(object);
            return true;
        }
        Object e = this.elementAt(n);
        if (object instanceof PdfIndirectObject) {
            int n2 = ((PdfIndirectObject)e).getObjectNumber();
            int n3 = ((PdfIndirectObject)e).getGenerationNumber();
            ((PdfIndirectObject)object).setObjectNumber(n2);
            ((PdfIndirectObject)object).setGenerationNumber(n3);
        }
        return true;
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int n) {
        this.currentPage = (Page)this.pages.elementAt(n);
    }

    public Page getPageElementAt(int n) {
        return (Page)this.pages.elementAt(n);
    }

    public int getPagesCount() {
        return this.pages.size();
    }

    public Page createPage(PdfRect pdfRect) {
        return new Page(this, pdfRect);
    }

    public void flush() {
        int n = 0;
        while (n < this.size()) {
            Object e = this.elementAt(n);
            if (e instanceof Contents) {
                ((Contents)e).flush();
            } else if (e instanceof FormXObject) {
                ((FormXObject)e).flush();
            }
            ++n;
        }
    }

    public Hashtable getFontCollection() {
        return this.fontCollection;
    }

    public Pattern search(String string) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern;
            Object e = this.elementAt(n2);
            if (e instanceof Pattern && string.equals((pattern = (Pattern)e).getName().getName())) {
                return pattern;
            }
            ++n2;
        }
        return null;
    }
}

