/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.command;

import java.awt.Component;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import option.io.pdfcommon.command.PdfCommandImage;
import option.io.pdfcommon.command.PdfDrawCommandParser;
import option.io.pdfcommon.path.FormatAttribute;
import option.io.pdfcommon.path.ItemImageAttribute;
import option.io.pdfcommon.path.ItemTextAttribute;
import option.io.pdfcommon.path.Path;
import option.io.pdfcommon.path.PathImage;
import option.io.pdfcommon.path.PathText;

public class PdfFormatParser
extends PdfDrawCommandParser {
    protected Component mComponent;

    public PdfFormatParser(String string, Component component) {
        super(string);
        this.mComponent = component;
    }

    public Path parseDrawCommand(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        String string2 = stringTokenizer.nextToken().trim();
        if (string2.equals("date")) {
            return this.createDate(string);
        }
        if (string2.equals("itemtext")) {
            return this.createItemTextAttribute(string);
        }
        if (string2.equals("itemimage")) {
            return this.createItemImageAttribute(string);
        }
        if (string2.equals("pagesize")) {
            return this.createPageAttribute(string);
        }
        return super.parseDrawCommand(string);
    }

    protected Path createPageAttribute(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        String string2 = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 72;
        if (stringTokenizer.hasMoreElements()) {
            n = Integer.valueOf(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreElements()) {
            n2 = Integer.valueOf(stringTokenizer.nextToken());
        }
        return new FormatAttribute(string2, n, n2);
    }

    protected PathText createDate(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken().trim();
        String string3 = stringTokenizer.nextToken().trim();
        return this.createText(new String("text#" + this.formatDate(string2) + "#" + string3));
    }

    protected ItemTextAttribute createItemTextAttribute(String string) {
        PathText pathText = this.createText(string);
        if (pathText != null) {
            return new ItemTextAttribute(pathText);
        }
        return null;
    }

    protected ItemImageAttribute createItemImageAttribute(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        if (n == 6) {
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            float f = Float.valueOf(stringTokenizer.nextToken()).floatValue();
            float f2 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
            float f3 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
            float f4 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
            float f5 = Math.abs(f3 - f);
            float f6 = Math.abs(f4 - f2);
            return new ItemImageAttribute(string2, new PathImage(null, f5, f6, f, f2, f5, f6, 0.0f));
        }
        return null;
    }

    private String formatDate(String string) {
        int n;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string2 = String.valueOf(gregorianCalendar.get(1));
        if ((string = string.indexOf("yyyy") >= 0 ? string.replaceFirst("yyyy", string2) : string.replaceFirst("yy", string2.substring(2, 4))).indexOf("ww") >= 0) {
            n = Integer.valueOf(string2) - 1988;
            string = string.replaceFirst("ww", String.valueOf(n));
        }
        string2 = (n = gregorianCalendar.get(2) + 1) < 10 ? new String("0" + n) : String.valueOf(n);
        string = string.replaceFirst("mm", string2);
        int n2 = gregorianCalendar.get(5);
        string2 = n2 < 10 ? new String("0" + n2) : String.valueOf(n2);
        return string.replaceFirst("dd", string2);
    }

    protected PathImage createImage(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        if (n != 9) {
            return null;
        }
        stringTokenizer.nextToken();
        int[] nArray = null;
        Object object = this.getImage(stringTokenizer.nextToken());
        if (object != null) {
            nArray = ((PdfCommandImage)object).getPixels();
        }
        if (nArray == null) {
            return null;
        }
        float f = Float.valueOf(stringTokenizer.nextToken()).floatValue();
        float f2 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
        float f3 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
        float f4 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
        float f5 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
        float f6 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
        float f7 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
        return new PathImage(nArray, f, f2, f3 < f5 ? f3 : f5, f4 < f6 ? f4 : f6, Math.abs(f5 - f3), Math.abs(f6 - f4), f7);
    }

    protected Object getImage(String string) {
        if (string == null) {
            return null;
        }
        return new PdfCommandImage(this.getAbsoluteFilePath(string), this.mComponent);
    }

    protected String getAbsoluteFilePath(String string) {
        return String.valueOf(this.mBase) + File.separator + string;
    }
}

