/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import java.awt.Color;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.path.Path;

public class PathPolygon
implements Path {
    protected float[] mPoints;
    protected LineStyle mLineStyle;
    protected Color mColor;
    protected boolean mFill;
    protected String mPattern;
    protected boolean mIsShading;

    public PathPolygon(float[] fArray, LineStyle lineStyle, Color color, boolean bl) {
        this.mPoints = fArray;
        this.mLineStyle = lineStyle;
        this.mColor = color;
        this.mFill = bl;
    }

    public boolean draw(Contents contents) {
        if (this.mPattern == null) {
            contents.writePolygon(this.mPoints, (Object)this.mLineStyle, this.mColor, this.mFill);
        } else if (this.mIsShading) {
            contents.writeShadingPolygon(this.mPoints, this.mPattern);
        } else {
            contents.writePatternedPolygon(this.mPoints, this.mPattern);
        }
        return true;
    }

    public void setPattern(String string) {
        this.mPattern = string;
        this.mIsShading = false;
    }

    public void setShading(String string) {
        this.mPattern = string;
        this.mIsShading = true;
    }
}

