/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import com.kt.util.RefList;
import java.awt.Color;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.path.Path;

public class PathMulti
implements Path {
    public static final int IS_DRAW_PATH = 1;
    public static final int IS_FILL_PATH = 2;
    public static final int IS_SHADE_PATH = 4;
    private int mDrawFlag = 0;
    private int mWindingRule = 1;
    private LineStyle mLineStyle;
    private Color mStrokeColor;
    private Color mFillColor;
    private RefList mPath = new RefList();
    protected String mPattern;

    public void addDrawFlag(int n) {
        this.mDrawFlag |= n;
    }

    public void setWindingRule(int n) {
        this.mWindingRule = n;
    }

    public void setStrokeColor(Color color) {
        this.mStrokeColor = color;
    }

    public void setFillColor(Color color) {
        this.mFillColor = color;
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.mLineStyle = lineStyle;
    }

    public void addPath(Path path) {
        this.mPath.addElement((Object)path);
    }

    public boolean draw(Contents contents) {
        Path path;
        int n;
        contents.setDefaultCoor();
        if ((this.mDrawFlag & 4) > 0 && this.mPattern != null) {
            n = 0;
            while (n < this.mPath.size()) {
                path = (Path)this.mPath.elementAt(n);
                path.draw(contents);
                ++n;
            }
            if (contents.getState() != 4) {
                contents.saveState(4);
            }
            contents.clipPath();
            contents.registerShading(this.mPattern);
            contents.shading(this.mPattern);
            contents.setStrokeColor(Color.red);
            contents.saveState(0);
            if ((this.mDrawFlag & 1) <= 0) {
                return true;
            }
        }
        if ((this.mDrawFlag & 2) > 0) {
            if (contents.getState() == 4) {
                if (contents.getFillColor() == null || !contents.getFillColor().equals(this.mFillColor)) {
                    contents.setFillColor(this.mFillColor);
                }
            } else {
                contents.saveState(4);
                contents.setFillColor(this.mFillColor);
            }
        }
        if ((this.mDrawFlag & 1) > 0) {
            if (contents.getState() == 4) {
                if (contents.getStrokeColor() == null || !contents.getStrokeColor().equals(this.mStrokeColor)) {
                    contents.setStrokeColor(this.mStrokeColor);
                }
                if (contents.getLStyle() == null || !contents.getLStyle().equals(this.mLineStyle)) {
                    contents.setLStyle(this.mLineStyle);
                }
            } else {
                contents.saveState(4);
                contents.setStrokeColor(this.mStrokeColor);
                contents.setLStyle(this.mLineStyle);
            }
        }
        n = 0;
        while (n < this.mPath.size()) {
            path = (Path)this.mPath.elementAt(n);
            path.draw(contents);
            ++n;
        }
        if ((this.mDrawFlag & 1) > 0 && (this.mDrawFlag & 2) > 0) {
            contents.fillAndStorokePath(this.mWindingRule == 1);
        } else if ((this.mDrawFlag & 1) > 0) {
            contents.strokePath();
        } else if ((this.mDrawFlag & 2) > 0) {
            contents.fillPath(this.mWindingRule == 1);
        }
        contents.saveState(0);
        return true;
    }

    public void setPattern(String string) {
    }

    public void setShading(String string) {
        this.mPattern = string;
    }
}

