/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import java.util.Vector;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.path.Path;
import option.io.pdfcommon.path.PathPolygon;

public class PathGroupPolygon
implements Path {
    protected Vector mPolys = new Vector();
    protected String mPattern;
    protected boolean mIsShading;

    protected void finalize() throws Throwable {
        this.mPolys.removeAllElements();
        this.mPolys = null;
        super.finalize();
    }

    public void addPolygon(PathPolygon pathPolygon) {
        this.mPolys.addElement(pathPolygon);
    }

    public boolean draw(Contents contents) {
        int n = this.mPolys.size();
        if (n == 0) {
            return false;
        }
        float[][] fArray = new float[n][];
        PathPolygon pathPolygon = null;
        int n2 = 0;
        while (n2 < fArray.length) {
            pathPolygon = (PathPolygon)this.mPolys.elementAt(n2);
            fArray[n2] = pathPolygon.mPoints;
            ++n2;
        }
        if (this.mPattern == null) {
            contents.writeGroupPolygon(fArray, pathPolygon.mLineStyle, pathPolygon.mColor, pathPolygon.mFill);
        } else if (this.mIsShading) {
            contents.writeShadingGroupPolygon(fArray, this.mPattern);
        } else {
            contents.writePatternedGroupPolygon(fArray, this.mPattern);
        }
        return true;
    }

    public void setPattern(String string) {
        this.mPattern = string;
        this.mIsShading = false;
    }

    public void setShading(String string) {
        this.mPattern = string;
        this.mIsShading = true;
    }
}

