/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import option.io.pdfcommon.path.DashPattern;
import option.io.pdfcommon.util.PdfUtil;

public class LineStyle {
    public static final String LN = "\r\n";
    public static final int BUTT_CAP = 0;
    public static final int ROUND_CAP = 1;
    public static final int SQUARE_CAP = 2;
    public static final int MITER_JOIN = 0;
    public static final int ROUND_JOIN = 1;
    public static final int BEVEL_JOIN = 2;
    private static PdfUtil mUtil = new PdfUtil();
    private int lineJoinStyle = 0;
    private DashPattern lineDashPattern = new DashPattern();
    private float lineWidth = 0.1f;
    private int lineCapStyle = 0;

    private static String format(float f) {
        return mUtil.formatPrint(f);
    }

    public LineStyle() {
    }

    public LineStyle(DashPattern dashPattern) {
        this.setLineDashPattern(dashPattern);
    }

    public LineStyle(float f) {
        this.setLineWidth(f);
    }

    public LineStyle(float f, DashPattern dashPattern) {
        this.setLineWidth(f);
        this.setLineDashPattern(dashPattern);
    }

    public String toString() {
        return String.valueOf(LineStyle.format(this.lineWidth)) + " w" + LN + this.lineDashPattern.toString();
    }

    public int getLineCapStyle() {
        return this.lineCapStyle;
    }

    public DashPattern getLineDashPattern() {
        return this.lineDashPattern;
    }

    public int getLineJoinStyle() {
        return this.lineJoinStyle;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineCapStyle(int n) {
        this.lineCapStyle = n;
    }

    public void setLineDashPattern(DashPattern dashPattern) {
        this.lineDashPattern = dashPattern;
    }

    public void setLineJoinStyle(int n) {
        this.lineJoinStyle = n;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LineStyle)) {
            return false;
        }
        LineStyle lineStyle = (LineStyle)object;
        if (lineStyle.lineWidth != this.lineWidth) {
            return false;
        }
        if (lineStyle.lineCapStyle != this.lineCapStyle) {
            return false;
        }
        if (lineStyle.lineJoinStyle != this.lineJoinStyle) {
            return false;
        }
        return this.lineDashPattern.equals(lineStyle.lineDashPattern);
    }
}

