/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.object;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.PrintStream;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.io.PdfStream;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.ImageXObject;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.util.PdfMetrices;

public class ImageXObjectJpeg
extends ImageXObject
implements DefinedName,
PdfXObject {
    private PdfDictionary dict = new PdfDictionary();
    private PdfStream stream;
    private PdfName name;
    private int width = 1;
    private int height = 1;
    private PdfMetrices mTransMatrices = new PdfMetrices(2);

    public ImageXObjectJpeg() {
        this.dict.put(DefinedName.TYPE, DefinedName.XOBJECT);
        this.dict.put(DefinedName.SUBTYPE, DefinedName.IMAGE);
    }

    public ImageXObjectJpeg(byte[] byArray, int n, int n2) {
        this();
        this.setImage(byArray, n, n2);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.stream != null) {
                this.stream.flush();
                this.stream.close();
                this.stream = null;
            }
        }
        catch (Exception exception) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            exception.printStackTrace();
        }
        super.finalize();
    }

    public void setWidth(int n) {
        this.width = n;
        this.dict.put(DefinedName.WIDTH, new Integer(n));
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
        this.dict.put(DefinedName.HEIGHT, new Integer(n));
    }

    public int getHeight() {
        return this.height;
    }

    public void setName(PdfName pdfName) {
        this.name = pdfName;
    }

    public void setName(String string) {
        this.setName(new PdfName(string));
    }

    public PdfName getName() {
        return this.name;
    }

    public PdfMetrices getMTransMatrices() {
        return this.mTransMatrices;
    }

    public void setMTransMatrices(PdfMetrices pdfMetrices) {
        this.mTransMatrices = pdfMetrices;
    }

    public void setImage(Image image) throws IllegalStateException {
        MediaTracker mediaTracker = new MediaTracker(new Canvas());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n < 0 || n2 < 0) {
            throw new IllegalStateException("width or height value is not accepted.");
        }
        int[] nArray = new int[n * n2];
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
        this.setImage(nArray, n, n2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setImage(byte[] byArray, int n, int n2) {
        this.setEntries();
        this.setWidth(n);
        this.setHeight(n2);
        this.stream = new PdfStream();
        try {
            try {
                this.stream.write(byArray);
                this.stream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                this.stream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.stream.close();
    }

    protected void setEntries() {
        this.dict.put(DefinedName.FILTER, DefinedName.DCTDECODE);
        this.dict.put(DefinedName.COLORSPACE, DefinedName.DEVICERGB);
        this.dict.put(DefinedName.BITSPERCOMPONENT, new Integer(8));
        this.dict.put(DefinedName.INTERPOLATE, new Boolean(true));
    }

    public void write(PdfOutFile pdfOutFile) {
        try {
            this.dict.put(DefinedName.LENGTH, new Integer(this.stream.size()));
            PrintStream printStream = pdfOutFile.getPrintStream();
            this.startObject(pdfOutFile);
            printStream.println(this.dict);
            printStream.println("stream");
            this.stream.writeTo(pdfOutFile.getByteStream());
            printStream.println("endstream");
            this.endObject(pdfOutFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.getName().equals(((ImageXObject)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

