/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import option.io.pdfcommon.font.DefaultTable;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class FontDirectory
extends TTFTable {
    int numTables;
    public Hashtable tableCollection;

    public FontDirectory() {
        this.offset = 0L;
        this.tableName = "fontdirectory";
    }

    public void loadFontData(TrueTypeFontFileReader trueTypeFontFileReader) {
        try {
            trueTypeFontFileReader.seek(this.offset);
            trueTypeFontFileReader.skipBytes(4);
            this.numTables = trueTypeFontFileReader.readUInt16();
            this.tableCollection = new Hashtable();
            trueTypeFontFileReader.skipBytes(6);
            int n = 0;
            while (n < this.numTables) {
                DefaultTable defaultTable = new DefaultTable();
                defaultTable.tableName = trueTypeFontFileReader.readByteString(4);
                defaultTable.checkSum = trueTypeFontFileReader.readUInt32();
                defaultTable.offset = trueTypeFontFileReader.readUInt32();
                defaultTable.length = (int)trueTypeFontFileReader.readUInt32();
                this.tableCollection.put(defaultTable.tableName, defaultTable);
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException on reading FontDirectory data");
        }
    }

    public String toString() {
        String string = "[ Class: FontDirectory  numTables: " + this.numTables;
        if (this.tableCollection != null) {
            Iterator iterator = this.tableCollection.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                TTFTable tTFTable = (TTFTable)this.tableCollection.get(string2);
                string = String.valueOf(string) + "\n";
                string = String.valueOf(string) + "  tableName: " + tTFTable.tableName;
                string = String.valueOf(string) + "  checkSum: " + tTFTable.checkSum;
                string = String.valueOf(string) + "  offset: " + tTFTable.offset;
                string = String.valueOf(string) + "  length: " + tTFTable.length;
            }
        }
        string = String.valueOf(string) + "  ]";
        return string;
    }

    public Hashtable getTableCollection() {
        return this.tableCollection;
    }
}

