/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import option.io.pdfcommon.document.PdfDocument;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfUtil;

public class PdfDocumentInfo
extends PdfIndirectObject
implements DefinedName {
    private String title = "";
    private String author = "";
    private String subject = "";
    private String keywords = "";
    private String creator = "";
    private String producer = "";
    private PdfDictionary dict = new PdfDictionary();
    private PdfDocument document;
    private Date date;
    private Date modDate;
    private PdfUtil mPdfUtil = new PdfUtil();

    public PdfDocumentInfo() {
        this.setCreationDate(new GregorianCalendar().getTime());
        this.setCreator("Kitec Corp");
        this.setProducer("Kitec Corp pdf Creator");
    }

    protected void finalize() throws Throwable {
        this.dict.clear();
        this.dict = null;
        super.finalize();
    }

    public PdfDocumentInfo(PdfDocument pdfDocument) {
        this();
        this.document = pdfDocument;
    }

    public PdfDictionary getDict() {
        return this.dict;
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    public void setDocument(PdfDocument pdfDocument) {
        this.document = pdfDocument;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        this.dict.put(DefinedName.TITLE, this.mPdfUtil.toTextString(string));
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
        this.dict.put(DefinedName.AUTHOR, this.mPdfUtil.toTextString(string));
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
        this.dict.put(DefinedName.SUBJECT, this.mPdfUtil.toTextString(string));
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String string) {
        this.keywords = string;
        this.dict.put(DefinedName.KEYWORDS, this.mPdfUtil.toTextString(string));
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        this.creator = string;
        this.dict.put(DefinedName.CREATOR, this.mPdfUtil.toTextString(string));
    }

    public String getProducer() {
        return this.producer;
    }

    public void setProducer(String string) {
        this.producer = string;
        this.dict.put(DefinedName.PRODUCER, this.mPdfUtil.toTextString(string));
    }

    public Date getCreationDate() {
        return this.date;
    }

    public void setCreationDate(Date date) {
        this.date = date;
        this.dict.put(DefinedName.CREATIONDATE, this.mPdfUtil.toTextString(this.mPdfUtil.toDateString(date)));
    }

    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date date) {
        this.modDate = date;
        this.dict.put(DefinedName.MODDATE, this.mPdfUtil.toTextString(this.mPdfUtil.toDateString(date)));
    }

    public void setTrapped(PdfName pdfName) {
        this.dict.put(DefinedName.TRAPPED, pdfName);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.setModDate(new GregorianCalendar().getTime());
        printWriter.println(String.valueOf(super.getObjectNumber()) + " " + super.getGenerationNumber() + " obj");
        printWriter.println(this.dict);
        printWriter.println("endobj");
        return stringWriter.toString();
    }

    public void write(PdfOutFile pdfOutFile) {
        pdfOutFile.getPrintStream().println(this.toString());
    }
}

