/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui.table;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jp.kitec.richui.table.Cell;
import jp.kitec.richui.table.CellGroup;
import jp.kitec.richui.table.CellType;
import jp.kitec.richui.table.Table;

public class MiddleColumnHeaderTable
extends Table {
    protected CellGroup mMiddleColumnHeaders;
    protected int[] mMiddleColumnHeadersLink;

    public MiddleColumnHeaderTable() {
    }

    public MiddleColumnHeaderTable(int[][] nArray) {
        super(nArray);
    }

    public MiddleColumnHeaderTable(boolean bl) {
        super(bl);
    }

    public void init() {
        if (this.mMiddleColumnHeaders != null) {
            this.mMiddleColumnHeaders.removeAllCells();
        }
        this.mMiddleColumnHeadersLink = null;
        this.mColumnHeaders.removeAllCells();
        this.mCells.clear();
        this.mRowHeaders.removeAllCells();
        this.mTableWidth = 0;
        this.mTableHeight = 0;
        this.mRowHeaderWidth = 0;
        this.mRowHeight = 0;
        this.mFirstRow = 0;
        this.mTotalColumnWidth = 0;
        this.mHScrollValue = 0;
        this.mVScrollValue = 0;
        this.mColumnWidths = null;
        this.mColumnCount = 0;
        this.mRowCount = 0;
        this.mHScrollbarWidth = 0;
        this.mVScrollbarHeight = 0;
        this.mDraggedX = 0;
        this.mDraggedColumn = 0;
        this.mEditorX = 0;
        this.mEditorY = 0;
        this.mEditorWidth = 0;
        this.mSelectedRow = -1;
        this.mSelectedColumn = -1;
        this.mAutoResizeColumnWidth = true;
        this.mIsResized = true;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
        if (this.mSrlHorizontal != null) {
            this.mSrlHorizontal.setValue(0);
        }
        if (this.mSrlVertical != null) {
            this.mSrlVertical.setValue(0);
        }
    }

    public void dispose() {
        this.disposeOffImage();
        if (this.mMiddleColumnHeaders != null) {
            this.mMiddleColumnHeaders.removeAllCells();
        }
        this.mMiddleColumnHeadersLink = null;
        this.mColumnHeaders.removeAllCells();
        this.mColumnHeaders = null;
        this.mCells.clear();
        this.mCells = null;
        this.mRowHeaders.removeAllCells();
        this.mRowHeaders = null;
        this.mColumnWidths = null;
        this.mFontMetrics = null;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
    }

    public void setMiddleColumnHeader(String[] stringArray) {
        this.mMiddleColumnHeaders = new CellGroup(stringArray);
        this.mMiddleColumnHeadersLink = new int[stringArray.length];
        this.mMiddleColumnHeadersLink[0] = 0;
        int n = 1;
        while (n < stringArray.length) {
            this.mMiddleColumnHeadersLink[n] = stringArray[n - 1] != null && stringArray[n] != null && stringArray[n - 1].equals(stringArray[n]) ? this.mMiddleColumnHeadersLink[n - 1] : n;
            ++n;
        }
    }

    public String getMiddleColumnHeader(int n) {
        if (this.mMiddleColumnHeaders == null) {
            return null;
        }
        return this.mMiddleColumnHeaders.getCell(n).getValue();
    }

    public void removeColumn(int n) {
        int n2 = this.mSelectedRow;
        if (this.mSelectedRow >= 0) {
            this.clearSelection();
        }
        int n3 = 0;
        while (n3 < this.mColumnCount) {
            CellGroup cellGroup = this.getRow(n3);
            cellGroup.removeCell(n);
            ++n3;
        }
        this.mColumnHeaders.removeCell(n);
        n3 = 0;
        int n4 = 0;
        while (n4 < this.mColumnCount) {
            if (this.mMiddleColumnHeadersLink[n4] == n) {
                ++n3;
            }
            ++n4;
        }
        if (n3 == 1) {
            int[] nArray = new int[this.mMiddleColumnHeadersLink.length - 1];
            int n5 = 0;
            int n6 = 0;
            while (n5 < this.mColumnCount) {
                if (this.mMiddleColumnHeadersLink[n5] == n) {
                    this.mMiddleColumnHeaders.removeCell(n5);
                } else {
                    nArray[n6++] = this.mMiddleColumnHeadersLink[n5];
                }
                ++n5;
            }
            this.mMiddleColumnHeadersLink = nArray;
        }
        int n7 = this.mColumnCount - 1;
        boolean[] blArray = new boolean[n7];
        int[] nArray = new int[n7];
        this.mColumnWidths = new int[n7];
        int n8 = 0;
        int n9 = 0;
        while (n8 < this.mColumnCount) {
            if (n8 != n) {
                blArray[n9] = this.mIsColumnEditables[n8];
                nArray[n9] = this.mColumnAlignments[n8];
                this.mColumnWidths[n9] = 100;
                ++n9;
            }
            ++n8;
        }
        this.mIsColumnEditables = blArray;
        this.mColumnAlignments = this.mColumnWidths;
        --this.mColumnCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(n2);
    }

    protected boolean drawMiddleColumnHeader(Graphics graphics) {
        if (this.mMiddleColumnHeadersLink == null) {
            return false;
        }
        int n = this.mRowHeaderWidth - this.mHScrollValue;
        int n2 = 0;
        while (n2 < this.mColumnCount) {
            int n3 = this.mColumnWidths[n2];
            int n4 = n2 + 1;
            while (n4 < this.mColumnCount) {
                if (this.mMiddleColumnHeadersLink[n2] != this.mMiddleColumnHeadersLink[n4]) break;
                n3 += this.mColumnWidths[n4];
                ++n2;
                ++n4;
            }
            graphics.setColor(COLOR_HEADER_BACKGROUND);
            graphics.fillRect(n + 1, 0, n3 - 2, this.mRowHeight);
            graphics.setColor(COLOR_HEADER_TEXT);
            String string = this.mMiddleColumnHeaders.getCell(n2).getValue();
            int n5 = n + n3 / 2 - this.mFontMetrics.stringWidth(string) / 2;
            if (n5 < n + 3) {
                n5 = n + 3;
            }
            if (string != null && !string.equals("")) {
                graphics.drawString(string, n5, this.mRowHeight - 4 + 1);
                graphics.setColor(COLOR_TABLE_BORDER);
                graphics.drawLine(n + n3 - 1, 0, n + n3 - 1, this.mRowHeight - 1);
                graphics.setColor(COLOR_HEADER_LTBACKGROUND);
                graphics.drawLine(n + n3, 0, n + n3, this.mRowHeight - 1);
                graphics.drawLine(n, 2, n + n3 - 2, 2);
            }
            n += n3;
            ++n2;
        }
        graphics.setColor(COLOR_HEADER_BACKGROUND);
        graphics.fillRect(0, 0, this.mRowHeaderWidth + 1, this.mRowHeight);
        graphics.fillRect(n + 1, 0, this.mTableWidth - n, this.mRowHeight);
        graphics.drawLine(0, 0, 0, this.mRowHeight - 1);
        return true;
    }

    protected void calculateEditotPosition() {
        if (this.mSelectedColumn == -1) {
            return;
        }
        int n = -this.mHScrollValue;
        int n2 = 0;
        while (n2 < this.mSelectedColumn) {
            int n3 = this.mColumnWidths[n2];
            n += n3;
            ++n2;
        }
        this.mEditorX = n + this.mRowHeaderWidth;
        this.mEditorY = (this.mSelectedRow - this.mFirstRow + 1 + (this.mMiddleColumnHeadersLink != null ? 1 : 0)) * this.mRowHeight;
        this.mEditorWidth = 0;
        if (this.mColumnWidths != null) {
            this.mEditorWidth = this.mColumnWidths[this.mSelectedColumn];
        }
    }

    protected void drawColumnHeader(Graphics graphics) {
        int n = this.mRowHeaderWidth - this.mHScrollValue;
        int n2 = 0;
        if (this.drawMiddleColumnHeader(graphics)) {
            n2 = this.mRowHeight + 1;
        }
        int n3 = 0;
        while (n3 < this.mColumnCount) {
            int n4 = this.mColumnWidths[n3];
            graphics.setColor(COLOR_HEADER_BACKGROUND);
            graphics.fillRect(n + 1, n2, n4 - 2, this.mRowHeight);
            graphics.setColor(COLOR_HEADER_TEXT);
            String string = this.mColumnHeaders.getCell(n3).getValue();
            int n5 = n + n4 / 2 - this.mFontMetrics.stringWidth(string) / 2;
            if (n5 < n + 3) {
                n5 = n + 3;
            }
            graphics.drawString(string, n5, n2 + this.mRowHeight - 4 + 1);
            graphics.setColor(COLOR_TABLE_BORDER);
            graphics.drawLine(n + n4 - 1, n2, n + n4 - 1, n2 + this.mRowHeight - 1);
            graphics.setColor(COLOR_HEADER_LTBACKGROUND);
            graphics.drawLine(n + n4, n2, n + n4, n2 + this.mRowHeight - 1);
            graphics.drawLine(n, n2 + 2, n + n4 - 2, n2 + 2);
            n += n4;
            ++n3;
        }
        graphics.setColor(COLOR_HEADER_BACKGROUND);
        graphics.fillRect(0, n2, this.mRowHeaderWidth + 1, this.mRowHeight);
        graphics.fillRect(n + 1, n2, this.mTableWidth - n, this.mRowHeight);
        graphics.drawLine(0, n2, 0, n2 + this.mRowHeight - 1);
    }

    protected void drawRows(Graphics graphics) {
        int n = this.mRowHeight + 1 - this.mVScrollValue;
        int n2 = 0;
        while (n < this.mRowHeight + 1) {
            ++n2;
            n += this.mRowHeight;
        }
        this.mFirstRow = n2;
        if (this.mMiddleColumnHeadersLink != null) {
            n += this.mRowHeight + 1;
        }
        while (n < this.mTableHeight && n2 < this.mRowCount) {
            int n3 = this.mRowHeaderWidth - this.mHScrollValue;
            int n4 = 0;
            while (n4 < this.mColumnCount) {
                int n5;
                Cell cell = this.getCell(n2, n4);
                Color color = this.mSelectedRow == n2 ? COLOR_SELECTED_ROW : this.getTableBackgoundColor(cell.getType());
                graphics.setColor(color);
                int n6 = this.mColumnWidths[n4];
                graphics.fillRect(n3, n, n6 - 1, this.mRowHeight - 1);
                graphics.setColor(COLOR_CELL_TEXT);
                String string = this.getValueAt(n2, n4);
                int n7 = this.mFontMetrics.stringWidth(string);
                if (n7 + 6 < n6) {
                    switch (this.getAlignment(n2, n4)) {
                        case 1: {
                            n5 = n3 + (n6 - n7) / 2;
                            break;
                        }
                        case 2: {
                            n5 = n3 + n6 - n7 - 3;
                            break;
                        }
                        default: {
                            n5 = n3 + 3;
                            break;
                        }
                    }
                } else {
                    n5 = n3 + 3;
                }
                graphics.drawString(string, n5, n + this.mRowHeight - 4);
                graphics.setColor(COLOR_CELL_BORDER);
                graphics.drawLine(n3 + n6 - 1, n, n3 + n6 - 1, n + this.mRowHeight - 1);
                graphics.drawLine(n3, n + this.mRowHeight - 1, n3 + n6 - 1, n + this.mRowHeight - 1);
                n3 += n6;
                ++n4;
            }
            this.drawRowHeader(graphics, this.mRowHeaders.getCell(n2).getValue(), n3, n);
            ++n2;
            n += this.mRowHeight;
        }
    }

    protected class MouseClickListener
    extends MouseAdapter {
        protected int clickCount = 2;

        protected MouseClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (MiddleColumnHeaderTable.this.mRowHeight == 0 || n > MiddleColumnHeaderTable.this.mTableWidth || n2 > MiddleColumnHeaderTable.this.mTableHeight) {
                MiddleColumnHeaderTable.this.mSelectedRow = -1;
                MiddleColumnHeaderTable.this.clearSelection();
                return;
            }
            n += MiddleColumnHeaderTable.this.mHScrollValue - MiddleColumnHeaderTable.this.mRowHeaderWidth;
            int n3 = -1;
            int n4 = 0;
            while (n4 < MiddleColumnHeaderTable.this.mColumnCount) {
                int n5 = MiddleColumnHeaderTable.this.mColumnWidths[n4];
                if (n >= 0 && n <= n5) {
                    n3 = n4;
                    break;
                }
                n -= n5;
                ++n4;
            }
            if (MiddleColumnHeaderTable.this.mEditor.isEnabled()) {
                MiddleColumnHeaderTable.this.select(-1, -1);
            }
            if (n2 < MiddleColumnHeaderTable.this.mRowHeight) {
                return;
            }
            n4 = n2 / MiddleColumnHeaderTable.this.mRowHeight - 1 + MiddleColumnHeaderTable.this.mFirstRow + (MiddleColumnHeaderTable.this.mMiddleColumnHeadersLink != null ? -1 : 0);
            if (mouseEvent.getX() < MiddleColumnHeaderTable.this.mRowHeaderWidth && n2 < MiddleColumnHeaderTable.this.mRowHeight * (MiddleColumnHeaderTable.this.mRowCount + 1)) {
                MiddleColumnHeaderTable.this.selectRow(n4);
            } else if (n4 >= 0 && n4 < MiddleColumnHeaderTable.this.mRowCount) {
                if (n3 >= 0 && n3 < MiddleColumnHeaderTable.this.mColumnCount) {
                    Cell cell = MiddleColumnHeaderTable.this.getCell(n4, n3);
                    if (cell.getType() == CellType.BUTTON) {
                        MiddleColumnHeaderTable.this.select(n4, n3);
                        cell.getClickAction().doAction();
                    } else if (mouseEvent.getClickCount() >= this.clickCount) {
                        MiddleColumnHeaderTable.this.select(n4, n3);
                    } else {
                        MiddleColumnHeaderTable.this.selectRow(n4);
                    }
                } else {
                    MiddleColumnHeaderTable.this.select(n4, -1);
                }
            } else {
                MiddleColumnHeaderTable.this.mSelectedRow = -1;
                MiddleColumnHeaderTable.this.clearSelection();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getX() > MiddleColumnHeaderTable.this.mTableWidth) {
                MiddleColumnHeaderTable.this.setCursor(new Cursor(0));
            }
        }

        public void setClickCount(int n) {
            this.clickCount = n;
        }
    }
}

