/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import com.kt.gui.event.CallBackListener;
import java.awt.Dimension;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.im.InputSubset;
import jp.kitec.kwt.KFont;

public class LimitedTextField
extends TextField
implements KeyListener,
FocusListener {
    private int hanNum = -1;
    private int w = 0;
    private String mStopChars = null;
    private boolean mKanjiLimit = false;
    private CallBackListener mCallBackListener;
    private static boolean mJava2 = false;

    static {
        try {
            Class<?> clazz = Class.forName("java.awt.im.InputContext");
            mJava2 = clazz != null;
        }
        catch (Exception exception) {
            mJava2 = false;
        }
    }

    public LimitedTextField(String string, int n, KFont kFont) {
        super(string);
        this.addKeyListener(this);
        this.hanNum = n;
        if (kFont != null) {
            this.setFont(kFont.getFontObject());
            this.w = kFont.stringWidth("\u3000") * (this.hanNum / 2 + 1);
        }
    }

    public void addCallbackListener(CallBackListener callBackListener) {
        this.mCallBackListener = callBackListener;
    }

    public void setStopWords(String string) {
        this.mStopChars = string;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = this.w;
        return dimension;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.mCallBackListener != null) {
            this.mCallBackListener.actionCallBack(this);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c;
        int n;
        char c2 = keyEvent.getKeyChar();
        if (this.mStopChars != null) {
            n = 0;
            while (n < this.mStopChars.length()) {
                c = this.mStopChars.charAt(n);
                if (c2 == c) {
                    keyEvent.consume();
                    break;
                }
                ++n;
            }
        }
        if (this.hanNum > 0) {
            n = 0;
            c = c2 < '\u007f' ? (char)'\u0001' : '\u0002';
            String string = this.getText();
            int n2 = 0;
            while (n2 < string.length()) {
                char c3 = string.charAt(n2);
                n = c3 < '\u007f' ? ++n : (n += 2);
                if (n + c > this.hanNum) {
                    if (c2 == '\b' || c2 == '\u007f') break;
                    keyEvent.consume();
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean isBlank() {
        String string = this.getText();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != ' ' && string.charAt(n) != '\u3000') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void addKanjiIMELimit() {
        if (!mJava2) {
            return;
        }
        this.mKanjiLimit = true;
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.mKanjiLimit) {
            return;
        }
        this.getInputContext().setCharacterSubsets(new Character.Subset[]{InputSubset.KANJI});
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.mKanjiLimit) {
            return;
        }
        this.getInputContext().setCharacterSubsets(null);
    }
}

