/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import com.kt.util.UtilString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KMouseEvent;
import jp.kitec.richui.KTabItem;

public class KTabView
extends Panel
implements MouseListener,
ActionListener,
FocusListener {
    protected Vector mItems;
    private int mOfsX = 0;
    protected PopupMenu mPopup;
    protected KTabItem mCurrentHit;
    protected boolean mDispPop = false;
    protected boolean mTabDir;
    private Color mBackColor;
    private Dimension mDimension;

    public KTabView(boolean bl, Color color) {
        this.mBackColor = color;
        this.setBackground(color);
        this.mPopup = new PopupMenu();
        this.add(this.mPopup);
        this.mItems = new Vector();
        this.mTabDir = bl;
        this.mBackColor = color;
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    public void addTab(String string) {
        this.addTab(string, Color.white, Color.lightGray);
    }

    public void addTab(String string, Color color, Color color2) {
        KTabItem kTabItem = new KTabItem(string, KFont.getFont("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 0, 12.0f), color, color2, this.mTabDir);
        this.setBackground(Color.lightGray);
        this.mItems.addElement(kTabItem);
    }

    public void left() {
        int n;
        Dimension dimension = this.getSize();
        int n2 = -2147483647;
        int n3 = Integer.MAX_VALUE;
        KTabItem kTabItem = null;
        int n4 = 0;
        while (n4 < this.mItems.size()) {
            KTabItem kTabItem2 = (KTabItem)this.mItems.elementAt(n4);
            if (kTabItem == null && kTabItem2.getBound().x >= 0) {
                kTabItem = kTabItem2;
            }
            int n5 = kTabItem2.getBound().x + kTabItem2.getBound().width + KTabItem.SPACE;
            int n6 = kTabItem2.getBound().x - KTabItem.SPACE;
            n2 = n5 > n2 ? n5 : n2;
            n3 = n6 < n3 ? n6 : n3;
            ++n4;
        }
        n4 = this.mItems.indexOf(kTabItem);
        if (this.mItems.size() > n4 + 1) {
            kTabItem = (KTabItem)this.mItems.elementAt(n4 + 1);
        }
        this.mOfsX = (n = n2 - n3) < dimension.width ? 0 : (n2 - kTabItem.getBound().width > dimension.width ? -(kTabItem.getBound().x - n3 - KTabItem.SPACE) : dimension.width - n - 1);
        this.update();
        this.updatePos();
        this.repaint();
    }

    public void right() {
        int n;
        Dimension dimension = this.getSize();
        int n2 = -2147483647;
        int n3 = Integer.MAX_VALUE;
        KTabItem kTabItem = null;
        int n4 = 0;
        while (n4 < this.mItems.size()) {
            KTabItem kTabItem2 = (KTabItem)this.mItems.elementAt(n4);
            if (kTabItem == null && kTabItem2.getBound().x - KTabItem.SPACE >= 0) {
                kTabItem = kTabItem2;
            }
            int n5 = kTabItem2.getBound().x + kTabItem2.getBound().width + KTabItem.SPACE;
            int n6 = kTabItem2.getBound().x - KTabItem.SPACE;
            n2 = n5 > n2 ? n5 : n2;
            n3 = n6 < n3 ? n6 : n3;
            ++n4;
        }
        n4 = n2 - n3;
        if (n4 < dimension.width) {
            this.mOfsX = 0;
        }
        if ((n = this.mItems.indexOf(kTabItem)) > 0) {
            kTabItem = (KTabItem)this.mItems.elementAt(n - 1);
        }
        this.mOfsX = n2 - kTabItem.getBound().width > 0 ? -(kTabItem.getBound().x - n3 - KTabItem.SPACE) : 0;
        this.update();
        this.updatePos();
        this.repaint();
    }

    public void updatePos() {
        Dimension dimension = this.getSize();
        int n = -2147483647;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < this.mItems.size()) {
            KTabItem kTabItem = (KTabItem)this.mItems.elementAt(n3);
            int n4 = kTabItem.getBound().x + kTabItem.getBound().width + KTabItem.SPACE;
            int n5 = kTabItem.getBound().x - KTabItem.SPACE;
            n = n4 > n ? n4 : n;
            n2 = n5 < n2 ? n5 : n2;
            ++n3;
        }
        n3 = n - n2;
        if (n3 < dimension.width) {
            this.mOfsX = 0;
        }
    }

    public void update() {
        if (this.isUpdate()) {
            this.create();
        }
        Dimension dimension = this.getSize();
        int n = KTabItem.SPACE;
        int n2 = 0;
        while (n2 < this.mItems.size()) {
            KTabItem kTabItem = (KTabItem)this.mItems.elementAt(n2);
            kTabItem.updateBound();
            kTabItem.getBound().x = this.mOfsX + n;
            kTabItem.getBound().height = dimension.height - KTabItem.SPACE / 2;
            n += kTabItem.getBound().width;
            kTabItem.getBound().y = this.mTabDir ? dimension.height - kTabItem.getBound().height : 0;
            ++n2;
        }
    }

    public void update(Graphics graphics) {
        KTabItem kTabItem;
        Dimension dimension = this.getSize();
        if (this.mDimension == null || this.mDimension.width != dimension.width || this.mDimension.height != dimension.height) {
            this.mDimension = dimension;
            this.update();
        }
        graphics.setColor(this.mBackColor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n = 0;
        while (n < this.mItems.size()) {
            kTabItem = (KTabItem)this.mItems.elementAt(n);
            if (!kTabItem.isActive()) {
                kTabItem.paint(graphics);
            }
            ++n;
        }
        this.drawBorder(graphics);
        n = 0;
        while (n < this.mItems.size()) {
            kTabItem = (KTabItem)this.mItems.elementAt(n);
            if (kTabItem.isActive()) {
                kTabItem.paint(graphics);
            }
            ++n;
        }
    }

    protected void drawBorder(Graphics graphics) {
        graphics.setColor(Color.gray);
        Dimension dimension = this.getSize();
        if (this.mTabDir) {
            graphics.drawLine(0, dimension.height - 1, this.getSize().width, dimension.height - 1);
        } else {
            graphics.drawLine(0, 0, this.getSize().width, 0);
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = 180;
        return dimension;
    }

    public KTabItem getActiveTabItem() {
        int n = 0;
        while (n < this.mItems.size()) {
            KTabItem kTabItem = (KTabItem)this.mItems.elementAt(n);
            if (kTabItem.isActive()) {
                return kTabItem;
            }
            ++n;
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.updateHitTab(mouseEvent.getX(), mouseEvent.getY());
        if (!KMouseEvent.isRightButtonMask(mouseEvent.getModifiers())) {
            this.mDispPop = false;
        }
        if (KMouseEvent.isRightButtonMask(mouseEvent.getModifiers())) {
            if (!this.mDispPop) {
                this.createContext();
                if (this.mPopup.getItemCount() != 0) {
                    this.mDispPop = true;
                    this.goPop(mouseEvent);
                }
            }
            return;
        }
        if (this.mCurrentHit != null && !this.mCurrentHit.isActive()) {
            this.select(this.mCurrentHit.getName());
            this.update();
            this.select();
        }
        this.repaint();
    }

    protected void updateHitTab(int n, int n2) {
        KTabItem kTabItem;
        this.mCurrentHit = null;
        int n3 = 0;
        while (n3 < this.mItems.size()) {
            kTabItem = (KTabItem)this.mItems.elementAt(n3);
            if (kTabItem.isActive() && kTabItem.isInner(n, n2)) {
                this.mCurrentHit = kTabItem;
                break;
            }
            ++n3;
        }
        if (this.mCurrentHit == null) {
            n3 = 0;
            while (n3 < this.mItems.size()) {
                kTabItem = (KTabItem)this.mItems.elementAt(n3);
                if (!kTabItem.isActive() && kTabItem.isInner(n, n2)) {
                    this.mCurrentHit = kTabItem;
                    break;
                }
                ++n3;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void select(String string) {
        int n = 0;
        while (n < this.mItems.size()) {
            KTabItem kTabItem = (KTabItem)this.mItems.elementAt(n);
            if (!UtilString.isDiff(string, kTabItem.getName())) {
                kTabItem.setActive(true);
            } else {
                kTabItem.setActive(false);
            }
            ++n;
        }
    }

    protected void createContext() {
    }

    private synchronized void goPop(MouseEvent mouseEvent) {
        this.mPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    protected void select() {
    }

    protected boolean isUpdate() {
        return false;
    }

    protected void create() {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.mDispPop = false;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.mDispPop = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

