/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import jp.kitec.kwt.KColor;
import jp.kitec.richui.AScrollBar;
import jp.kitec.richui.CaptPanel;

class AScrollPanel
extends Panel {
    private Graphics mOffg;
    private Image mOffImg;
    private Dimension mOldD;
    private float width = 14.0f;
    private Rectangle tipRect;
    private float cp1x;
    private float cp2x;
    private float cpy;
    private float mValueDev;
    private CaptPanel mCaptPanel;
    protected Image mTex;
    private AScrollBar mParentBar;
    private Color mThemeColor;

    protected AScrollPanel(AScrollBar aScrollBar, Color color) {
        this(aScrollBar, color, null, 0);
    }

    protected AScrollPanel(AScrollBar aScrollBar, Color color, Object object, int n) {
        this.setBackground(Color.lightGray);
        this.mParentBar = aScrollBar;
        this.mThemeColor = color;
        this.tipRect = new Rectangle();
        this.mOldD = new Dimension();
    }

    public void setCaptPanel(CaptPanel captPanel) {
        this.mCaptPanel = captPanel;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        this.culcTipRect();
        if (this.mOffImg == null || this.getWidth() != this.mOldD.width || this.getHeight() != this.mOldD.height) {
            if (this.mOffg != null) {
                this.mOffg.dispose();
            }
            if (this.mOffImg != null) {
                this.mOffImg.flush();
            }
            this.mOffImg = this.createImage(this.getWidth(), this.getHeight());
            this.mOffg = this.mOffImg.getGraphics();
        }
        if (this.mTex != null) {
            int n = 0;
            while (n < this.getWidth()) {
                int n2 = 0;
                while (n2 < this.getHeight()) {
                    this.mOffg.drawImage(this.mTex, n, n2, null);
                    n2 += AScrollBar.yw;
                }
                n += AScrollBar.xw;
            }
        } else {
            this.mOffg.setColor(KColor.morelightGray);
            this.mOffg.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.mOffg.setColor(this.mThemeColor.darker());
        this.mOffg.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.mOffg.setColor(Color.gray);
        if (this.mParentBar.mCenterLine) {
            if (this.mParentBar.mMode == AScrollBar.MODE_HOR) {
                this.mOffg.fill3DRect((int)this.cp1x, (int)this.cpy - 1, (int)this.cp2x - (int)this.cp1x, 2, false);
            } else {
                this.mOffg.fill3DRect((int)this.cpy - 1, (int)this.cp1x, 2, (int)this.cp2x - (int)this.cp1x, false);
            }
        }
        if (this.mParentBar.isEnabled()) {
            this.mOffg.setColor(this.mThemeColor);
            this.mOffg.fillRect(this.tipRect.x, this.tipRect.y, this.tipRect.width, this.tipRect.height);
            this.mOffg.setColor(this.mThemeColor.darker().darker());
            this.mOffg.draw3DRect(this.tipRect.x, this.tipRect.y, this.tipRect.width, this.tipRect.height, true);
            this.mOffg.setColor(this.mThemeColor.brighter());
            this.mOffg.draw3DRect(this.tipRect.x + 1, this.tipRect.y + 1, this.tipRect.width - 2, this.tipRect.height - 2, true);
        }
        graphics.drawImage(this.mOffImg, 0, 0, null);
        this.mOldD.width = this.getWidth();
        this.mOldD.height = this.getHeight();
    }

    protected boolean isInController(int n, int n2) {
        return this.tipRect.contains(n, n2);
    }

    private void culcTipRect() {
        if (this.mParentBar.mMode == AScrollBar.MODE_HOR) {
            this.cp1x = 10.0f;
            this.cp2x = this.getWidth() - 10;
            this.cpy = this.getHeight() / 2;
        } else {
            this.cp1x = 10.0f;
            this.cp2x = this.getHeight() - 10;
            this.cpy = this.getWidth() / 2;
        }
        float f = this.mParentBar.mValue;
        if (f < this.mParentBar.mValueMin) {
            f = this.mParentBar.mValue = this.mParentBar.mValueMin;
        }
        if (f > this.mParentBar.mValueMax) {
            f = this.mParentBar.mValue = this.mParentBar.mValueMax;
        }
        this.mValueDev = this.cp1x + (this.cp2x - this.cp1x) * (f - this.mParentBar.mValueMin) / (this.mParentBar.mValueMax - this.mParentBar.mValueMin);
        if (this.mParentBar.mMode == AScrollBar.MODE_HOR) {
            this.tipRect.setBounds((int)(this.mValueDev - this.width / 2.0f), 1, (int)this.width, this.getHeight() - 3);
        } else {
            int n = (int)(this.width / 2.0f);
            this.tipRect.setBounds(1, (int)(this.mValueDev - (float)n), this.getWidth() - 3, n * 2);
        }
        if (this.mCaptPanel != null && !this.mCaptPanel.mInit) {
            this.mCaptPanel.mInit = true;
            this.mCaptPanel.repaint();
        }
    }

    protected float devToVal(int n) {
        float f = this.mParentBar.mValueMin + ((float)n - this.cp1x) / (this.cp2x - this.cp1x) * (this.mParentBar.mValueMax - this.mParentBar.mValueMin);
        if (f < this.mParentBar.mValueMin) {
            return this.mParentBar.mValueMin;
        }
        if (f > this.mParentBar.mValueMax) {
            return this.mParentBar.mValueMax;
        }
        return f;
    }

    protected int valToDev(float f) {
        int n = (int)((f - this.mParentBar.mValueMin) * (this.cp2x - this.cp1x) / (this.mParentBar.mValueMax - this.mParentBar.mValueMin) + this.cp1x);
        return n;
    }
}

