/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.kitec.kwt.KColor;
import jp.kitec.kwt.KFont;
import jp.kitec.richui.AScrollPanel;
import jp.kitec.richui.CaptPanel;
import jp.kitec.richui.GButton;
import jp.kitec.richui.TipsMessage;

public class AScrollBar
extends Panel
implements ActionListener,
MouseListener,
MouseMotionListener {
    public static short MODE_VER = 0;
    public static short MODE_HOR = 1;
    public static final String MODE_DRAG = "DRAG";
    public static final String MODE_FINAL = "FINAL";
    private int mMinimum = 200;
    protected short mMode;
    private AScrollPanel mScrollBar;
    private GButton mUp;
    private GButton mDown;
    private Component mScaleComponent;
    public float height = 20.0f;
    private ActionListener mActionListener;
    protected static int xw = 4;
    protected static int yw = 4;
    private float offset = 0.0f;
    private float offset2 = 0.0f;
    protected float mValue;
    protected float mValueMin;
    protected float mValueMax;
    protected boolean mCenterLine;
    private boolean mMouseDown;
    private String mTip = null;
    private TipsMessage mTm;
    private CaptPanel mCaptPanel;
    private Dimension mPresSize;

    public AScrollBar(short s, boolean bl, boolean bl2, Container container, Color color, boolean bl3, TipsMessage tipsMessage) {
        this(s, bl, bl2, true, container, color, bl3, tipsMessage);
    }

    public AScrollBar(short s, boolean bl, boolean bl2, boolean bl3, Container container, Color color, boolean bl4, TipsMessage tipsMessage) {
        this.mMode = s;
        this.mMouseDown = false;
        this.mTm = tipsMessage;
        this.mPresSize = null;
        this.mCenterLine = bl;
        if (bl2) {
            this.mUp = AScrollBar.createButtons(container, this.mMode, true, color);
            this.mUp.addActionListener(this);
            this.mDown = AScrollBar.createButtons(container, this.mMode, false, color);
            this.mDown.addActionListener(this);
        }
        if (bl3) {
            this.mScrollBar = new AScrollPanel(this, color);
            this.mScrollBar.addMouseListener(this);
            this.mScrollBar.addMouseMotionListener(this);
            this.mScrollBar.mTex = AScrollBar.getTexture(container, color, Color.white);
        }
        if (bl3) {
            this.setLayout(new BorderLayout());
            if (bl2) {
                if (s == MODE_VER) {
                    this.add((Component)this.mUp, "North");
                    this.add((Component)this.mDown, "South");
                } else {
                    this.add((Component)this.mUp, "West");
                    this.add((Component)this.mDown, "East");
                }
            }
            this.add((Component)this.mScrollBar, "Center");
        } else if (s == MODE_VER) {
            this.setLayout(new GridLayout(2, 1));
            this.add(this.mUp);
            this.add(this.mDown);
        } else {
            this.setLayout(new GridLayout(1, 2));
            this.add(this.mUp);
            this.add(this.mDown);
        }
        if (bl4) {
            KFont kFont = KFont.getFont("Dialog", KFont.PLAIN, 10.0f);
            this.mCaptPanel = new CaptPanel(this, this.mScrollBar, kFont);
            this.add((Component)this.mCaptPanel, "North");
            this.mScrollBar.setCaptPanel(this.mCaptPanel);
        }
    }

    public void setPrefSize(int n, int n2) {
        this.mPresSize = new Dimension(n, n2);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.mCaptPanel != null) {
            this.mCaptPanel.setForeground(color);
        }
    }

    public void setMinimum(int n) {
        this.mMinimum = n;
    }

    public void setTip(String string) {
        this.mTip = string;
    }

    public GButton getUpButton() {
        return this.mUp;
    }

    public GButton getDownButton() {
        return this.mDown;
    }

    private static Image getTexture(Container container, Color color, Color color2) {
        Image image = container.createImage(5, 5);
        Graphics graphics = image.getGraphics();
        graphics.setColor(color2);
        graphics.fillRect(0, 0, xw, yw);
        graphics.setColor(color);
        int n = 0;
        while (n < yw) {
            int n2 = 0;
            if (n % 2 != 0) {
                n2 = 1;
            }
            int n3 = 0;
            while (n3 < xw) {
                graphics.drawLine(n3 + n2, n, n3 + n2, n);
                n3 += 2;
            }
            ++n;
        }
        graphics.dispose();
        return image;
    }

    public void setInterval(float f, float f2, String string) {
        if (this.mCaptPanel != null) {
            this.mCaptPanel.setInterval(f, f2, string);
            this.mCaptPanel.repaint();
        }
    }

    private static GButton createButtons(Container container, short s, boolean bl, Color color) {
        return AScrollBar.createButtons(container, s, bl, color, 17, 25);
    }

    public static GButton createButtons(Container container, short s, boolean bl, Color color, int n, int n2) {
        Object object;
        int[] nArray;
        int[] nArray2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 3;
        if (s == MODE_VER) {
            n6 = n2;
            n5 = n;
            n4 = n6 / 2 + n6 % 2;
            n3 = n5 / 2 + n5 % 2;
            if (bl) {
                nArray2 = new int[]{n4 - n7 * 2, n4 + n7 * 2, n4};
                nArray = new int[]{n3 + n7, n3 + n7, n3 - n7};
            } else {
                nArray2 = new int[]{n4 - n7 * 2 + 1, n4, n4 + n7 * 2 - 1};
                nArray = new int[]{n3 - n7, n3 + n7 - 1, n3 - n7};
            }
        } else {
            n6 = n;
            n5 = n2;
            n4 = n6 / 2 + n6 % 2;
            n3 = n5 / 2 + n5 % 2;
            object = new int[]{n3 - n7 * 2, n3, n3 + n7 * 2};
            nArray = object;
            nArray2 = bl ? new int[]{n4 + n7, n4 - n7, n4 + n7} : new int[]{n4 - n7, n4 + n7, n4 - n7};
        }
        Image image = container.createImage(n6, n5);
        Graphics graphics = image.getGraphics();
        graphics.setColor(KColor.lightGray2);
        graphics.setColor(color);
        graphics.fillRect(0, 0, n6, n5);
        graphics.setColor(Color.black);
        graphics.fillPolygon(nArray2, nArray, 3);
        nArray = null;
        nArray2 = nArray;
        object = new GButton("", image, image, image, null, color, color, container, null, 1);
        ((GButton)object).setDrawFrame(true);
        ((GButton)object).setPushOffset(1);
        return object;
    }

    public void update() {
        this.mScrollBar.repaint();
    }

    public void setValues(float f, float f2, float f3) {
        this.mValueMin = f;
        this.mValueMax = f2;
        this.mValue = f3;
        this.mScrollBar.repaint();
    }

    public void setScaledComponent(Component component) {
        this.mScaleComponent = component;
    }

    public void addActionListener(ActionListener actionListener) {
        this.mActionListener = actionListener;
    }

    public void setOffset(float f, float f2) {
        this.offset = f;
        this.offset2 = f2;
    }

    public float getValue() {
        return this.mValue;
    }

    public void inc() {
        this.mValue += this.offset;
        if (this.mValue > this.mValueMax) {
            this.mValue = this.mValueMax;
        }
    }

    public void dec() {
        this.mValue -= this.offset;
        if (this.mValue < this.mValueMin) {
            this.mValue = this.mValueMin;
        }
    }

    public void inc2() {
        this.mValue += this.offset2;
        if (this.mValue > this.mValueMax) {
            this.mValue = this.mValueMax;
        }
    }

    public void dec2() {
        this.mValue -= this.offset2;
        if (this.mValue < this.mValueMin) {
            this.mValue = this.mValueMin;
        }
    }

    public float getMaximum() {
        return this.mValueMax;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mUp) {
            this.dec2();
        } else if (actionEvent.getSource() == this.mDown) {
            this.inc2();
        }
        this.forceEvent(MODE_FINAL);
        if (this.mScrollBar != null) {
            this.mScrollBar.repaint();
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.mScrollBar == null) {
            return dimension;
        }
        if (this.mPresSize != null && (this.mPresSize.width > 0 || this.mPresSize.height >= 0)) {
            dimension.width = this.mPresSize.width >= 0 ? this.mPresSize.width : dimension.width;
            dimension.height = this.mPresSize.height >= 0 ? this.mPresSize.height : dimension.height;
        } else if (this.mMode == MODE_HOR) {
            if (this.mScaleComponent != null) {
                dimension.width = this.mScaleComponent.getWidth();
            }
            dimension.height = (int)this.height + 6;
            if (dimension.width < this.mMinimum) {
                dimension.width = this.mMinimum;
            }
        } else {
            dimension.width = (int)this.height + 6;
            if (dimension.height < this.mMinimum) {
                dimension.height = this.mMinimum;
            }
        }
        return dimension;
    }

    public void forceEvent(String string) {
        if (this.mScrollBar != null) {
            this.mScrollBar.repaint();
        }
        this.mActionListener.actionPerformed(new ActionEvent(this, 0, string));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mScrollBar.isInController(mouseEvent.getX(), mouseEvent.getY())) {
            this.mMouseDown = true;
            return;
        }
        int n = this.mMode == MODE_HOR ? mouseEvent.getX() : mouseEvent.getY();
        if (this.mScrollBar.devToVal(n) > this.mValue) {
            this.inc();
        } else {
            this.dec();
        }
        this.forceEvent(MODE_FINAL);
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mMouseDown) {
            this.forceEvent(MODE_FINAL);
        }
        this.mMouseDown = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mMouseDown) {
            this.mValue = this.mMode == MODE_HOR ? this.mScrollBar.devToVal(mouseEvent.getX()) : this.mScrollBar.devToVal(mouseEvent.getY());
            this.forceEvent(MODE_DRAG);
            this.mScrollBar.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mTm != null) {
            this.mTm.setMessage(this.mTip);
            this.mTm.update();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mTm != null) {
            this.mTm.setMessage(null);
            this.mTm.update();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

