/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt;

import com.kt.geom.K2DPathFigureArc;
import com.kt.geom.K2DPathFigureLine;
import com.kt.geom.K2DPathFigurePoint;
import com.kt.geom.KLocalAxis;
import com.kt.util.KCollection;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Vector;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KLineType;
import jp.kitec.kwt.KViewPort;
import jp.kitec.kwt.RichGraphicsUtil;

public class KRichGraphics
implements IRichGraphics {
    private static Stroke LINETYPE_DEF = new BasicStroke(1.0f);
    private Graphics mGC;
    private static RenderingHints qualityHints;
    private static boolean mNullStrokeMode;
    private static AffineTransform mWorkTransform;
    private GeneralPath _path = new GeneralPath();
    private static boolean mQuality;
    protected static final double RAD = Math.PI / 180;
    protected static final double[] COS_TABLE;
    protected static final double[] SIN_TABLE;
    public float mDotPerLen;
    private KViewPort mViewPort;
    public Dimension mDimension;

    static {
        mNullStrokeMode = true;
        mWorkTransform = new AffineTransform();
        KRichGraphics.setQuality(false);
        KRichGraphics.setNullStrokeEnd(true);
        COS_TABLE = new double[360];
        SIN_TABLE = new double[360];
        int n = 0;
        while (n < 360) {
            KRichGraphics.COS_TABLE[n] = Math.cos((double)n * (Math.PI / 180));
            KRichGraphics.SIN_TABLE[n] = Math.sin((double)n * (Math.PI / 180));
            ++n;
        }
    }

    public static void setQuality(boolean bl) {
        mQuality = bl;
        if (mQuality) {
            qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public static boolean getQuality() {
        return mQuality;
    }

    public static void setNullStrokeEnd(boolean bl) {
        mNullStrokeMode = bl;
    }

    private void updateDrawQuality(Graphics2D graphics2D) {
        graphics2D.setRenderingHints(qualityHints);
    }

    public void setGC(Graphics graphics) {
        this.mGC = graphics;
    }

    public Object getGC() {
        return this.mGC;
    }

    public void releaseGC() {
        this.mGC = null;
    }

    public void setViewPort(KViewPort kViewPort) {
        this.mViewPort = kViewPort;
    }

    public KViewPort getViewPort() {
        return this.mViewPort;
    }

    public void setSize(int n, int n2) {
        if (this.mDimension == null) {
            this.mDimension = new Dimension();
        }
        this.mDimension.width = n;
        this.mDimension.height = n2;
    }

    public Dimension getSize() {
        return this.mDimension;
    }

    public void setTextDrawer(Object object) {
    }

    public void setClipArea(float f, float f2, float f3, float f4) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            int n = this.realToDevX(Math.min(f, f3));
            int n2 = this.realToDevY(Math.max(f2, f4));
            int n3 = this.realToDevX(Math.max(f, f3));
            int n4 = this.realToDevY(Math.min(f2, f4));
            graphics2D.setClip(n, n2, n3 - n, n4 - n2);
        }
    }

    public void releaseClipArea() {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            Dimension dimension = this.mDimension;
            graphics2D.setClip(0, 0, dimension.width, dimension.height);
        }
    }

    public void setView(float f, float f2, float f3, float f4) {
        this.setView(f, f2, f3, f4, this.mDimension);
    }

    public void setView(float f, float f2, float f3, float f4, Dimension dimension) {
        KViewPort kViewPort = this.getViewPort();
        kViewPort.x1 = f < f3 ? f : f3;
        kViewPort.x2 = f < f3 ? f3 : f;
        kViewPort.y1 = f2 < f4 ? f2 : f4;
        kViewPort.y2 = f2 < f4 ? f4 : f2;
        kViewPort.cx = (kViewPort.x1 + kViewPort.x2) / 2.0f;
        kViewPort.cy = (kViewPort.y1 + kViewPort.y2) / 2.0f;
        this.updateViewScale(dimension);
    }

    public void setViewCenter(float f, float f2) {
        KViewPort kViewPort = this.getViewPort();
        float f3 = f - kViewPort.cx;
        float f4 = f2 - kViewPort.cy;
        kViewPort.cx += f3;
        kViewPort.cy += f4;
        kViewPort.x1 += f3;
        kViewPort.x2 += f3;
        kViewPort.y1 += f4;
        kViewPort.y2 += f4;
        this.updateViewScale(this.mDimension);
    }

    public void drawBufferImage(Image image) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            this.mGC.drawImage(image, 0, 0, null);
        }
    }

    public int realToDevX(double d2) {
        if (this.mDimension == null) {
            return 0;
        }
        return Math.round((float)((d2 - (double)this.getViewPort().cx) * (double)this.mDotPerLen + (double)(this.mDimension.width / 2)));
    }

    public int realToDevY(double d2) {
        if (this.mDimension == null) {
            return 0;
        }
        return Math.round((float)((double)this.mDimension.height - ((d2 - (double)this.getViewPort().cy) * (double)this.mDotPerLen + (double)(this.mDimension.height / 2))));
    }

    public float devToRealX(int n) {
        if (this.mDimension == null) {
            return 0.0f;
        }
        return (float)(n - this.mDimension.width / 2) / this.mDotPerLen + this.getViewPort().cx;
    }

    public float devToRealY(int n) {
        if (this.mDimension == null) {
            return 0.0f;
        }
        return (float)(this.mDimension.height / 2 - n) / this.mDotPerLen + this.getViewPort().cy;
    }

    public void updateViewScale(Dimension dimension) {
        KViewPort kViewPort = this.getViewPort();
        this.setViewScale(kViewPort.x1, kViewPort.y1, kViewPort.x2, kViewPort.y2, dimension);
    }

    private void setViewScale(float f, float f2, float f3, float f4, Dimension dimension) {
        if (dimension != null) {
            float f5 = (float)dimension.width / (f3 - f);
            float f6 = (float)dimension.height / (f4 - f2);
            this.mDotPerLen = f5 < f6 ? f5 : f6;
        }
    }

    public void setColor(Color color) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            graphics2D.setColor(color);
        }
    }

    public void drawLine(float f, float f2, float f3, float f4, KLineType kLineType) {
        if (this.mGC == null) {
            return;
        }
        float f5 = this.realToDevX(f);
        float f6 = this.realToDevY(f2);
        float f7 = this.realToDevX(f3);
        float f8 = this.realToDevY(f4);
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.draw(new Line2D.Double(f5, f6, f7, f8));
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawCircle(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        int n = this.realToDevX(f);
        int n2 = this.realToDevY(f2);
        int n3 = Math.round(f3 * this.mDotPerLen);
        if (n + n3 < 0 || n - n3 > this.mDimension.width) {
            return;
        }
        if (n2 + n3 < 0 || n2 - n3 > this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            if (f4 == f5) {
                graphics2D.draw(new Arc2D.Float(n - n3, n2 - n3, n3 * 2, n3 * 2, 0.0f, 360.0f, 0));
            } else {
                graphics2D.draw(new Arc2D.Float(n - n3, n2 - n3, n3 * 2, n3 * 2, f4, f5 - f4, 0));
            }
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawFillCircle(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        int n = this.realToDevX(f);
        int n2 = this.realToDevY(f2);
        int n3 = Math.round(f3 * this.mDotPerLen);
        if (n + n3 < 0 || n - n3 > this.mDimension.width) {
            return;
        }
        if (n2 + n3 < 0 || n2 - n3 > this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            if (f4 == f5) {
                graphics2D.fill(new Arc2D.Float(n - n3 - 0, n2 - n3, n3 * 2, n3 * 2, 0.0f, 360.0f, 0));
            } else {
                graphics2D.fill(new Arc2D.Float(n - n3 - 0, n2 - n3, n3 * 2, n3 * 2, f4, f5, 0));
            }
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawEllipse(float f, float f2, float f3, float f4, float f5, float f6, KLineType kLineType) {
        int n = this.realToDevX(f);
        int n2 = this.realToDevY(f2);
        int n3 = Math.round(f3 * this.mDotPerLen);
        int n4 = Math.round(f4 * this.mDotPerLen);
        if (n + n4 < 0 || n - n4 > this.mDimension.width) {
            return;
        }
        if (n2 + n3 < 0 || n2 - n3 > this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            if (f5 == f6) {
                graphics2D.draw(new Arc2D.Float(n - n4, n2 - n3, n4 * 2, n3 * 2, 0.0f, 360.0f, 0));
            } else {
                graphics2D.draw(new Arc2D.Float(n - n4, n2 - n3, n4 * 2, n3 * 2, f5, f6 - f5, 0));
            }
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawFillEllipse(float f, float f2, float f3, float f4, float f5, float f6, KLineType kLineType) {
        int n = this.realToDevX(f);
        int n2 = this.realToDevY(f2);
        int n3 = Math.round(f3 * this.mDotPerLen);
        int n4 = Math.round(f4 * this.mDotPerLen);
        if (n + n4 < 0 || n - n4 > this.mDimension.width) {
            return;
        }
        if (n2 + n3 < 0 || n2 - n3 > this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            if (f5 == f6) {
                graphics2D.fill(new Arc2D.Float(n - n4, n2 - n3, n4 * 2, n3 * 2, 0.0f, 360.0f, 0));
            } else {
                graphics2D.fill(new Arc2D.Float(n - n4, n2 - n3, n4 * 2, n3 * 2, f5, f6 - f5, 2));
            }
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawRect(float f, float f2, float f3, float f4, KLineType kLineType) {
        int n;
        int n2 = this.realToDevX(f);
        int n3 = this.realToDevY(f2);
        int n4 = this.realToDevX(f3);
        int n5 = this.realToDevY(f4);
        if (n2 > n4) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n3 < n5) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.draw(new Rectangle2D.Float(n2, n5, n4 - n2 + 1, n3 - n5 + 1));
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawFillRect(float f, float f2, float f3, float f4, KLineType kLineType) {
        int n;
        int n2 = this.realToDevX(f);
        int n3 = this.realToDevY(f2);
        int n4 = this.realToDevX(f3);
        int n5 = this.realToDevY(f4);
        if (n2 > n4) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n3 < n5) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.setStroke(new BasicStroke(3.0f * this.mDotPerLen));
            graphics2D.fill(new Rectangle2D.Float(n2, n5, n4 - n2 + 1, n3 - n5 + 1));
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        int n;
        int n2 = this.realToDevX(f);
        int n3 = this.realToDevY(f2);
        int n4 = this.realToDevX(f3);
        int n5 = this.realToDevY(f4);
        int n6 = (int)(f5 * this.mDotPerLen);
        if (n2 > n4) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n3 < n5) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.draw(new RoundRectangle2D.Double(n2, n5, n4 - n2 + 1, n3 - n5 + 1, n6, n6));
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawFillRoundRect(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        int n;
        int n2 = this.realToDevX(f);
        int n3 = this.realToDevY(f2);
        int n4 = this.realToDevX(f3);
        int n5 = this.realToDevY(f4);
        int n6 = (int)(f5 * this.mDotPerLen);
        if (n2 > n4) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n3 < n5) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.fill(new RoundRectangle2D.Double(n2, n5, n4 - n2 + 1, n3 - n5 + 1, n6, n6));
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawPolygon(KCollection kCollection, KLineType kLineType) {
        if (kCollection == null || kCollection.size() == 0) {
            return;
        }
        this.pathInit(0);
        int n = 0;
        while (n < kCollection.size()) {
            K2DPathFigurePoint k2DPathFigurePoint = (K2DPathFigurePoint)kCollection.elementAt(n);
            if (n == 0) {
                this.pathMoveTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
            } else {
                this.pathLineTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
            }
            ++n;
        }
        this.pathClose();
        this.drawPath(kLineType);
        this.pathClear();
    }

    public void drawFillPolygon(KCollection kCollection, KLineType kLineType) {
        if (kCollection == null || kCollection.size() == 0) {
            return;
        }
        this.pathInit(0);
        int n = 0;
        while (n < kCollection.size()) {
            K2DPathFigurePoint k2DPathFigurePoint = (K2DPathFigurePoint)kCollection.elementAt(n);
            if (n == 0) {
                this.pathMoveTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
            } else {
                this.pathLineTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
            }
            ++n;
        }
        this.pathClose();
        this.fillPath(kLineType);
        this.pathClear();
    }

    public void drawPolyLine(KCollection kCollection, KLineType kLineType) {
        if (kCollection == null || kCollection.size() == 0) {
            return;
        }
        this.pathInit(0);
        int n = 0;
        while (n < kCollection.size()) {
            K2DPathFigurePoint k2DPathFigurePoint = (K2DPathFigurePoint)kCollection.elementAt(n);
            if (n == 0) {
                this.pathMoveTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
            } else {
                this.pathLineTo(k2DPathFigurePoint.getX(), k2DPathFigurePoint.getY(), null);
            }
            ++n;
        }
        this.drawPath(kLineType);
        this.pathClear();
    }

    public void drawImage(Image image, float f, float f2) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            int n = this.realToDevX(f);
            int n2 = this.realToDevY(f2);
            graphics2D.drawImage(image, n, n2, null);
        }
    }

    public void drawImage(Image image, String string, float f, float f2, float f3, float f4) {
        this.drawImage(image, f, f2, f3, f4);
    }

    public void drawImage(Image image, String string, String string2, float f, float f2, float f3, float f4) {
        this.drawImage(image, f, f2, f3, f4);
    }

    public void drawImage(Image image, float f, float f2, float f3, float f4) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            int n;
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            int n2 = this.realToDevX(f);
            int n3 = this.realToDevY(f2);
            int n4 = this.realToDevX(f3);
            int n5 = this.realToDevY(f4);
            if (n2 > n4) {
                n = n2;
                n2 = n4;
                n4 = n;
            }
            if (n3 < n5) {
                n = n3;
                n3 = n5;
                n5 = n;
            }
            graphics2D.drawImage(image, n2, n5, n4 - n2, n3 - n5, null);
        }
    }

    public void drawText(String string, float f, float f2, String string2, int n, float f3, float f4) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            int n2 = this.realToDevX(f);
            int n3 = this.realToDevY(f2);
            while (f4 < 0.0f) {
                f4 += 360.0f;
            }
            if (this.mDimension == null || this.mDimension.width == 0 && this.mDimension.height == 0) {
                return;
            }
            if ((float)n3 - this.mDotPerLen * f3 > (float)this.mDimension.height || n3 < 0) {
                return;
            }
            if (n2 > this.mDimension.width) {
                return;
            }
            float f5 = (float)Math.floor(this.mDotPerLen * f3);
            KFont kFont = KFont.getFont(string2, n, f5);
            if ((float)n2 + kFont.stringWidthf(string) < 0.0f) {
                return;
            }
            graphics2D.setFont(kFont.getFontObject());
            if (f4 == 0.0f) {
                if (string.length() > 1) {
                    KFont kFont2 = KFont.getFont(string2, n, f3);
                    float f6 = kFont2.stringWidthf(string);
                    KFont kFont3 = kFont;
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < string.length()) {
                        String string3 = string.substring(n5, n5 + 1);
                        n4 = (int)((float)n4 + kFont3.stringWidthf(string3));
                        ++n5;
                    }
                    float f7 = f6 / (float)n4;
                    float f8 = f;
                    int n6 = 0;
                    while (n6 < string.length()) {
                        String string4 = string.substring(n6, n6 + 1);
                        int n7 = this.realToDevX(f8);
                        if (string4.length() > 0) {
                            graphics2D.drawString(string4, n7, n3);
                        }
                        f8 += kFont3.stringWidthf(string4) * f7;
                        ++n6;
                    }
                } else if (string.length() > 0) {
                    graphics2D.drawString(string, n2, n3);
                }
            } else {
                mWorkTransform.setToIdentity();
                mWorkTransform.rotate((double)(-f4) * Math.PI / 180.0, n2, n3);
                graphics2D.setTransform(mWorkTransform);
                graphics2D.drawString(string, n2, n3);
                mWorkTransform.setToIdentity();
                graphics2D.setTransform(mWorkTransform);
            }
        }
    }

    public void drawShadePolygon(Vector vector, float f, float f2, float f3, float f4, Color color, Color color2) {
        this.pathInit(0);
        int n = 0;
        while (n < vector.size()) {
            float[] fArray;
            KCollection kCollection = (KCollection)vector.elementAt(n);
            int n2 = 0;
            while (n2 < kCollection.size()) {
                fArray = (float[])kCollection.elementAt(n2);
                if (n2 == 0) {
                    this.pathMoveTo(fArray[0], fArray[1], null);
                } else {
                    this.pathLineTo(fArray[0], fArray[1], null);
                }
                ++n2;
            }
            fArray = (float[])kCollection.elementAt(0);
            this.pathLineTo(fArray[0], fArray[1], null);
            ++n;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            f = this.realToDevX(f);
            f3 = this.realToDevX(f3);
            graphics2D.setPaint(new GradientPaint(f, f2, color, f3, f2, color2));
            this.fillPath(null);
            this.pathClear();
            graphics2D.setPaint(null);
        }
    }

    public void drawTextCenter(float f, float f2, KFont kFont, String string, Color color) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            int n = this.realToDevX(f);
            int n2 = this.realToDevY(f2);
            graphics2D.setFont(kFont.getFontObject());
            this.setColor(color);
            int n3 = kFont.stringWidth(string) / 2;
            int n4 = kFont.getHeight() / 2;
            if (string.length() > 0) {
                graphics2D.drawString(string, n - n3, n2 + n4);
            }
        }
    }

    public void drawMark(float f, float f2, int n, int n2) {
        int n3 = this.realToDevX(f);
        int n4 = this.realToDevY(f2);
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            switch (n2) {
                case 0: {
                    graphics2D.drawArc(n3 - n, n4 - n, n * 2, n * 2, 0, 360);
                    break;
                }
                case 1: {
                    graphics2D.fillArc(n3 - n, n4 - n, n * 2, n * 2, 0, 360);
                    break;
                }
                case 2: {
                    graphics2D.drawRect(n3 - n, n4 - n, n * 2, n * 2);
                    break;
                }
                case 3: {
                    graphics2D.fillRect(n3 - n, n4 - n, n * 2, n * 2);
                    break;
                }
                case 4: {
                    graphics2D.drawLine(n3 - n, n4, n3 + n, n4);
                    graphics2D.drawLine(n3, n4 - n, n3, n4 + n);
                }
            }
        }
    }

    public boolean isInCanvas(int n, int n2) {
        if (n < 0 || n > this.mDimension.width) {
            return false;
        }
        return n2 >= 0 && n2 <= this.mDimension.height;
    }

    private void setStroke(Graphics2D graphics2D, KLineType kLineType) {
        if (kLineType != null) {
            float f = kLineType.mWidth;
            if (kLineType.mWidthType == 0) {
                f *= this.mDotPerLen;
            }
            if (kLineType.mStroke != null) {
                float[] fArray = kLineType.mStroke;
                if (kLineType.mWidthType == 0) {
                    float[] fArray2 = new float[fArray.length];
                    int n = 0;
                    while (n < fArray.length) {
                        fArray2[n] = fArray[n] * this.mDotPerLen;
                        ++n;
                    }
                    fArray = fArray2;
                }
                graphics2D.setStroke(new BasicStroke(f, 0, 0, 1.0f, fArray, 0.0f));
            } else if (mNullStrokeMode) {
                graphics2D.setStroke(new BasicStroke(f, 0, 0));
            } else {
                graphics2D.setStroke(new BasicStroke(f));
            }
        } else {
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void pathInit(int n) {
        this.pathClear();
        this._path.setWindingRule(n);
    }

    public void pathClear() {
        this._path.reset();
    }

    private float getx(double d2, double d3, KLocalAxis kLocalAxis) {
        float f = kLocalAxis == null ? (float)this.realToDevX((float)d2) : (float)this.realToDevX(kLocalAxis.getGlobalX((float)d2, (float)d3));
        return f;
    }

    private float gety(double d2, double d3, KLocalAxis kLocalAxis) {
        float f = kLocalAxis == null ? (float)this.realToDevY((float)d3) : (float)this.realToDevY(kLocalAxis.getGlobalY((float)d2, (float)d3));
        return f;
    }

    public void pathMoveTo(double d2, double d3, KLocalAxis kLocalAxis) {
        Point2D point2D = this._path.getCurrentPoint();
        float f = this.getx(d2, d3, kLocalAxis);
        float f2 = this.gety(d2, d3, kLocalAxis);
        if (point2D != null && RichGraphicsUtil.isSame2D(f, f2, point2D.getX(), point2D.getY())) {
            return;
        }
        this._path.moveTo(f, f2);
    }

    public void pathLineTo(double d2, double d3, KLocalAxis kLocalAxis) {
        this._path.lineTo(this.getx(d2, d3, kLocalAxis), this.gety(d2, d3, kLocalAxis));
    }

    public void pathQuadTo(float f, float f2, float f3, float f4, KLocalAxis kLocalAxis) {
        this._path.quadTo(this.getx(f, f2, kLocalAxis), this.gety(f, f2, kLocalAxis), this.getx(f3, f4, kLocalAxis), this.gety(f3, f4, kLocalAxis));
    }

    public void pathCurveTo(float f, float f2, float f3, float f4, float f5, float f6, KLocalAxis kLocalAxis) {
        this._path.curveTo(this.getx(f, f2, kLocalAxis), this.gety(f, f2, kLocalAxis), this.getx(f3, f4, kLocalAxis), this.gety(f3, f4, kLocalAxis), this.getx(f5, f6, kLocalAxis), this.gety(f5, f6, kLocalAxis));
    }

    public void pathClose() {
        this._path.closePath();
    }

    public void pathAdd(KCollection kCollection, KLocalAxis kLocalAxis) {
        float f;
        float f2;
        if (kCollection.size() < 2) {
            return;
        }
        K2DPathFigureLine k2DPathFigureLine = (K2DPathFigureLine)kCollection.elementAt(0);
        K2DPathFigureLine k2DPathFigureLine2 = (K2DPathFigureLine)kCollection.elementAt(1);
        if (RichGraphicsUtil.isSame2D(k2DPathFigureLine.getX1(), k2DPathFigureLine.getY1(), k2DPathFigureLine2.getX1(), k2DPathFigureLine2.getY1()) || RichGraphicsUtil.isSame2D(k2DPathFigureLine.getX1(), k2DPathFigureLine.getY1(), k2DPathFigureLine2.getX2(), k2DPathFigureLine2.getY2())) {
            f2 = (float)k2DPathFigureLine.getX2();
            f = (float)k2DPathFigureLine.getY2();
        } else {
            f2 = (float)k2DPathFigureLine.getX1();
            f = (float)k2DPathFigureLine.getY1();
        }
        this.pathMoveTo(f2, f, kLocalAxis);
        int n = 0;
        while (n < kCollection.size()) {
            k2DPathFigureLine = (K2DPathFigureLine)kCollection.elementAt(n);
            k2DPathFigureLine2 = (K2DPathFigureLine)kCollection.elementAt(n + 1);
            boolean bl = false;
            if (RichGraphicsUtil.isSame2D(k2DPathFigureLine.getX1(), k2DPathFigureLine.getY1(), k2DPathFigureLine2.getX1(), k2DPathFigureLine2.getY1()) || RichGraphicsUtil.isSame2D(k2DPathFigureLine.getX1(), k2DPathFigureLine.getY1(), k2DPathFigureLine2.getX2(), k2DPathFigureLine2.getY2())) {
                bl = true;
            }
            if (k2DPathFigureLine instanceof K2DPathFigureArc) {
                K2DPathFigureArc k2DPathFigureArc = (K2DPathFigureArc)k2DPathFigureLine;
                float f3 = (float)k2DPathFigureArc.getRadius();
                float f4 = (float)k2DPathFigureArc.getCX();
                float f5 = (float)k2DPathFigureArc.getCY();
                float f6 = (float)RichGraphicsUtil.getAngle2D(f4, f5, k2DPathFigureArc.getX1(), k2DPathFigureArc.getY1());
                float f7 = (float)RichGraphicsUtil.getAngle2D(f4, f5, k2DPathFigureArc.getX2(), k2DPathFigureArc.getY2());
                float f8 = f7 - f6;
                while (f8 < 0.0f) {
                    f8 += 360.0f;
                }
                if (k2DPathFigureArc.isCw()) {
                    f8 = -(360.0f - f8);
                }
                if (bl) {
                    f8 = -f8;
                }
                this.pathArc(f4, f5, f3, f3, bl ? f7 : f6, f8, kLocalAxis);
            } else if (bl) {
                this.pathLineTo((float)k2DPathFigureLine.getX1(), (float)k2DPathFigureLine.getY1(), kLocalAxis);
            } else {
                this.pathLineTo((float)k2DPathFigureLine.getX2(), (float)k2DPathFigureLine.getY2(), kLocalAxis);
            }
            ++n;
        }
    }

    public void fillPath(KLineType kLineType) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.fill(this._path);
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawPath(KLineType kLineType) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.draw(this._path);
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void pathArc(float f, float f2, float f3, float f4, float f5, KLocalAxis kLocalAxis) {
        this.pathArc(f, f2, f3, f3, f4, f5, kLocalAxis);
    }

    private void pathArc(float f, float f2, float f3, float f4, float f5, float f6, KLocalAxis kLocalAxis) {
        double d2 = 4.0;
        float f7 = f3 * 2.0f;
        float f8 = f4 * 2.0f;
        double d3 = (double)f6 * Math.PI / 180.0;
        double d4 = d3 / d2;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        dArray[1] = 1.0;
        dArray[0] = 1.0;
        dArray2[0] = 0.0;
        dArray[3] = d5;
        dArray2[3] = d6;
        dArray[2] = (8.0 * Math.cos(d4 / 2.0) - (dArray[0] + 3.0 * dArray[1] + dArray[3])) / 3.0;
        dArray2[2] = dArray2[3] - (-dArray[2] + dArray[3]) / -Math.tan(d4);
        dArray2[1] = (8.0 * Math.sin(d4 / 2.0) - (dArray2[0] + 3.0 * dArray2[2] + dArray2[3])) / 3.0;
        double d7 = (double)f5 * Math.PI / 180.0;
        double d8 = Math.cos(d7);
        double d9 = Math.sin(d7);
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        int n = 0;
        while (n < 4) {
            dArray3[n] = dArray[n] * d8 - dArray2[n] * d9;
            dArray4[n] = dArray[n] * d9 + dArray2[n] * d8;
            dArray[n] = dArray3[n];
            dArray2[n] = dArray4[n];
            ++n;
        }
        float f9 = f8 / f7;
        if (Float.isNaN(f9)) {
            f9 = 1.0f;
        }
        this.pathMoveTo((float)((double)f3 * dArray[0]) + f, (float)((double)f3 * dArray2[0]) * f9 + f2, kLocalAxis);
        int n2 = 0;
        while ((double)n2 < d2) {
            this.pathCurveTo((float)((double)f3 * dArray[1]) + f, (float)((double)f3 * dArray2[1]) * f9 + f2, (float)((double)f3 * dArray[2]) + f, (float)((double)f3 * dArray2[2]) * f9 + f2, (float)((double)f3 * dArray[3]) + f, (float)((double)f3 * dArray2[3]) * f9 + f2, kLocalAxis);
            int n3 = 1;
            while (n3 < 4) {
                dArray3[n3] = dArray[n3] * d5 - dArray2[n3] * d6;
                dArray4[n3] = dArray[n3] * d6 + dArray2[n3] * d5;
                dArray[n3] = dArray3[n3];
                dArray2[n3] = dArray4[n3];
                ++n3;
            }
            ++n2;
        }
    }

    public void shadePath(KLineType kLineType, float f, float f2, float f3, float f4, Color color, Color color2, boolean bl) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            f = this.realToDevX(f);
            f3 = this.realToDevX(f3);
            f2 = this.realToDevY(f2);
            f4 = this.realToDevY(f4);
            if (!bl) {
                graphics2D.setPaint(new GradientPaint(f, f2, color, f3, f4, color2));
            } else {
                f3 = f + (f3 - f) / 2.0f;
                f4 = f2 + (f4 - f2) / 2.0f;
                graphics2D.setPaint(new GradientPaint(f, f2, color, f3, f4, color2, bl));
            }
            graphics2D.fill(this._path);
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }
}

