/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.Vector;

public class KFont {
    public static int PLAIN = 0;
    public static int BOLD = 0;
    public static int ITALIC = 2;
    private static Vector mFonts = new Vector();
    private Font mFontObject;
    private FontMetrics mFontMetrics;
    private String mFontname;
    private int mFonttype;
    private float mFontsize;

    public static final KFont getFont(String string, int n, float f) {
        int n2 = 0;
        while (n2 < mFonts.size()) {
            KFont kFont = (KFont)mFonts.elementAt(n2);
            if (kFont.getName().equalsIgnoreCase(string) && Math.abs(kFont.getSize() - f) < 0.1f && n == kFont.getStyle()) {
                return kFont;
            }
            ++n2;
        }
        KFont kFont = new KFont(string, n, f);
        kFont.createMetrics();
        mFonts.addElement(kFont);
        return kFont;
    }

    public static KFont getFont(Object object) {
        if (object == null || !(object instanceof Font)) {
            return null;
        }
        Font font = (Font)object;
        int n = 0;
        while (n < mFonts.size()) {
            KFont kFont = (KFont)mFonts.elementAt(n);
            if (kFont.getName().equals(font.getName()) && kFont.getStyle() == font.getStyle() && Math.abs(kFont.getSize() - (float)font.getSize()) < 0.1f) {
                return kFont;
            }
            ++n;
        }
        KFont kFont = new KFont(font.getName(), font.getStyle(), font.getSize());
        kFont.createMetrics();
        mFonts.addElement(kFont);
        return kFont;
    }

    private KFont(String string, int n, float f) {
        this.mFontObject = new Font(string, n, (int)f);
        this.mFontname = string;
        this.mFonttype = n;
        this.mFontsize = f;
        this.createMetrics();
    }

    private void createMetrics() {
        this.mFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.mFontObject);
    }

    public Font getFontObject() {
        return this.mFontObject;
    }

    public String getName() {
        return this.mFontname;
    }

    public int getStyle() {
        return this.mFonttype;
    }

    public float getSize() {
        return this.mFontsize;
    }

    public int stringWidth(String string) {
        if (this.mFontsize < 5.0f) {
            float f = KFont.getFont((String)this.getName(), (int)0, (float)12.0f).mFontMetrics.stringWidth(string);
            return Math.round(f * this.mFontsize / 12.0f);
        }
        float f = KFont.getFont((String)this.getName(), (int)0, (float)this.mFontsize).mFontMetrics.stringWidth(string);
        return Math.round(f);
    }

    public int getHeight() {
        if (this.mFontMetrics != null) {
            return this.mFontMetrics.getHeight();
        }
        return 0;
    }

    public int getAscent() {
        if (this.mFontMetrics != null) {
            return this.mFontMetrics.getAscent();
        }
        return 0;
    }

    public int getDescent() {
        if (this.mFontMetrics != null) {
            return this.mFontMetrics.getDescent();
        }
        return 0;
    }

    public float stringWidthf(String string) {
        if (this.mFontsize <= 5.0f) {
            return (float)KFont.getFont((String)this.getName(), (int)0, (float)12.0f).mFontMetrics.stringWidth(string) * this.mFontsize / 12.0f;
        }
        return KFont.getFont((String)this.getName(), (int)0, (float)this.mFontsize).mFontMetrics.stringWidth(string);
    }

    public float getHeightf() {
        if (this.mFontsize <= 5.0f) {
            return (float)KFont.getFont(this.getName(), 0, 12.0f).getHeight() * this.mFontsize / 12.0f;
        }
        return KFont.getFont(this.getName(), 0, this.mFontsize).getHeight();
    }

    public float getAscentf() {
        if (this.mFontsize <= 5.0f) {
            return (float)KFont.getFont(this.getName(), 0, 12.0f).getAscent() * this.mFontsize / 12.0f;
        }
        return KFont.getFont(this.getName(), 0, this.mFontsize).getAscent();
    }

    public float getDescentf() {
        if (this.mFontsize <= 5.0f) {
            return (float)KFont.getFont(this.getName(), 0, 12.0f).getDescent() * this.mFontsize / 12.0f;
        }
        return KFont.getFont(this.getName(), 0, this.mFontsize).getDescent();
    }
}

