/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util.xml;

import com.kt.io.AbstFile;
import com.kt.io.Base64Decoder;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class XMLReader {
    private static final String[][] COMMENT = new String[][]{{"<?", "?>"}, {"<!--", "-->"}};
    protected AbstFile mInput;
    protected boolean mCanRead;
    protected boolean mEOF;
    private String mRemain = "";

    public XMLReader(String string) {
        try {
            this.mCanRead = this.setFile(new FileInputStream(string), string);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public XMLReader(InputStream inputStream) {
        this.mCanRead = this.setFile(inputStream, "");
    }

    public XMLReader(AbstFile abstFile) {
        if (abstFile != null) {
            this.mInput = abstFile;
            this.mCanRead = true;
        }
    }

    protected boolean setFile(InputStream inputStream, String string) {
        if (inputStream == null) {
            return false;
        }
        this.mInput = new AbstFile();
        this.mInput.inputStreamToBuffer(inputStream, string);
        return true;
    }

    public ObjectFolder read(String string) {
        if (string == null) {
            return this.read();
        }
        if (!this.open(string)) {
            return null;
        }
        ObjectFolder objectFolder = this.parseXML();
        this.close();
        if (objectFolder == null || objectFolder.getChildlen().size() < 1) {
            return null;
        }
        return objectFolder;
    }

    public ObjectFolder read() {
        if (!this.open()) {
            return null;
        }
        ObjectFolder objectFolder = this.parseXML();
        this.close();
        if (objectFolder == null || objectFolder.getChildlen().size() < 1) {
            return null;
        }
        return objectFolder;
    }

    protected boolean open(String string) {
        if (string == null) {
            return this.open();
        }
        if (this.mCanRead) {
            this.mInput.openReadFileFromBuffer(string);
            this.mEOF = false;
            return true;
        }
        return false;
    }

    protected boolean open() {
        if (this.mCanRead) {
            this.mInput.openReadFileFromBuffer();
            this.mEOF = false;
            return true;
        }
        return false;
    }

    protected boolean close() {
        this.mInput.closeReadFileFromBuffer();
        return true;
    }

    protected ObjectFolder parseXML() {
        String string;
        ObjectFolder objectFolder;
        ObjectFolder objectFolder2 = objectFolder = new ObjectFolder("");
        while ((string = this.readXML()) != null) {
            int n = 0;
            while (n < string.length() - 1) {
                int n2 = this.indexOfDelimiter(string, n);
                objectFolder = this.parseElement(string.substring(n, n2).trim(), objectFolder);
                n = n2 - 1;
                ++n;
            }
        }
        return objectFolder2;
    }

    protected int indexOfDelimiter(String string, int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = n + 1;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (n2 == 0 && c == '=') {
                bl = true;
            } else if (bl && c == '\"') {
                n2 = (short)(n2 + 1);
            } else if (c == ' ' && n2 != 1) break;
            ++n3;
        }
        return n3;
    }

    protected ObjectFolder parseElement(String string, ObjectFolder objectFolder) {
        String string2 = null;
        String string3 = null;
        if (string != null && string.length() > 0) {
            int n = string.indexOf(61);
            if (n >= 0) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1, string.length());
                int n2 = string3.indexOf(34);
                int n3 = string3.lastIndexOf(34);
                if (n2 >= 0 && n3 >= 0 && n3 > n2) {
                    string3 = string3.substring(n2 + 1, n3);
                }
                if (string3 != null) {
                    string3 = this.getValue(string3);
                }
            } else {
                string2 = string;
            }
        }
        if (string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "<> ");
            string2 = (String)stringTokenizer.nextElement();
            if (string3 == null) {
                if (string2.charAt(0) == '/' || string2.equalsIgnoreCase("/")) {
                    objectFolder = objectFolder.getParent();
                } else {
                    ObjectFolder objectFolder2 = new ObjectFolder(string2);
                    objectFolder.addChild(objectFolder2, true);
                    objectFolder = objectFolder2;
                }
            } else {
                try {
                    objectFolder.addChild(new ObjectNode(string2, string3), true);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        }
        return objectFolder;
    }

    protected String getValue(String string) {
        int n = string.indexOf("__BEGIN_BASE64ENCODED__");
        int n2 = string.indexOf("__END_BASE64ENCODED__");
        if (n == 0 && n2 > 0) {
            String string2 = string.substring("__BEGIN_BASE64ENCODED__".length(), n2);
            string = new String(Base64Decoder.decode(string2));
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    protected String readXML() {
        if (this.mEOF) {
            return null;
        }
        var1_1 = new StringBuffer(128);
        var1_1.append(this.mRemain);
        this.mRemain = "";
        var2_2 = this.readLineWithoutComment();
        if (var2_2 != null) ** GOTO lbl33
        return null;
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2.lastIndexOf("/>");
            var4_4 = var2_2.length();
            if (var3_3 < 0) {
                var3_3 = var2_2.lastIndexOf(">");
                if (var3_3 < 0) {
                    var1_1.append(String.valueOf(var2_2) + "\n");
                    var2_2 = this.readLineWithoutComment();
                    continue;
                }
                var1_1.append(var2_2.substring(0, var3_3).trim());
                var1_1.append(">");
                if (var3_3 + 1 == var4_4) break;
                this.mRemain = var2_2.substring(var3_3 + 1, var4_4);
                break;
            }
            if (var3_3 + 2 != var4_4) {
                this.mRemain = var2_2.substring(var3_3 + 2, var4_4);
            }
            var1_1.append(var2_2.substring(0, var3_3));
            var1_1.append(" />");
            break;
lbl33:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl34:
        // 4 sources

        if (var2_2 == null) {
            this.mEOF = true;
        }
        if (var1_1.length() > 0) {
            return var1_1.toString();
        }
        return null;
    }

    protected String readLineWithoutComment() {
        String string = this.readLine();
        while (string != null) {
            if (string.length() == 0) {
                string = "";
            }
            boolean bl = false;
            int n = 0;
            while (n < COMMENT.length) {
                if (string.startsWith(COMMENT[n][0])) {
                    string = this.trimComment(string, COMMENT[n][0], COMMENT[n][1]);
                    bl = true;
                }
                ++n;
            }
            if (!bl) break;
        }
        return string;
    }

    protected String trimComment(String string, String string2, String string3) {
        int n;
        if (string == null) {
            return null;
        }
        if (!string.startsWith(string2)) {
            return string;
        }
        int n2 = string3.length();
        while ((n = string.lastIndexOf(string3)) < 0) {
            string = this.readLine();
            if (string != null) continue;
            return null;
        }
        int n3 = string.length();
        string = n + n2 != n3 ? string.substring(n + n2, n3).trim() : this.readLine();
        return string;
    }

    protected String readLine() {
        String string = this.mInput.readLineFromBuffer();
        if (string != null) {
            return string.trim();
        }
        return null;
    }
}

