/*
 * Decompiled with CFR 0.152.
 */
package com.kt.io.util;

public class RGBCounter {
    private int[][][] tree;
    private int[] pix;
    private int[] tbl;
    private int lim;
    private int count;
    private int rrggbb;
    private int rr;
    private int gg;
    private int bb;

    public RGBCounter(int[] nArray, int n) {
        this.pix = nArray;
        this.lim = n;
        this.tree = new int[256][][];
        this.tbl = new int[n + 1];
    }

    public int count() {
        int n = 0;
        while (n < this.pix.length) {
            this.splitRGB(this.pix[n]);
            if (this.tree[this.rr] == null) {
                if (this.overCount()) break;
                this.tree[this.rr] = new int[256][];
                this.tree[this.rr][this.gg] = new int[256];
                this.addRGB(true);
            } else if (this.tree[this.rr][this.gg] == null) {
                if (this.overCount()) break;
                this.tree[this.rr][this.gg] = new int[256];
                this.addRGB(true);
            } else if (this.tree[this.rr][this.gg][this.bb] < 0) {
                if (this.overCount()) break;
                this.addRGB(false);
            }
            ++n;
        }
        return this.count;
    }

    private boolean overCount() {
        boolean bl;
        boolean bl2 = bl = this.count >= this.lim;
        if (bl) {
            this.count = -1;
        }
        return bl;
    }

    private void splitRGB(int n) {
        this.rrggbb = n & 0xFFFFFF;
        this.rr = this.rrggbb >> 16;
        this.gg = this.rrggbb >> 8 & 0xFF;
        this.bb = this.rrggbb & 0xFF;
    }

    private void addRGB(boolean bl) {
        if (bl) {
            int n = 0;
            while (n < 256) {
                this.tree[this.rr][this.gg][n] = -1;
                ++n;
            }
        }
        this.tree[this.rr][this.gg][this.bb] = this.count;
        this.tbl[this.count] = this.rrggbb;
        ++this.count;
    }

    public int[] getTable() {
        if (this.count > this.lim) {
            return null;
        }
        return this.tbl;
    }

    public int getIndex(int n) {
        this.splitRGB(n);
        return this.tree[this.rr][this.gg][this.bb];
    }
}

