/*
 * Decompiled with CFR 0.152.
 */
package com.kt.io.util;

public class ByteArrayManipulator {
    private int len;
    private int h2;
    private int l2;
    private int h4;
    private int l4;
    private int h8;
    private int l8;
    private byte[] bytes;

    public byte[] getBytes() {
        return this.bytes;
    }

    public ByteArrayManipulator(boolean bl) {
        this.h2 = bl ? 0 : 1;
        this.l2 = 1 - this.h2;
        this.h4 = this.h2 << 1;
        this.l4 = this.l2 << 1;
        this.h8 = this.h4 << 1;
        this.l8 = this.l4 << 1;
    }

    public ByteArrayManipulator(int n, boolean bl) {
        this(bl);
        this.len = n;
        this.bytes = new byte[n];
    }

    public ByteArrayManipulator(byte[] byArray, boolean bl) {
        this(bl);
        this.bytes = byArray;
        this.len = byArray.length;
    }

    void set1(byte by, int n) {
        this.bytes[n] = by;
    }

    void set1(int n, int n2) {
        this.bytes[n2] = (byte)n;
    }

    public void set2(int n, int n2) {
        this.bytes[n2 + this.h2] = (byte)(n >> 8);
        this.bytes[n2 + this.l2] = (byte)n;
    }

    public void set4(int n, int n2) {
        this.set2(n >> 16, n2 + this.h4);
        this.set2(n, n2 + this.l4);
    }

    void set8(long l, int n) {
        this.set4((int)(l >> 32), n + this.h8);
        this.set4((int)l, n + this.l8);
    }

    public byte get1(int n) {
        return this.bytes[n];
    }

    public int getS1(int n) {
        return this.bytes[n];
    }

    public int getU1(int n) {
        return this.getS1(n) & 0xFF;
    }

    public int getS2(int n) {
        int n2 = this.bytes[n + this.h2] << 8 | this.bytes[n + this.l2] & 0xFF;
        return n2;
    }

    public int getU2(int n) {
        return this.getS2(n) & 0xFFFF;
    }

    public int getS4(int n) {
        return this.getS2(n + this.h4) << 16 | this.getU2(n + this.l4);
    }

    public long getU4(int n) {
        return (long)this.getS4(n) & 0xFFFFFFFFL;
    }

    public long getS8(int n) {
        return (long)(this.getS4(n + this.h8) << 32) | this.getU4(n + this.l8);
    }
}

