/*
 * Decompiled with CFR 0.152.
 */
package com.kt.io.util;

import com.kt.io.util.BmpHeader;
import com.kt.io.util.ByteArrayManipulator;
import com.kt.io.util.RGBCounter;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class BmpWriter
extends BmpHeader {
    private OutputStream mOs;
    private RGBCounter counter;
    private int[] pix;
    private int wid;
    private int hei;
    private int rgbcount;
    private int rgbquadints;
    private int rgbquadbytes;
    private int widthbytes;

    public static boolean saveBMP(OutputStream outputStream, Image image, int n, int n2) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        boolean bl = false;
        try {
            bl = pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        try {
            BmpWriter bmpWriter = new BmpWriter();
            bmpWriter.write(outputStream, nArray, n, n2);
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public void write(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        this.mOs = outputStream;
        this.pix = nArray;
        this.wid = n;
        this.hei = n2;
        this.counter = new RGBCounter(this.pix, 256);
        this.rgbCount();
        this.widthbytes = (this.wid * this.biBitCount + 31 & 0xFFFFFFE0) >>> 3;
        this.rgbquadbytes = this.rgbquadints << 2;
        this.bfOffBits = 54 + this.rgbquadbytes;
        this.biSizeImage = this.widthbytes * this.hei;
        this.bfSize = this.bfOffBits + this.biSizeImage;
        this.writeFileHeader();
        this.writeInfoHeader();
        this.writeRGBQuad();
        this.writeBody();
    }

    private void rgbCount() {
        this.rgbcount = this.counter.count();
        if (this.rgbcount < 0) {
            this.biBitCount = 24;
            this.rgbquadints = 0;
        } else if (this.rgbcount > 16) {
            this.biBitCount = 8;
            this.rgbquadints = 256;
        } else if (this.rgbcount > 2) {
            this.biBitCount = 4;
            this.rgbquadints = 16;
        } else {
            this.biBitCount = 1;
            this.rgbquadints = 2;
        }
    }

    private void writeFileHeader() throws IOException {
        this.fileheader = new ByteArrayManipulator(14, false);
        this.fileheader.set2(19778, 0);
        this.fileheader.set4(this.bfSize, 2);
        this.fileheader.set4(this.bfOffBits, 10);
        this.mOs.write(this.fileheader.getBytes());
    }

    private void writeInfoHeader() throws IOException {
        this.infoheader = new ByteArrayManipulator(40, false);
        this.infoheader.set4(40, 0);
        this.infoheader.set4(this.wid, 4);
        this.infoheader.set4(this.hei, 8);
        this.infoheader.set2(1, 12);
        this.infoheader.set2(this.biBitCount, 14);
        this.infoheader.set4(this.biSizeImage, 20);
        this.infoheader.set4(4096, 24);
        this.infoheader.set4(4096, 28);
        this.mOs.write(this.infoheader.getBytes());
    }

    private void writeRGBQuad() throws IOException {
        int[] nArray = this.counter.getTable();
        if (nArray == null) {
            return;
        }
        ByteArrayManipulator byteArrayManipulator = new ByteArrayManipulator(this.rgbquadbytes, false);
        int n = 0;
        while (n < this.rgbcount) {
            byteArrayManipulator.set4(nArray[n], n << 2);
            ++n;
        }
        this.mOs.write(byteArrayManipulator.getBytes());
    }

    private void writeBody() throws IOException {
        int n = this.wid * this.hei;
        byte[] byArray = new byte[this.widthbytes];
        int[] nArray = new int[this.wid + 7];
        while (n > 0) {
            n -= this.wid;
            int n2 = 0;
            while (n2 < this.wid) {
                nArray[n2] = this.pix[n + n2];
                ++n2;
            }
            switch (this.biBitCount) {
                case 1: {
                    int n3;
                    int n4;
                    n2 = 0;
                    while (n2 < this.wid) {
                        n4 = n2 >>> 3;
                        n3 = 0;
                        int n5 = 0;
                        while (n5 < 8) {
                            n3 <<= 1;
                            n3 |= this.counter.getIndex(nArray[n2++]);
                            ++n5;
                        }
                        byArray[n4] = (byte)n3;
                    }
                    break;
                }
                case 4: {
                    n2 = 0;
                    while (n2 < this.wid) {
                        byArray[n2 >>> 1] = (byte)(this.counter.getIndex(nArray[n2]) << 4 | this.counter.getIndex(nArray[n2 + 1]));
                        n2 += 2;
                    }
                    break;
                }
                case 8: {
                    n2 = 0;
                    while (n2 < this.wid) {
                        byArray[n2] = (byte)this.counter.getIndex(nArray[n2]);
                        ++n2;
                    }
                    break;
                }
                default: {
                    int n3;
                    n2 = 0;
                    int n4 = 0;
                    while (n4 < this.wid) {
                        n3 = nArray[n4];
                        byArray[n2 + 2] = (byte)(n3 >> 16 & 0xFF);
                        byArray[n2 + 1] = (byte)(n3 >> 8 & 0xFF);
                        byArray[n2 + 0] = (byte)(n3 & 0xFF);
                        n2 += 3;
                        ++n4;
                    }
                    break block0;
                }
            }
            this.mOs.write(byArray);
        }
    }
}

