/*
 * Decompiled with CFR 0.152.
 */
package com.kt.io.util;

import com.kt.io.util.ByteArrayManipulator;

public abstract class BmpHeader {
    public static final int pbfType = 0;
    public static final int pbfSize = 2;
    public static final int pbfReserved1 = 6;
    public static final int pbfReserved2 = 8;
    public static final int pbfOffBits = 10;
    public static final int bf_size = 14;
    public static final int pbiSize = 0;
    public static final int pbiWidth = 4;
    public static final int pbiHeight = 8;
    public static final int pbiPlanes = 12;
    public static final int pbiBitCount = 14;
    public static final int pbiCompression = 16;
    public static final int pbiSizeImage = 20;
    public static final int pbiXPelsPerMeter = 24;
    public static final int pbiYPelsPerMeter = 28;
    public static final int pbiClrUsed = 32;
    public static final int pbiClrImportant = 36;
    public static final int bi_size = 40;
    public int bfType;
    public int bfSize;
    public int bfReserved1;
    public int bfReserved2;
    public int bfOffBits;
    public int biSize;
    public int biWidth;
    public int biHeight;
    public int biPlanes;
    public int biBitCount;
    public int biCompression;
    public int biSizeImage;
    public int biXPelsPerMeter;
    public int biYPelsPerMeter;
    public int biClrUsed;
    public int biClrImportant;
    public ByteArrayManipulator fileheader;
    public ByteArrayManipulator infoheader;

    public String toString() {
        return "bfType          = " + this.fileToHex2(0) + "\n" + "bfSize          = " + this.fileToHex4(2) + "\n" + "bfReserved1     = " + this.fileToHex2(6) + "\n" + "bfReserved2     = " + this.fileToHex2(8) + "\n" + "bfOffBits       = " + this.fileToHex4(10) + "\n" + "biSize          = " + this.infoToHex4(0) + "\n" + "biWidth         = " + this.infoToHex4(4) + "\n" + "biHeight        = " + this.infoToHex4(8) + "\n" + "biPlanes        = " + this.infoToHex2(12) + "\n" + "biBitCount      = " + this.infoToHex2(14) + "\n" + "biCompression   = " + this.infoToHex4(16) + "\n" + "biSizeImage     = " + this.infoToHex4(20) + "\n" + "biXPelsPerMeter = " + this.infoToHex4(24) + "\n" + "biYPelsPerMeter = " + this.infoToHex4(28) + "\n" + "biClrUsed       = " + this.infoToHex4(32) + "\n" + "biClrImportant  = " + this.infoToHex4(36);
    }

    String fileToHex2(int n) {
        return this.toHex2(this.fileheader.getU2(n));
    }

    String fileToHex4(int n) {
        return this.toHex4(this.fileheader.getS4(n));
    }

    String infoToHex2(int n) {
        return this.toHex2(this.infoheader.getU2(n));
    }

    String infoToHex4(int n) {
        return this.toHex4(this.infoheader.getS4(n));
    }

    String toHex2(int n) {
        String string = Integer.toString(n & 0xFFFF, 16);
        while (string.length() < 4) {
            string = "0" + string;
        }
        return "    " + string + " (" + n + ")";
    }

    String toHex4(int n) {
        long l = (long)n & 0xFFFFFFFFL;
        String string = Long.toString(l, 16);
        while (string.length() < 8) {
            string = "0" + string;
        }
        return String.valueOf(string) + " (" + l + ")";
    }
}

