/*
 * Decompiled with CFR 0.152.
 */
package com.kt.io;

import com.kt.io.AbstFile;
import com.kt.io.Base64Decoder;
import com.kt.io.Base64Encoder;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import com.kt.util.xml.XMLManager;
import com.kt.util.xml.XMLWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileSystem {
    private static final String SEPARATOR_CANDIDATE = "\\/";
    private static final char SEPARATOR = '/';
    private ObjectFolder mRootFolder = new ObjectFolder("ROOT");
    private String mBaseDir;

    public FileSystem() {
    }

    public FileSystem(String string) {
        this();
        this.mBaseDir = string;
        if (this.mBaseDir != null && this.mBaseDir.indexOf(92) >= 0) {
            this.mBaseDir = this.mBaseDir.replace('\\', '/');
        }
    }

    public ObjectFolder getRootFolder() {
        return this.mRootFolder;
    }

    public ObjectNode getTargetNode(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR_CANDIDATE);
        ObjectFolder objectFolder = this.mRootFolder;
        if (stringTokenizer.hasMoreElements()) {
            Object object;
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            while (n2 < n - 1) {
                object = stringTokenizer.nextToken();
                objectFolder = FileSystem.getFolder(objectFolder, (String)object);
                ++n2;
            }
            ObjectNode objectNode = objectFolder.getNode(stringTokenizer.nextToken());
            if (objectNode != null && !(objectNode instanceof ObjectFolder)) {
                object = objectNode;
                return object;
            }
        }
        return null;
    }

    public void addFileSystem(String string, boolean bl, String[] stringArray) {
        if (string != null && string.indexOf("\\") >= 0) {
            string = string.replace('\\', '/');
        }
        if (string.equalsIgnoreCase("*")) {
            File file = new File(this.mBaseDir);
            if (file.isDirectory()) {
                String[] stringArray2 = file.list();
                int n = 0;
                while (n < stringArray2.length) {
                    this.addFileSystem(stringArray2[n], this.mRootFolder, bl, stringArray);
                    ++n;
                }
            }
        } else {
            this.addFileSystem(string, this.mRootFolder, bl, stringArray);
        }
    }

    private void addFileSystem(String string, ObjectFolder objectFolder, boolean bl, String[] stringArray) {
        File file = new File(this.mBaseDir, string);
        if (file.isDirectory()) {
            objectFolder = FileSystem.getFolder(objectFolder, file.getName());
            String[] stringArray2 = file.list();
            int n = 0;
            while (n < stringArray2.length) {
                ObjectFolder objectFolder2 = objectFolder;
                this.addFileSystem(String.valueOf(string) + '/' + stringArray2[n], objectFolder2, bl, stringArray);
                ++n;
            }
        } else {
            if (stringArray != null && !FileSystem.isMutchExtention(file.getAbsolutePath(), stringArray)) {
                return;
            }
            byte[] byArray = null;
            if (file.exists() && bl) {
                try {
                    byArray = this.createCache(new FileInputStream(file));
                }
                catch (Exception exception) {
                    byArray = null;
                }
            }
            this.addFile(string, byArray);
        }
    }

    private static boolean isMutchExtention(String string, String[] stringArray) {
        int n = string.lastIndexOf(46);
        if (n >= 0 && string.length() - 1 > n) {
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null && stringArray[n2].equalsIgnoreCase(string2)) {
                    return true;
                }
                ++n2;
            }
        }
        return true;
    }

    public void addFile(String string, byte[] byArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR_CANDIDATE);
        ObjectFolder objectFolder = this.mRootFolder;
        if (stringTokenizer.hasMoreElements()) {
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            while (n2 < n - 1) {
                String string2 = stringTokenizer.nextToken();
                objectFolder = FileSystem.getFolder(objectFolder, string2);
                ++n2;
            }
            objectFolder.addChild(new ObjectNode(stringTokenizer.nextToken(), byArray != null ? Base64Encoder.encode(byArray) : null));
        }
    }

    public void addPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR_CANDIDATE);
        ObjectFolder objectFolder = this.mRootFolder;
        if (stringTokenizer.hasMoreElements()) {
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                objectFolder = FileSystem.getFolder(objectFolder, string2);
                ++n2;
            }
        }
    }

    public void releaseFileSystem() {
        this.release(this.mRootFolder);
        this.mRootFolder = null;
    }

    private void release(ObjectNode objectNode) {
        if (objectNode instanceof ObjectFolder) {
            ObjectFolder objectFolder = (ObjectFolder)objectNode;
            int n = 0;
            while (n < objectFolder.getChildlen().size()) {
                ObjectNode objectNode2 = (ObjectNode)objectFolder.getChildlen().elementAt(n);
                this.release(objectNode2);
                ++n;
            }
            objectFolder.getChildlen().removeAllElements();
        } else {
            objectNode.setParent(null);
            objectNode.setObject(null);
        }
    }

    private static ObjectFolder getFolder(ObjectFolder objectFolder, String string) {
        Vector vector = objectFolder.getNamedElement(string);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                ObjectNode objectNode = (ObjectNode)vector.elementAt(n);
                if (objectNode instanceof ObjectFolder) {
                    return (ObjectFolder)objectNode;
                }
                ++n;
            }
        }
        ObjectFolder objectFolder2 = new ObjectFolder(string);
        objectFolder.addChild(objectFolder2, true);
        return objectFolder2;
    }

    private byte[] createCache(InputStream inputStream) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public byte[] getTransData() {
        try {
            AbstFile abstFile = new AbstFile();
            abstFile.openNewFileToBuffer("");
            PrintStream printStream = new PrintStream(abstFile.getOutpuStreamToBuffer());
            XMLWriter.write((ObjectNode)this.mRootFolder, "", printStream);
            abstFile.closeNewFileToBuffer();
            return abstFile.getData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setTransData(byte[] byArray) {
        XMLManager xMLManager = new XMLManager();
        AbstFile abstFile = new AbstFile();
        abstFile.setData(byArray);
        if (xMLManager.load(abstFile)) {
            this.mRootFolder = xMLManager.getTree();
            FileSystem.decordBinaryData(this.mRootFolder);
        }
    }

    public byte[] searchNode(ObjectFolder objectFolder, String string) {
        if (objectFolder == null) {
            objectFolder = this.mRootFolder;
        }
        int n = 0;
        while (n < objectFolder.getChildlen().size()) {
            Object object;
            Object e = objectFolder.getChildlen().elementAt(n);
            if (e instanceof ObjectFolder) {
                object = this.searchNode((ObjectFolder)e, string);
                if (object != null) {
                    return object;
                }
            } else {
                object = (ObjectNode)e;
                if (((ObjectNode)object).getName() != null && ((ObjectNode)object).getName().equalsIgnoreCase(string) && ((ObjectNode)object).getObject() instanceof byte[]) {
                    return (byte[])((ObjectNode)object).getObject();
                }
            }
            ++n;
        }
        return null;
    }

    private static void decordBinaryData(ObjectNode objectNode) {
        if (objectNode instanceof ObjectFolder) {
            ObjectFolder objectFolder = (ObjectFolder)objectNode;
            if (objectFolder.getChildlen() != null) {
                int n = 0;
                while (n < objectFolder.getChildlen().size()) {
                    ObjectNode objectNode2 = (ObjectNode)objectFolder.getChildlen().elementAt(n);
                    FileSystem.decordBinaryData(objectNode2);
                    ++n;
                }
            }
        } else {
            Object object = objectNode.getObject();
            if (object != null && object instanceof String) {
                objectNode.setObject(Base64Decoder.decode((String)object));
            }
        }
    }
}

