/*
 * Decompiled with CFR 0.152.
 */
package com.kt.gui.tree;

import com.kt.gui.event.ActionContainer;
import com.kt.gui.tree.FolderItem;
import com.kt.gui.tree.NodeItem;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import jp.kitec.kwt.KFont;

public class TreeView
extends Panel
implements MouseListener,
AdjustmentListener,
FocusListener {
    private static final int BOXWIDTH = 8;
    protected ActionContainer mActionContainer = null;
    protected Vector mItem;
    private Rectangle mVirtuallArea;
    private static int mIndent = 5;
    protected static int mSpace = 2;
    protected static int mTab = 20;
    protected KFont mFont;
    protected Scrollbar mHbar;
    protected Scrollbar mVbar;
    protected Point mScroll;
    private Image mOffImage = null;
    private Graphics mOffg = null;
    private int mWidth = -1;
    private int mHeight = -1;
    private int mPrefWidth = -1;
    private int mPrefHeight = -1;
    protected NodeItem mActiveItem = null;
    protected PopupMenu mPopup;
    protected boolean mDispPop = false;
    protected int mMaxIndex = 0;
    protected boolean mPanintLock = false;
    private Object mFocusItem;
    protected Object mPresTmp = null;

    public TreeView(KFont kFont, ActionContainer actionContainer) {
        this.setLayout(new BorderLayout());
        this.setActionContainer(actionContainer);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.mVbar = new Scrollbar(1);
        this.mHbar = new Scrollbar(0);
        this.add((Component)this.mVbar, "East");
        this.add((Component)this.mHbar, "South");
        this.mFont = kFont;
        this.mItem = new Vector();
        this.mVirtuallArea = new Rectangle(0, 0, 0, 0);
        this.setFont(kFont.getFontObject());
        this.mScroll = new Point(0, 0);
        this.addMouseListener(this);
        this.mVbar.addAdjustmentListener(this);
        this.mHbar.addAdjustmentListener(this);
        this.updatePos();
        this.addFocusListener(this);
        this.mPopup = new PopupMenu();
        this.add(this.mPopup);
    }

    public void setActionContainer(ActionContainer actionContainer) {
        this.mActionContainer = actionContainer;
    }

    public void openFolder(FolderItem folderItem) {
        if (folderItem == null) {
            int n = 0;
            while (n < this.mItem.size()) {
                Object e = this.mItem.elementAt(n);
                if (e instanceof FolderItem && !((FolderItem)e).isOpen()) {
                    ((FolderItem)e).flipOpen();
                }
                ++n;
            }
        } else if (!folderItem.isOpen()) {
            folderItem.flipOpen();
        }
        this.updatePos();
    }

    public void closeAll() {
        this.close(null);
        this.updatePos();
        this.repaint();
    }

    public void close(FolderItem folderItem) {
        Vector vector = folderItem == null ? this.mItem : folderItem.getItems();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                NodeItem nodeItem = (NodeItem)vector.elementAt(n);
                if (nodeItem instanceof FolderItem) {
                    FolderItem folderItem2 = (FolderItem)nodeItem;
                    if (folderItem2.isOpen()) {
                        folderItem2.flipOpen();
                    }
                    this.close(folderItem2);
                }
                ++n;
            }
        }
    }

    public void pickup(String string) {
        int n = 0;
        while (n < this.mItem.size()) {
            NodeItem nodeItem = (NodeItem)this.mItem.elementAt(n);
            this.pickup(nodeItem, string);
            ++n;
        }
        this.mScroll.x = 0;
        this.mScroll.y = 0;
        this.mVbar.setValue(0);
        this.mHbar.setValue(0);
        this.updatePos();
        this.repaint();
    }

    private boolean pickup(NodeItem nodeItem, String string) {
        boolean bl = false;
        if (string == null) {
            bl = true;
        }
        if (nodeItem instanceof FolderItem) {
            FolderItem folderItem = (FolderItem)nodeItem;
            if (string == null) {
                folderItem.setVisible(true);
            }
            int n = 0;
            while (n < folderItem.getItems().size()) {
                boolean bl2 = this.pickup((NodeItem)folderItem.getItems().elementAt(n), string);
                bl |= bl2;
                ++n;
            }
            folderItem.setVisible(bl);
        } else if (string == null) {
            nodeItem.setVisible(true);
            bl = true;
        } else if (nodeItem.getTitle().indexOf(string) >= 0) {
            nodeItem.setVisible(true);
            bl = true;
        } else {
            nodeItem.setVisible(false);
        }
        return bl;
    }

    public void deleteAll() {
        this.mItem.removeAllElements();
        this.mActiveItem = null;
    }

    public void updatePos() {
        this.mVirtuallArea.width = mIndent;
        this.mVirtuallArea.height = mIndent;
        this.mMaxIndex = 0;
        int n = 0;
        while (n < this.mItem.size()) {
            this.setItemPosition(this.mItem.elementAt(n), this.mVirtuallArea.x, this.mVirtuallArea.y + this.mVirtuallArea.height);
            ++n;
        }
        this.checkTreeSize();
        this.checkScroll();
        if (this.mVbar.isVisible() || this.mHbar.isVisible()) {
            n = this.mHbar.isVisible() ? -this.mScroll.x : 0;
            int n2 = this.mVbar.isVisible() ? -this.mScroll.y : 0;
            int n3 = 0;
            while (n3 < this.mItem.size()) {
                this.setOffset(this.mItem.elementAt(n3), n, n2);
                ++n3;
            }
        }
        this.mVbar.setBlockIncrement(this.mVbar.getVisibleAmount());
        this.mHbar.setBlockIncrement(this.mHbar.getVisibleAmount());
    }

    public void folderOpenClose() {
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.mOffImage == null || dimension.width != this.mWidth || dimension.height != this.mHeight) {
            this.mOffImage = this.createImage(dimension.width, dimension.height);
            this.mOffg = this.mOffImage.getGraphics();
            this.mWidth = dimension.width;
            this.mHeight = dimension.height;
            this.updatePos();
        }
        this.mOffg.setColor(this.getBackground());
        this.mOffg.fillRect(0, 0, dimension.width - 1, dimension.height);
        int n = 0;
        while (n < this.mItem.size()) {
            NodeItem nodeItem;
            if (this.mItem.elementAt(n) != null && (nodeItem = (NodeItem)this.mItem.elementAt(n)).isVisible()) {
                this.draw(this.mOffg, this.mItem.elementAt(n));
            }
            ++n;
        }
        this.mOffg.setColor(Color.lightGray);
        this.mOffg.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawImage(this.mOffImage, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void checkTreeSize() {
        if (this.mVbar.isVisible()) {
            this.mVirtuallArea.width += this.mVbar.getSize().width;
        }
        if (this.mHbar.isVisible()) {
            this.mVirtuallArea.height += this.mHbar.getSize().height;
        }
    }

    private void checkScroll() {
        int n;
        Dimension dimension = this.getSize();
        if (this.mWidth > 0 && dimension.width < this.mVirtuallArea.width) {
            n = (int)((float)dimension.width / (float)this.mVirtuallArea.width * (float)(this.mVirtuallArea.width - dimension.width));
            this.mHbar.setValues(this.mScroll.x, n, 0, this.mVirtuallArea.width - dimension.width + n);
            this.mHbar.setUnitIncrement((this.mVirtuallArea.width - dimension.width) / 5);
            this.mHbar.setVisible(true);
        } else {
            this.mHbar.setVisible(false);
            this.mScroll.x = 0;
        }
        if (this.mHeight > 0 && dimension.height < this.mVirtuallArea.height) {
            n = (int)((float)dimension.height / (float)this.mVirtuallArea.height * (float)(this.mVirtuallArea.height - dimension.height));
            this.mVbar.setValues(this.mScroll.y, n, 0, this.mVirtuallArea.height - dimension.height + n);
            this.mVbar.setUnitIncrement((int)this.mFont.getSize());
            this.mVbar.setUnitIncrement(5);
            this.mVbar.setVisible(true);
        } else {
            this.mVbar.setVisible(false);
            this.mScroll.y = 0;
        }
        this.doLayout();
    }

    private void setItemPosition(Object object, int n, int n2) {
        FolderItem folderItem;
        if (object instanceof NodeItem && !((NodeItem)object).isVisible()) {
            ((NodeItem)object).mIndex = -1;
            return;
        }
        NodeItem nodeItem = (NodeItem)object;
        nodeItem.mIndex = this.mMaxIndex++;
        Rectangle rectangle = ((NodeItem)object).setPosition(n, n2);
        if (this.mVirtuallArea.width < rectangle.x + rectangle.width) {
            this.mVirtuallArea.width = rectangle.x + rectangle.width;
        }
        if (this.mVirtuallArea.height < rectangle.y + rectangle.height) {
            this.mVirtuallArea.height = rectangle.y + rectangle.height;
        }
        if (this.isFolder(object) && (folderItem = (FolderItem)object).isOpen()) {
            n += mTab;
            int n3 = 0;
            while (n3 < folderItem.getItems().size()) {
                this.setItemPosition(folderItem.getItems().elementAt(n3), n, this.mVirtuallArea.height);
                ++n3;
            }
        }
    }

    protected void setOffset(Object object, int n, int n2) {
        FolderItem folderItem;
        NodeItem nodeItem = (NodeItem)object;
        Rectangle rectangle = nodeItem.getPosition();
        rectangle.x += n;
        rectangle.y += n2;
        if (this.isFolder(nodeItem) && (folderItem = (FolderItem)nodeItem).isOpen()) {
            int n3 = 0;
            while (n3 < folderItem.getItems().size()) {
                this.setOffset(folderItem.getItems().elementAt(n3), n, n2);
                ++n3;
            }
        }
    }

    private void draw(Graphics graphics, Object object) {
        if (object == null) {
            return;
        }
        graphics.setColor(this.getForeground());
        if (this.isFolder(object)) {
            FolderItem folderItem = (FolderItem)object;
            this.drawNode(graphics, folderItem);
            if (folderItem.isOpen() && folderItem.isVisible()) {
                int n = folderItem.getPosition().y + folderItem.getPosition().height;
                int n2 = 0;
                int n3 = 0;
                while (n3 < folderItem.getItems().size()) {
                    NodeItem nodeItem = (NodeItem)folderItem.getItems().elementAt(n3);
                    if (nodeItem.isVisible()) {
                        this.draw(graphics, nodeItem);
                        n2 = nodeItem.getPosition().y + nodeItem.getPosition().height / 2;
                        if (this.isFolder(nodeItem)) {
                            TreeView.drawLineX(graphics, folderItem.getPosition().x + mTab / 2 + mSpace + 1 + 4, n2, nodeItem.getPosition().x, Color.black);
                            TreeView.drawLineY(graphics, folderItem.getPosition().x + mTab / 2 + mSpace, n + 4, n2 - 4, Color.black);
                            n = n2;
                            this.drawBox(graphics, ((FolderItem)nodeItem).isOpen(), folderItem.getPosition().x + mTab / 2 + mSpace - 4, n - 4, 8, 8);
                        } else {
                            TreeView.drawLineX(graphics, folderItem.getPosition().x + mTab / 2 + mSpace + 1, n2, nodeItem.getPosition().x, Color.black);
                            TreeView.drawLineY(graphics, folderItem.getPosition().x + mTab / 2 + mSpace, n, n2, Color.black);
                            n = n2;
                        }
                    }
                    ++n3;
                }
            }
        } else {
            NodeItem nodeItem = (NodeItem)object;
            this.drawNode(graphics, nodeItem);
        }
    }

    protected void drawNode(Graphics graphics, NodeItem nodeItem) {
        if (nodeItem instanceof FolderItem) {
            nodeItem.paint(graphics);
        } else if (nodeItem.isVisible()) {
            nodeItem.paint(graphics);
        }
    }

    private void drawBox(Graphics graphics, boolean bl, int n, int n2, int n3, int n4) {
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawLine(n + 2, n2 + n4 / 2, n + n3 - 2, n2 + n4 / 2);
        if (!bl) {
            graphics.drawLine(n + n3 / 2, n2 + 2, n + n3 / 2, n2 + n4 - 2);
        }
    }

    protected Object isHit(int n, int n2) {
        int n3 = 0;
        while (n3 < this.mItem.size()) {
            Object object;
            if (this.mItem.elementAt(n3) != null && (object = this.isHit(this.mItem.elementAt(n3), n, n2)) != null) {
                return object;
            }
            ++n3;
        }
        return null;
    }

    private Object isHit(Object object, int n, int n2) {
        NodeItem nodeItem = (NodeItem)object;
        if (!nodeItem.isVisible()) {
            return null;
        }
        Rectangle rectangle = nodeItem.getPosition();
        if (rectangle.contains(n, n2)) {
            return nodeItem;
        }
        if (this.isFolder(nodeItem)) {
            int n3 = 4;
            int n4 = rectangle.x - 8;
            int n5 = rectangle.y + rectangle.height / 2;
            if (Math.abs(n - n4) <= n3 && Math.abs(n2 - n5) <= n3) {
                return nodeItem;
            }
            FolderItem folderItem = (FolderItem)nodeItem;
            if (folderItem.isOpen()) {
                int n6 = 0;
                while (n6 < folderItem.getItems().size()) {
                    Object object2 = this.isHit(folderItem.getItems().elementAt(n6), n, n2);
                    if (object2 != null) {
                        return object2;
                    }
                    ++n6;
                }
            }
        }
        return null;
    }

    protected boolean isFolder(Object object) {
        return object instanceof FolderItem;
    }

    protected static void drawLineX(Graphics graphics, int n, int n2, int n3, Color color) {
        graphics.setColor(color);
        while (n < n3) {
            graphics.drawLine(n, n2, n, n2);
            n += 2;
        }
    }

    protected static void drawLineY(Graphics graphics, int n, int n2, int n3, Color color) {
        graphics.setColor(color);
        while (n2 < n3) {
            graphics.drawLine(n, n2, n, n2);
            n2 += 2;
        }
    }

    public void conv(ObjectFolder objectFolder, Image image, Image image2, Image image3) {
        int n = 0;
        while (n < objectFolder.getChildlen().size()) {
            this.addNode(null, (ObjectNode)objectFolder.getChildlen().elementAt(n), image, image2, image3);
            ++n;
        }
    }

    private NodeItem addNode(FolderItem folderItem, ObjectNode objectNode, Image image, Image image2, Image image3) {
        if (objectNode instanceof ObjectFolder) {
            FolderItem folderItem2 = this.addFolder(folderItem, objectNode.getName(), image2, image);
            int n = 0;
            while (n < ((ObjectFolder)objectNode).getChildlen().size()) {
                ObjectNode objectNode2 = (ObjectNode)((ObjectFolder)objectNode).getChildlen().elementAt(n);
                this.addNode(folderItem2, objectNode2, image, image2, image3);
                ++n;
            }
            return folderItem2;
        }
        return this.addNode(folderItem, objectNode.getName(), image3);
    }

    public NodeItem addNode(Object object, String string, Image image) {
        NodeItem nodeItem = new NodeItem(object, string, image, mSpace, this.mFont);
        if (object == null) {
            this.mItem.addElement(nodeItem);
        } else if (this.isFolder(object)) {
            ((FolderItem)object).addChild(nodeItem);
        }
        return nodeItem;
    }

    public FolderItem addFolder(Object object, String string, Image image, Image image2) {
        FolderItem folderItem = new FolderItem(object, string, image, image2, mSpace, this.mFont);
        if (folderItem == null) {
            return null;
        }
        if (object == null) {
            this.mItem.addElement(folderItem);
        } else if (this.isFolder(object)) {
            ((FolderItem)object).addChild(folderItem);
        }
        return folderItem;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.mPrefWidth > 0) {
            dimension.width = this.mPrefWidth;
        }
        if (this.mPrefHeight > 0) {
            dimension.height = this.mPrefHeight;
        }
        return dimension;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mFocusItem != null) {
            this.mActionContainer.actionlostfocus((NodeItem)this.mFocusItem);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mPresTmp = this.isHit(mouseEvent.getX(), mouseEvent.getY());
        if (!this.isFolder(this.mPresTmp)) {
            NodeItem nodeItem = (NodeItem)this.mPresTmp;
            if (nodeItem == null) {
                return;
            }
            if (nodeItem != this.mActiveItem) {
                if (this.mActiveItem != null) {
                    this.mActiveItem.setActive(false);
                }
                nodeItem.setActive(true);
                this.mActiveItem = nodeItem;
                if (!this.mPanintLock) {
                    this.repaint();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = this.isHit(mouseEvent.getX(), mouseEvent.getY());
        if (object != null && object == this.mPresTmp) {
            if (this.isFolder(this.mPresTmp)) {
                ((FolderItem)this.mPresTmp).flipOpen();
                this.folderOpenClose();
                this.updatePos();
                if (!this.mPanintLock) {
                    this.repaint();
                }
            } else {
                NodeItem nodeItem = (NodeItem)this.mPresTmp;
                if (nodeItem != this.mActiveItem) {
                    if (this.mActiveItem != null) {
                        this.mActiveItem.setActive(false);
                    }
                    nodeItem.setActive(true);
                    this.mActiveItem = nodeItem;
                    if (!this.mPanintLock) {
                        this.repaint();
                    }
                }
                this.mActionContainer.actionperform(nodeItem);
            }
        }
        this.mPresTmp = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Object object = this.isHit(mouseEvent.getX(), mouseEvent.getY());
        if (object == this.mFocusItem) {
            return;
        }
        if (object != this.mFocusItem && this.mFocusItem != null) {
            this.mActionContainer.actionlostfocus((NodeItem)this.mFocusItem);
        }
        if (object == null || object instanceof FolderItem) {
            this.mFocusItem = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.mFocusItem = (NodeItem)object;
        this.mActionContainer.actionfocus((NodeItem)this.mFocusItem);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.mVbar) {
            this.mScroll.y = adjustmentEvent.getValue();
        } else if (adjustmentEvent.getSource() == this.mHbar) {
            this.mScroll.x = adjustmentEvent.getValue();
        }
        this.updatePos();
        if (!this.mPanintLock) {
            this.repaint();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.mDispPop = false;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.mDispPop = false;
    }

    protected synchronized void goPop(MouseEvent mouseEvent) {
        this.createContext();
        if (this.mPopup.getItemCount() != 0) {
            this.mDispPop = true;
            this.mPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected void createContext() {
    }

    protected NodeItem getNextItem(NodeItem nodeItem) {
        int n = nodeItem.mIndex;
        if (n + 1 >= this.mMaxIndex) {
            return null;
        }
        return this.searchIndex(n + 1);
    }

    protected NodeItem getPrevItem(NodeItem nodeItem) {
        int n = nodeItem.mIndex;
        if (n == 0) {
            return null;
        }
        return this.searchIndex(n - 1);
    }

    protected NodeItem searchIndex(int n) {
        int n2 = 0;
        while (n2 < this.mItem.size()) {
            NodeItem nodeItem = this.searchIndex(n, (NodeItem)this.mItem.elementAt(n2));
            if (nodeItem != null) {
                return nodeItem;
            }
            ++n2;
        }
        return null;
    }

    protected NodeItem searchIndex(int n, NodeItem nodeItem) {
        FolderItem folderItem;
        if (nodeItem.mIndex == n) {
            return nodeItem;
        }
        if (this.isFolder(nodeItem) && (folderItem = (FolderItem)nodeItem).isOpen()) {
            int n2 = 0;
            while (n2 < folderItem.getItems().size()) {
                NodeItem nodeItem2 = this.searchIndex(n, (NodeItem)folderItem.getItems().elementAt(n2));
                if (nodeItem2 != null) {
                    return nodeItem2;
                }
                ++n2;
            }
        }
        return null;
    }

    protected void updateScrollPos() {
        if (this.mActiveItem != null && this.mVbar.isVisible()) {
            Dimension dimension = this.getSize();
            if (this.mActiveItem.getPosition().y < 0) {
                this.adjustmentValueChanged(new AdjustmentEvent(this.mVbar, 0, 0, this.mScroll.y + this.mActiveItem.getPosition().y));
            } else {
                if (this.mHbar.isVisible()) {
                    dimension.height -= this.mHbar.getHeight();
                }
                if (dimension.height - (this.mActiveItem.getPosition().y + this.mActiveItem.getPosition().height) < 0) {
                    this.adjustmentValueChanged(new AdjustmentEvent(this.mVbar, 0, 0, this.mScroll.y - (dimension.height - (this.mActiveItem.getPosition().y + this.mActiveItem.getPosition().height))));
                }
            }
            this.updatePos();
        }
    }

    protected void setVScrollPos(int n) {
        if (this.mVbar != null && this.mVbar.isVisible()) {
            this.mVbar.setValue(n);
        }
    }

    protected int getVScrollPos() {
        if (this.mVbar != null && this.mVbar.isVisible()) {
            return this.mVbar.getValue();
        }
        return 0;
    }
}

