/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class Separater
extends Container {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final int LINE_WIDTH = 2;
    private int mX1;
    private int mY1;
    private int mX2;
    private int mY2;
    private int mOrientation;
    private Insets mInsets;

    public Separater(int n) {
        this.mOrientation = n;
        this.setInsets(0, 0, 0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.mOrientation == 0) {
            dimension.height = 2;
        } else {
            dimension.width = 2;
        }
        return dimension;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(n, n2, n3, n4);
    }

    @Override
    public Insets getInsets() {
        return this.mInsets;
    }

    public int getOrientaion() {
        return this.mOrientation;
    }

    @Override
    public void paint(Graphics graphics) {
        this.setFirstLinePosition();
        graphics.setColor(Color.gray);
        graphics.drawLine(this.mX1, this.mY1, this.mX2, this.mY2);
        this.setSecondLinePosition();
        graphics.setColor(Color.white);
        graphics.drawLine(this.mX1, this.mY1, this.mX2, this.mY2);
    }

    private void setFirstLinePosition() {
        if (this.mOrientation == 0) {
            this.mX1 = this.mInsets.left;
            this.mY1 = this.mY2 = (this.getSize().height - this.mInsets.top - this.mInsets.bottom - 2) / 2;
            this.mX2 = this.getSize().width - this.mInsets.left - this.mInsets.right;
        } else {
            this.mX1 = this.mX2 = (this.getSize().width - this.mInsets.left - this.mInsets.right - 2) / 2;
            this.mY1 = this.mInsets.top;
            this.mY2 = this.getSize().height - this.mInsets.top - this.mInsets.bottom;
        }
    }

    private void setSecondLinePosition() {
        if (this.mOrientation == 0) {
            this.mY1 = this.mY2 = this.mY1 + 1;
        } else {
            this.mX1 = this.mX2 = this.mX1 + 1;
        }
    }
}

