/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import gui.basic.ErrorIconPanel;
import gui.basic.IconPanel;
import gui.basic.ImageIcon;
import gui.basic.InfoIconPanel;
import gui.basic.LabelComponent;
import gui.basic.WarningIconPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class OptionDialog
extends Dialog
implements ActionListener,
KeyListener {
    public static final int CLOSE_OK = 0;
    public static final int CLOSE_CANCEL = 1;
    public static final int CLOSE_YES = 2;
    public static final int CLOSE_NO = 3;
    public static final int BUTTON_NONE = 0;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CLOSE = 2;
    public static final int BUTTON_CANCEL = 4;
    public static final int BUTTON_YES = 8;
    public static final int BUTTON_NO = 16;
    public static final int ICON_NONE = -1;
    public static final int ICON_INFO = 0;
    public static final int ICON_WARNING = 1;
    public static final int ICON_ERROR = 2;
    protected static final int IDX_OK = 0;
    protected static final int IDX_SELECT = 1;
    protected static final int IDX_CLOSE = 2;
    protected static final int IDX_CANCEL = 3;
    protected static final int IDX_YES = 4;
    protected static final int IDX_NO = 5;
    protected static final int NUMBER_OF_BUTTONS = 6;
    protected String[] BUTTON_NAMES = new String[]{"\u3000\u3000OK\u3000\u3000", "\u3000SELECT\u3000", "\u3000\u9589\u3058\u308b\u3000", "\u3000 \uff77\uff6c\uff9d\uff7e\uff99 \u3000", "\u3000 \u306f\u3044 \u3000", "\u3000\u3044\u3044\u3048\u3000"};
    protected static final String DIALOG_DIRECTORY = "dialog";
    protected static final String BACKGROUND_IMAGE = "background.gif";
    protected static IconPanel[] mIcons = null;
    protected Button[] mButtons;
    protected Button mBtnExec;
    protected int mCloseState = 1;
    protected Frame mFrame;
    protected Object mObject;

    public OptionDialog(Frame frame, Object object, String string, int n) {
        this(frame, object, string, n, -1);
        this.mFrame = frame;
    }

    public OptionDialog(Frame frame, Object object, String string, int n, int n2) {
        super(frame, string, true);
        this.mFrame = frame;
        this.initDialog(object, n, n2);
    }

    public OptionDialog(Frame frame, Object object, String string, int n, int n2, boolean bl) {
        super(frame, string, bl);
        this.mFrame = frame;
        this.initDialog(object, n, n2);
    }

    public OptionDialog(Frame frame, Object object, String string, int n, int n2, String[] stringArray) {
        super(frame, string, true);
        this.mFrame = frame;
        int n3 = 0;
        while (n3 < Math.min(this.BUTTON_NAMES.length, stringArray.length)) {
            this.BUTTON_NAMES[n3] = stringArray[n3];
            ++n3;
        }
        this.initDialog(object, n, n2);
    }

    protected void initDialog(Object object, int n, int n2) {
        this.setObject(object);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 10));
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        } else if (object instanceof String) {
            component = this.createStringContent(new String[]{(String)object});
        } else if (object instanceof String[]) {
            component = this.createStringContent((String[])object);
        } else if (object instanceof Image) {
            component = this.createImageContent((Image)object);
        }
        if (component != null) {
            panel.add(component, "Center");
        }
        this.initIcons();
        component = this.createIcon(n2);
        if (component != null) {
            panel.add(component, "West");
        }
        this.initButton();
        component = this.createButtons(n);
        if (component != null) {
            panel.add(component, "South");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                OptionDialog.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.addKeyListener(this);
        this.pack();
    }

    protected Component createStringContent(String[] stringArray) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(stringArray.length, 1));
        Font font = new Font("Courier", 0, 12);
        Insets insets = stringArray.length > 1 ? new Insets(2, 20, 2, 20) : new Insets(5, 20, 5, 20);
        int n = 0;
        while (n < stringArray.length) {
            LabelComponent labelComponent = new LabelComponent(stringArray[n]);
            labelComponent.setFont(font);
            labelComponent.setInsets(insets);
            panel.add(labelComponent);
            ++n;
        }
        return panel;
    }

    protected Component createImageContent(Image image) {
        return new ImageIcon(image);
    }

    protected Component createIcon(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                Panel panel = new Panel();
                panel.setLayout(new FlowLayout(1, 10, 10));
                panel.add(mIcons[n]);
                return panel;
            }
        }
        return null;
    }

    protected Component createButtons(int n) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        if (n == 0) {
            return null;
        }
        this.mBtnExec = null;
        if ((n & 1) != 0) {
            this.mBtnExec = this.mButtons[0];
        } else if ((n & 8) != 0) {
            this.mBtnExec = this.mButtons[4];
        }
        if (this.mBtnExec != null) {
            panel.add(this.mBtnExec);
        }
        if ((n & 0x10) != 0) {
            panel.add(this.mButtons[5]);
        }
        Button button = null;
        if ((n & 2) != 0) {
            button = this.mButtons[2];
        } else if ((n & 4) != 0) {
            button = this.mButtons[3];
        }
        if (button != null) {
            panel.add(button);
        }
        return panel;
    }

    protected void initIcons() {
        if (mIcons == null) {
            mIcons = new IconPanel[3];
            OptionDialog.mIcons[0] = new InfoIconPanel();
            OptionDialog.mIcons[1] = new WarningIconPanel();
            OptionDialog.mIcons[2] = new ErrorIconPanel();
        }
    }

    protected void initButton() {
        this.mButtons = new Button[this.BUTTON_NAMES.length];
        int n = 0;
        while (n < this.BUTTON_NAMES.length) {
            this.mButtons[n] = new Button(this.BUTTON_NAMES[n]);
            this.mButtons[n].addActionListener(this);
            ++n;
        }
    }

    public Object getObject() {
        return this.mObject;
    }

    protected void setObject(Object object) {
        this.mObject = object;
    }

    public void showDialog() {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        Container container = this.getParent();
        if (container == null) {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            n2 = (dimension2.width - dimension.width) / 2;
            n = (dimension2.height - dimension.height) / 2;
        } else {
            Dimension dimension3 = container.getSize();
            Point point = container.getLocationOnScreen();
            n2 = point.x + (dimension3.width - dimension.width) / 2;
            n = point.y + (dimension3.height - dimension.height) / 2;
        }
        this.setLocation(n2, n);
        if (container != null) {
            container.setEnabled(false);
        }
        this.setVisible(true);
    }

    public void closeDialog() {
        Container container = this.getParent();
        if (container != null) {
            container.setEnabled(true);
        }
        this.setVisible(false);
        this.dispose();
    }

    protected int searchButton(Object object) {
        int n = 0;
        while (n < this.mButtons.length) {
            if (this.mButtons[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getCloseState() {
        return this.mCloseState;
    }

    protected void onButtonDown(Object object) {
        switch (this.searchButton(object)) {
            case 4: {
                this.mCloseState = 2;
                break;
            }
            case 0: 
            case 1: {
                this.mCloseState = 0;
                break;
            }
            case 5: {
                this.mCloseState = 3;
                break;
            }
            case 2: 
            case 3: {
                this.mCloseState = 1;
            }
        }
        this.closeDialog();
    }

    public Frame getFrame() {
        return this.mFrame;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.onButtonDown(actionEvent.getSource());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 10) {
            return;
        }
        this.onButtonDown(keyEvent.getSource());
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

