/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;

public class LabelComponent
extends Component {
    public static final Insets DEF_INSETS = new Insets(0, 0, 0, 0);
    public static final Font DEF_FONT = new Font("Dialog", 0, 12);
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private static final Color DEF_DESABLED_COLOR = new Color(192, 192, 192);
    private String mText;
    private Font mFont;
    private Insets mIns;
    private int mAlignment;
    private Color mColor;
    private Color mOldColor;
    private int mStrLen;

    public LabelComponent() {
        this(null, 1);
    }

    public LabelComponent(String string) {
        this(string, 1);
    }

    public LabelComponent(String string, int n) {
        this.mText = string;
        switch (n) {
            case 0: 
            case 2: {
                this.mAlignment = n;
            }
        }
        this.mAlignment = 1;
        this.mFont = DEF_FONT;
        this.mIns = DEF_INSETS;
        this.mColor = Color.black;
    }

    public LabelComponent(int n, int n2) {
        this(null, n2);
        this.mStrLen = n;
    }

    public String getText() {
        if (this.mText == null) {
            return null;
        }
        return new String(this.mText);
    }

    @Override
    public Font getFont() {
        return new Font(this.mFont.getFontName(), this.mFont.getStyle(), this.mFont.getSize());
    }

    public Insets getInsets() {
        return new Insets(this.mIns.top, this.mIns.left, this.mIns.bottom, this.mIns.right);
    }

    public int getAlignment() {
        return this.mAlignment;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.mFont == null) {
            return dimension;
        }
        if (this.mText == null && this.mStrLen <= 0) {
            return dimension;
        }
        int n = 0;
        int n2 = 0;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return dimension;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.mFont);
        if (this.mText != null) {
            n = fontMetrics.stringWidth(this.mText);
            n2 = fontMetrics.getHeight();
        }
        if (this.mStrLen > 0) {
            int n3 = this.mStrLen * fontMetrics.stringWidth("\u3042");
            n2 = fontMetrics.getHeight();
            if (n3 > n) {
                n = n3;
            }
        }
        graphics.dispose();
        if (this.mIns != null) {
            n2 = n2 + this.mIns.top + this.mIns.bottom;
            n = n + this.mIns.left + this.mIns.right;
        }
        if (dimension.width < n) {
            dimension.width = n;
        }
        if (dimension.height < n2) {
            dimension.height = n2;
        }
        return dimension;
    }

    public void setText(String string) {
        if (this.mText != null && this.mText.compareTo(string) == 0) {
            return;
        }
        this.mText = string;
        this.repaint();
    }

    @Override
    public void setFont(Font font) {
        this.mFont = font;
        this.repaint();
    }

    public void setColor(Color color) {
        this.mColor = color;
        this.repaint();
    }

    public void setInsets(Insets insets) {
        this.mIns = insets;
        this.repaint();
    }

    public void setAlignment(int n) {
        switch (n) {
            case 0: 
            case 2: {
                this.mAlignment = n;
            }
        }
        this.mAlignment = 1;
        this.repaint();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        if (bl) {
            if (this.mOldColor != null) {
                this.mColor = this.mOldColor;
            }
        } else {
            this.mOldColor = this.mColor;
            this.mColor = DEF_DESABLED_COLOR;
        }
        super.setEnabled(bl);
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        if (this.mText == null || this.mFont == null || this.mColor == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.mFont);
        int n = 0;
        switch (this.mAlignment) {
            case 0: {
                Dimension dimension = this.getPreferredSize();
                n = (dimension.width - fontMetrics.stringWidth(this.mText)) / 2;
                break;
            }
            case 2: {
                Dimension dimension = this.getPreferredSize();
                n = dimension.width - this.mIns.right;
                break;
            }
            default: {
                n += this.mIns.left;
            }
        }
        int n2 = fontMetrics.getHeight();
        if (this.mIns != null) {
            n2 += this.mIns.top;
        }
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(this.mFont);
        graphics.setColor(this.mColor);
        graphics.drawString(this.mText, n, n2);
        graphics.setFont(font);
        graphics.setColor(color);
    }
}

