/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import gui.basic.OptionDialog;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

public class KProgressBar
extends OptionDialog {
    private Label mMsg;
    private MsgThread mThread;
    private long mInterval;
    private Panel mPanel;

    public KProgressBar(Frame frame, String string, int n) {
        this(frame, string, n, 750L);
    }

    public KProgressBar(Frame frame, String string, int n, long l) {
        super(frame, null, string, 0, -1, false);
        this.mInterval = l;
        this.mMsg = this.createProgressComponent(n);
        this.mPanel.setBackground(this.getBackground());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        gridBagLayout.setConstraints(this.mMsg, gridBagConstraints);
        this.mPanel.add(this.mMsg);
        this.pack();
    }

    @Override
    protected void initDialog(Object object, int n, int n2) {
        this.mPanel = new Panel();
        super.initDialog(this.mPanel, n, n2);
    }

    private Label createProgressComponent(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("illegal progressbar length " + n + " <= 0");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\u25a0");
            ++n2;
        }
        Label label = new Label(stringBuffer.toString());
        label.setForeground(new Color(8, 36, 107));
        return label;
    }

    private void setMesssage(String string) {
        this.mMsg.setText(string);
        this.mMsg.repaint();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.startMessage();
        } else {
            this.stopMessage();
        }
        super.setVisible(bl);
    }

    private void startMessage() {
        if (this.mThread != null) {
            this.stopMessage();
        }
        this.mThread = new MsgThread(this.mMsg.getText(), this.mInterval);
        this.mMsg.setText("");
        this.mThread.start();
    }

    private void stopMessage() {
        if (this.mThread != null) {
            this.mThread.stopShowing();
            this.mThread = null;
        }
    }

    private class MsgThread
    extends Thread {
        private final String mMsg;
        private final int mMax;
        private int mLen;
        private boolean mShowing;

        public MsgThread(String string, long l) {
            this.mMsg = string;
            this.mMax = this.mMsg.length();
            this.mLen = 0;
            KProgressBar.this.mInterval = l;
        }

        public synchronized void stopShowing() {
            this.mShowing = false;
        }

        private synchronized boolean isShowing() {
            return this.mShowing;
        }

        @Override
        public void run() {
            this.mShowing = true;
            while (this.isShowing()) {
                if (this.mLen > this.mMax) {
                    this.mLen = 0;
                }
                KProgressBar.this.setMesssage(this.mMsg.substring(0, this.mLen));
                ++this.mLen;
                try {
                    MsgThread.sleep(750L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

