/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import gui.basic.DissolveFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;

public class ImageIcon
extends Component {
    private Image mImage;
    private Image mDisabledImage;
    private boolean mIsEnabled = true;

    public ImageIcon(Image image) {
        this.setImage(image);
    }

    public static Image getImageChangedAlpha(Image image, int n, Component component) {
        if (image == null) {
            return null;
        }
        Image image2 = component.createImage(new FilteredImageSource(image.getSource(), new DissolveFilter(n)));
        ImageIcon.waitForImage(component, image2);
        return image2;
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public Image getImage() {
        return this.mImage;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mImage != null) {
            return new Dimension(this.mImage.getWidth(null), this.mImage.getHeight(null));
        }
        return super.getPreferredSize();
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setImage(Image image) {
        if (this.mImage == image || image == null) {
            return;
        }
        this.mImage = image;
        ImageIcon.waitForImage(this, this.mImage);
        this.repaint();
    }

    @Override
    public synchronized void setEnabled(boolean bl) {
        if (this.mIsEnabled == bl) {
            return;
        }
        this.mIsEnabled = bl;
        if (this.mImage == null) {
            return;
        }
        if (!bl && this.mDisabledImage == null) {
            this.mDisabledImage = ImageIcon.getImageChangedAlpha(this.mImage, 128, this);
        }
        this.repaint();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintIcon(graphics, 0, 0);
    }

    public void paintIcon(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            if (this.mImage != null) {
                graphics.drawImage(this.mImage, n, n2, this);
            }
        } else if (this.mDisabledImage != null) {
            graphics.drawImage(this.mDisabledImage, n, n2, this);
        }
    }

    public void paintIcon(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.isEnabled()) {
            if (this.mImage != null) {
                graphics.drawImage(this.mImage, n, n2, n3, n4, this);
            }
        } else if (this.mDisabledImage != null) {
            graphics.drawImage(this.mDisabledImage, n, n2, n3, n4, this);
        }
    }
}

