/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;

class IconPanel
extends Panel {
    protected static final Font mFont = new Font("Courier", 1, 24);
    protected static final int mIconSize = 32;
    protected static final int mBorderWidth = 4;

    IconPanel() {
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(32, 32);
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintBackground(graphics, this.getIconBackgroundColor());
        this.paintSymbol(graphics, this.getSymbol(), this.getSymbolColor());
    }

    protected Color getIconBackgroundColor() {
        return Color.blue;
    }

    protected String getSymbol() {
        return "\uff01";
    }

    protected Color getSymbolColor() {
        return Color.white;
    }

    protected void paintBackground(Graphics graphics, Color color) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 32, 32);
        graphics.setColor(color);
        graphics.fillRect(4, 4, 24, 24);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, 31, 31);
        graphics.drawRect(4, 4, 23, 23);
    }

    protected void paintSymbol(Graphics graphics, String string, Color color) {
        graphics.setColor(color);
        graphics.setFont(mFont);
        int n = (this.getSize().width - graphics.getFontMetrics().stringWidth(string)) / 2;
        graphics.drawString(string, n, 24);
    }
}

