/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import gui.basic.ImageIcon;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class GraphicsButton
extends Component {
    public static final int STATE_NORMAL = 1;
    public static final int STATE_PRESSED = 0;
    private int mState = 1;
    protected ImageIcon mForeImage;
    protected ImageIcon mFocusImage;
    private ActionListener mActionListener;
    private boolean mMouseEntered;
    private boolean mMousePressed;

    public GraphicsButton(String string, Image image, Image image2) {
        this.setName(string);
        if (image != null) {
            this.mForeImage = new ImageIcon(image);
        }
        if (image2 != null) {
            this.mFocusImage = new ImageIcon(image2);
        }
        this.addMouseListener(new ButtonMouseAdapter());
        this.addMouseMotionListener(new ButtonMouseMotionAdapter());
    }

    public int getState() {
        return this.mState;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mForeImage != null) {
            return this.mForeImage.getPreferredSize();
        }
        if (this.mFocusImage != null) {
            return this.mFocusImage.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    protected void setState(int n) {
        if (this.mState == n || n != 1 && n != 0) {
            return;
        }
        this.mState = n;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        if (this.mForeImage != null) {
            this.mForeImage.setEnabled(bl);
        }
        super.setEnabled(bl);
        this.repaint();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.mForeImage != null) {
            this.mForeImage.paint(graphics);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.mMouseEntered && this.mFocusImage != null) {
            this.mFocusImage.paint(graphics);
        }
    }

    protected void paintButtonNormal() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getState() == 0) {
            Point point = this.getLocation();
            this.setLocation(point.x - 1, point.y - 1);
        }
        this.setState(1);
    }

    protected void paintButtonPressed() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getState() == 1) {
            Point point = this.getLocation();
            this.setLocation(point.x + 1, point.y + 1);
        }
        this.setState(0);
    }

    public void addActionListener(ActionListener actionListener) {
        this.mActionListener = AWTEventMulticaster.add(this.mActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.mActionListener = AWTEventMulticaster.remove(this.mActionListener, actionListener);
    }

    protected void dispatchEvent() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mActionListener != null) {
            this.mActionListener.actionPerformed(new ActionEvent(this, 1001, "GraphicButton Action"));
        }
    }

    class ButtonMouseAdapter
    extends MouseAdapter {
        ButtonMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            GraphicsButton.this.paintButtonPressed();
            GraphicsButton.this.mMousePressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            GraphicsButton.this.paintButtonNormal();
            if (GraphicsButton.this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.onButtonDown();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            GraphicsButton.this.mMouseEntered = true;
            if (GraphicsButton.this.mFocusImage != null) {
                GraphicsButton.this.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            GraphicsButton.this.mMouseEntered = false;
            if (GraphicsButton.this.mFocusImage != null) {
                GraphicsButton.this.repaint();
            }
        }

        private void onButtonDown() {
            if (GraphicsButton.this.mMouseEntered && GraphicsButton.this.mMousePressed) {
                GraphicsButton.this.dispatchEvent();
                GraphicsButton.this.mMousePressed = false;
            }
        }
    }

    class ButtonMouseMotionAdapter
    extends MouseMotionAdapter {
        ButtonMouseMotionAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (GraphicsButton.this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                if (GraphicsButton.this.mState == 1) {
                    GraphicsButton.this.paintButtonPressed();
                }
            } else if (GraphicsButton.this.mState == 0) {
                GraphicsButton.this.paintButtonNormal();
            }
        }
    }
}

