/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;

public class Box
extends Panel {
    public static final Color DEF_DISABLED_COLOR = new Color(128, 128, 128);
    private Insets mInsets;
    private FontMetrics mFm;
    private String mTitle;
    private Color mTitleColor;
    private Color mBorderColor;
    private Font mFont;

    public Box(String string, Font font) {
        this.setFont(font);
        this.mTitle = string;
        this.setInsets(2, 5, 5, 5);
        this.setTitleColor(Color.black);
        this.setBorderColor(Color.black);
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public String getTitle() {
        return this.mTitle;
    }

    @Override
    public void setFont(Font font) {
        this.mFont = font;
        this.mFm = this.getFontMetrics(this.mFont);
    }

    @Override
    public Font getFont() {
        return this.mFont;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(this.mFm.getHeight() + n, n2, n3, n4);
    }

    public void setTitleColor(Color color) {
        this.mTitleColor = color;
    }

    public Color getTitleColor() {
        if (this.isEnabled()) {
            return this.mTitleColor;
        }
        return DEF_DISABLED_COLOR;
    }

    public void setBorderColor(Color color) {
        this.mBorderColor = color;
    }

    public Color getBorderColor() {
        if (this.isEnabled()) {
            return this.mBorderColor;
        }
        return DEF_DISABLED_COLOR;
    }

    @Override
    public void setEnabled(boolean bl) {
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            this.getComponent(n2).setEnabled(bl);
            ++n2;
        }
        super.setEnabled(bl);
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.mFm.getHeight() / 4 * 3;
        graphics.setColor(this.getBorderColor());
        graphics.drawLine(2, n, 2, dimension.height - 1);
        graphics.drawLine(dimension.width - 2, n, dimension.width - 2, dimension.height - 1);
        graphics.drawLine(2, dimension.height - 1, dimension.width - 2, dimension.height - 1);
        if (this.mTitle != null && this.mTitle.length() > 0) {
            int n2 = (dimension.width - this.mFm.stringWidth(this.mTitle)) / 2 - 3;
            int n3 = dimension.width - n2;
            graphics.drawLine(2, n, n2, n);
            graphics.drawLine(n3, n, dimension.width - 2, n);
            graphics.setColor(this.getTitleColor());
            graphics.setFont(this.mFont);
            graphics.drawString(this.mTitle, (dimension.width - this.mFm.stringWidth(this.mTitle)) / 2, this.mFm.getHeight());
        } else {
            graphics.drawLine(2, n, dimension.width - 2, n);
        }
    }

    @Override
    public Insets getInsets() {
        return this.mInsets;
    }
}

